/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FilteringMarkupIterator;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.util.Getter;
import org.jetbrains.annotations.NotNull;

class RangeHighlighterTree
extends RangeMarkerTree<RangeHighlighterEx> {
    private final MarkupModelEx myMarkupModel;

    RangeHighlighterTree(@NotNull Document document, @NotNull MarkupModelEx markupModel) {
        super(document);
        this.myMarkupModel = markupModel;
    }

    @Override
    protected boolean keepIntervalsOnWeakReferences() {
        return false;
    }

    @NotNull
    MarkupIterator<RangeHighlighterEx> overlappingIterator(@NotNull TextRangeInterval rangeInterval, boolean onlyRenderedInGutter) {
        MarkupIterator iterator2 = this.overlappingIterator(rangeInterval, node -> !onlyRenderedInGutter || node.isFlagSet((byte)64));
        return new FilteringMarkupIterator<RangeHighlighterEx>(iterator2, highlighter -> !onlyRenderedInGutter || highlighter.isRenderedInGutter());
    }

    void updateRenderedFlags(RangeHighlighterEx highlighter) {
        RHNode node = (RHNode)this.lookupNode(highlighter);
        if (node != null) {
            node.recalculateRenderFlagsUp();
        }
    }

    @Override
    void correctMax(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> node, int deltaUpToRoot) {
        super.correctMax(node, deltaUpToRoot);
        ((RHNode)node).recalculateRenderFlags();
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i1, @NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i2) {
        RHNode o1 = (RHNode)i1;
        RHNode o2 = (RHNode)i2;
        int d = o2.myLayer - o1.myLayer;
        if (d != 0) {
            return d;
        }
        return super.compareEqualStartIntervals(i1, i2);
    }

    @NotNull
    protected RHNode createNewNode(@NotNull RangeHighlighterEx key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        return new RHNode(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
    }

    @Override
    void fireBeforeRemoved(@NotNull RangeHighlighterEx markerEx, @NotNull Object reason) {
        this.myMarkupModel.fireBeforeRemoved(markerEx);
    }

    static class RHNode
    extends RangeMarkerTree.RMNode<RangeHighlighterEx> {
        private static final byte RENDERED_IN_GUTTER_FLAG = 64;
        final int myLayer;

        RHNode(@NotNull RangeHighlighterTree rangeMarkerTree, @NotNull RangeHighlighterEx key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            super(rangeMarkerTree, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
            this.myLayer = layer;
        }

        private void recalculateRenderFlags() {
            RedBlackTree.Node right;
            boolean renderedInGutter = false;
            for (Getter getter : this.intervals) {
                RangeHighlighterEx h = (RangeHighlighterEx)getter.get();
                renderedInGutter |= h.isRenderedInGutter();
            }
            RedBlackTree.Node left = this.getLeft();
            if (left != null) {
                renderedInGutter |= left.isFlagSet((byte)64);
            }
            if ((right = this.getRight()) != null) {
                renderedInGutter |= right.isFlagSet((byte)64);
            }
            this.setFlag((byte)64, renderedInGutter);
        }

        private void recalculateRenderFlagsUp() {
            for (RHNode n = this; n != null; n = (RHNode)n.getParent()) {
                boolean prevInGutter = n.isFlagSet((byte)64);
                n.recalculateRenderFlags();
                if (n.isFlagSet((byte)64) == prevInGutter) break;
            }
        }

        @Override
        void addInterval(@NotNull RangeHighlighterEx h) {
            super.addInterval(h);
            if (!this.isFlagSet((byte)64) && h.isRenderedInGutter()) {
                this.recalculateRenderFlagsUp();
            }
        }

        @Override
        void removeIntervalInternal(int i2) {
            RangeHighlighterEx h = (RangeHighlighterEx)((Getter)this.intervals.get(i2)).get();
            boolean recalculateFlags = h.isRenderedInGutter();
            super.removeIntervalInternal(i2);
            if (recalculateFlags) {
                this.recalculateRenderFlagsUp();
            }
        }
    }
}

