/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeHighlighterImpl
extends RangeHighlighterImpl {
    private int myLine;

    @NotNull
    static PersistentRangeHighlighterImpl create(@NotNull MarkupModelImpl model, int offset, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributesKey textAttributesKey, boolean normalizeStartOffset) {
        int line = model.getDocument().getLineNumber(offset);
        int startOffset = normalizeStartOffset ? model.getDocument().getLineStartOffset(line) : offset;
        return new PersistentRangeHighlighterImpl(model, startOffset, line, layer, target2, textAttributesKey);
    }

    private PersistentRangeHighlighterImpl(@NotNull MarkupModelImpl model, int startOffset, int line, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributesKey textAttributesKey) {
        super(model, startOffset, model.getDocument().getLineEndOffset(line), layer, target2, textAttributesKey, false, false);
        this.myLine = line;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        this.myLine = this.persistentHighlighterUpdate(e, this.myLine, this.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE);
    }

    @Override
    public String toString() {
        return "PersistentRangeHighlighter" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " - " + this.myLine + (this.isGreedyToRight() ? "]" : ")");
    }
}

