/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import gnu.trove.TIntFunction;
import org.jetbrains.annotations.NotNull;

public class LineNumberConverterAdapter
implements LineNumberConverter {
    private final TIntFunction myFunction;

    public LineNumberConverterAdapter(@NotNull TIntFunction function) {
        this.myFunction = function;
    }

    public Integer convert(@NotNull Editor editor, int lineNumber) {
        int result2 = this.myFunction.execute(lineNumber - 1);
        return result2 < 0 ? null : Integer.valueOf(result2 + 1);
    }

    public Integer getMaxLineNumber(@NotNull Editor editor) {
        for (int i2 = editor.getDocument().getLineCount(); i2 > 0; --i2) {
            int number = this.myFunction.execute(i2 - 1);
            if (number < 0) continue;
            return number + 1;
        }
        return 0;
    }
}

