/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LazyRangeMarkerFactoryImpl
extends LazyRangeMarkerFactory {
    private final Project myProject;

    public LazyRangeMarkerFactoryImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int offset) {
        return (RangeMarker)ReadAction.compute(() -> DocumentImpl.createRangeMarkerForVirtualFile(file2, offset, offset, -1, -1, -1, -1, false));
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int line, int column, boolean persistent) {
        return (RangeMarker)ReadAction.compute(() -> {
            Document document;
            Document document2 = document = file2.getFileType().isBinary() ? null : FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                int myTabSize = CodeStyleFacade.getInstance((Project)this.myProject).getTabSize(file2.getFileType());
                int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document, line, column, myTabSize);
                return DocumentImpl.createRangeMarkerForVirtualFile(file2, offset, offset, line, column, line, column, persistent);
            }
            return DocumentImpl.createRangeMarkerForVirtualFile(file2, 0, 0, line, column, line, column, persistent);
        });
    }

    private static int calculateOffset(@NotNull Document document, int line, int column, int tabSize) {
        int offset;
        if (0 <= line && line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }
}

