/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.IntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class IndentsModelImpl
implements IndentsModel {
    private final Object2ObjectMap<IntPair, IndentGuideDescriptor> myIndentsByLines = new Object2ObjectOpenHashMap();
    private List<IndentGuideDescriptor> myIndents = new ArrayList<IndentGuideDescriptor>();
    @NotNull
    private final EditorImpl myEditor;

    public IndentsModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    public List<IndentGuideDescriptor> getIndents() {
        return this.myIndents;
    }

    public IndentGuideDescriptor getCaretIndentGuide() {
        LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
        int column = pos.column;
        int line = pos.line;
        if (column > 0) {
            for (IndentGuideDescriptor indent : this.myIndents) {
                if (column != indent.indentLevel || line < indent.startLine || line >= indent.endLine) continue;
                return indent;
            }
        }
        return null;
    }

    public IndentGuideDescriptor getDescriptor(int startLine, int endLine) {
        return (IndentGuideDescriptor)this.myIndentsByLines.get((Object)new IntPair(startLine, endLine));
    }

    public void assumeIndents(@NotNull List<IndentGuideDescriptor> descriptors) {
        this.myIndents = descriptors;
        this.myIndentsByLines.clear();
        for (IndentGuideDescriptor descriptor2 : this.myIndents) {
            this.myIndentsByLines.put((Object)new IntPair(descriptor2.startLine, descriptor2.endLine), (Object)descriptor2);
        }
    }
}

