/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.ImaginaryCaret;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImaginaryCaretModel
implements CaretModel {
    private final ImaginaryEditor myEditor;
    private final ImaginaryCaret myCaret;

    ImaginaryCaretModel(ImaginaryEditor editor) {
        this.myEditor = editor;
        this.myCaret = new ImaginaryCaret(this);
    }

    ImaginaryEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public Caret getCurrentCaret() {
        return this.myCaret;
    }

    protected RuntimeException notImplemented() {
        return this.myEditor.notImplemented();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        throw this.notImplemented();
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        throw this.notImplemented();
    }

    public TextAttributes getTextAttributes() {
        throw this.notImplemented();
    }

    public boolean supportsMultipleCarets() {
        throw this.notImplemented();
    }

    @NotNull
    public Caret getPrimaryCaret() {
        return this.myCaret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        return Collections.singletonList(this.myCaret);
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        throw this.notImplemented();
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        throw this.notImplemented();
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        throw this.notImplemented();
    }

    public boolean removeCaret(@NotNull Caret caret) {
        throw this.notImplemented();
    }

    public void removeSecondaryCarets() {
        throw this.notImplemented();
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        throw this.notImplemented();
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        throw this.notImplemented();
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        throw this.notImplemented();
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        throw this.notImplemented();
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        throw this.notImplemented();
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable2) {
        throw this.notImplemented();
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        throw this.notImplemented();
    }
}

