/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorFragmentRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ErrorStripeMarkersModel;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.InspectionPopupManager;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionWidgetActionProvider;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel,
CaretListener,
BulkAwareDocumentListener.Simple,
VisibleAreaListener {
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    private static final JBValue SCROLLBAR_WIDTH = new JBValue.UIInteger("Editor.scrollBarWidth", 14);
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"ActionButton.hoverBackground", (Color)JBUI.CurrentTheme.ActionButton.hoverBackground());
    private static final ColorKey PRESSED_BACKGROUND = ColorKey.createColorKey((String)"ActionButton.pressedBackground", (Color)JBUI.CurrentTheme.ActionButton.pressedBackground());
    private static final ColorKey ICON_TEXT_COLOR = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
    private static final int QUICK_ANALYSIS_TIMEOUT = 3000;
    private static final Logger LOG = Logger.getInstance(EditorMarkupModelImpl.class);
    @NotNull
    private final EditorImpl myEditor;
    @Nullable
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final MergingUpdateQueue myStatusUpdates;
    private final ErrorStripeMarkersModel myErrorStripeMarkersModel;
    private boolean dimensionsAreValid;
    private int myEditorScrollbarTop = -1;
    private int myEditorTargetHeight = -1;
    private int myEditorSourceHeight = -1;
    @Nullable
    private ProperTextRange myDirtyYPositions;
    private static final ProperTextRange WHOLE_DOCUMENT = new ProperTextRange(0, 0);
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider = new BasicTooltipRendererProvider();
    private int myMinMarkHeight;
    @NotNull
    private final EditorFragmentRenderer myEditorFragmentRenderer;
    private final MouseMovementTracker myMouseMovementTracker = new MouseMovementTracker();
    private int myRowAdjuster;
    private int myWheelAccumulator;
    private int myLastVisualLine;
    private WeakReference<LightweightHint> myCurrentHint;
    private int myCurrentHintAnchorY;
    private boolean myKeepHint;
    private final ActionToolbar statusToolbar;
    private boolean showToolbar;
    private boolean trafficLightVisible;
    private final ComponentListener toolbarComponentListener;
    private Rectangle cachedToolbarBounds = new Rectangle();
    private final JLabel smallIconLabel;
    private AnalyzerStatus analyzerStatus;
    private boolean hasAnalyzed;
    private boolean isAnalyzing;
    private boolean showNavigation;
    private boolean reportErrorStripeInconsistency = true;
    private InspectionPopupManager myPopupManager;
    private final Disposable resourcesDisposable = Disposer.newDisposable();
    private final Alarm statusTimer = new Alarm(this.resourcesDisposable);
    private static final Key<List<StatusItem>> EXPANDED_STATUS = new Key("EXPANDED_STATUS");
    private static final Key<Boolean> TRANSLUCENT_STATE = new Key("TRANSLUCENT_STATE");

    private int getMinMarkHeight() {
        return JBUIScale.scale((int)this.myMinMarkHeight);
    }

    private static int getThinGap() {
        return JBUIScale.scale((int)2);
    }

    private static int getMaxStripeSize() {
        return JBUIScale.scale((int)4);
    }

    private static int getMaxMacThumbWidth() {
        return JBUIScale.scale((int)10);
    }

    private static int getStatusIconSize() {
        return JBUIScale.scale((int)18);
    }

    EditorMarkupModelImpl(@NotNull EditorImpl editor) {
        super(editor.getDocument());
        this.myEditor = editor;
        this.myEditorFragmentRenderer = new EditorFragmentRenderer(editor);
        this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.myPopupManager = new InspectionPopupManager(() -> this.analyzerStatus, editor, (AnAction)new CompactViewAction());
        this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget();
        this.trafficLightVisible = true;
        final AnAction nextErrorAction = this.createAction("GotoNextError", AllIcons.Actions.FindAndShowNextMatchesSmall);
        final AnAction prevErrorAction = this.createAction("GotoPreviousError", AllIcons.Actions.FindAndShowPrevMatchesSmall);
        DefaultActionGroup navigateGroup = new DefaultActionGroup(new AnAction[]{prevErrorAction, nextErrorAction}){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(EditorMarkupModelImpl.this.showNavigation);
            }
        };
        StatusAction statusAction = new StatusAction();
        DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{statusAction, navigateGroup});
        this.fillEPActions(actions);
        final EditorToolbarButtonLook editorButtonLook = new EditorToolbarButtonLook();
        this.statusToolbar = new ActionToolbarImpl("EditorInspectionsToolbar", (ActionGroup)actions, true){

            @Override
            protected void paintComponent(Graphics g) {
                editorButtonLook.paintBackground(g, (JComponent)this, EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
            }

            @Override
            @NotNull
            protected Color getSeparatorColor() {
                Color separatorColor = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getColor(EditorColors.SEPARATOR_BELOW_COLOR);
                return separatorColor != null ? separatorColor : super.getSeparatorColor();
            }

            @Override
            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, @NotNull Dimension minimumSize) {
                ActionButton actionButton = new ActionButton(action2, presentation2, place, minimumSize){

                    @Override
                    public void updateIcon() {
                        super.updateIcon();
                        this.revalidate();
                        this.repaint();
                    }

                    @Override
                    public Insets getInsets() {
                        return this.myAction == nextErrorAction ? JBUI.insets((int)2, (int)1) : (this.myAction == prevErrorAction ? JBUI.insets((int)2, (int)1, (int)2, (int)2) : JBUI.insets((int)2));
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Icon icon2 = this.getIcon();
                        Dimension size = new Dimension(icon2.getIconWidth(), icon2.getIconHeight());
                        int minSize = EditorMarkupModelImpl.getStatusIconSize();
                        size.width = Math.max(size.width, minSize);
                        size.height = Math.max(size.height, minSize);
                        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
                        return size;
                    }
                };
                actionButton.setLook(editorButtonLook);
                return actionButton;
            }

            @Override
            public void doLayout() {
                LayoutManager layoutManager = this.getLayout();
                if (layoutManager != null) {
                    layoutManager.layoutContainer(this);
                } else {
                    super.doLayout();
                }
            }

            @Override
            protected Dimension updatePreferredSize(Dimension preferredSize) {
                return preferredSize;
            }

            @Override
            protected Dimension updateMinimumSize(Dimension minimumSize) {
                return minimumSize;
            }
        };
        this.statusToolbar.setMiniMode(true);
        this.toolbarComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Component toolbar = event.getComponent();
                if (toolbar.getWidth() > 0 && toolbar.getHeight() > 0) {
                    EditorMarkupModelImpl.this.updateTrafficLightVisibility();
                }
            }
        };
        JComponent toolbar = this.statusToolbar.getComponent();
        toolbar.setLayout(new StatusComponentLayout());
        toolbar.addComponentListener(this.toolbarComponentListener);
        toolbar.setBorder(JBUI.Borders.empty((int)2));
        this.smallIconLabel = new JLabel();
        this.smallIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.hidePopup();
                if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                    EditorMarkupModelImpl.this.analyzerStatus.getController().toggleProblemsView();
                }
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.scheduleShow(event);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.scheduleHide();
            }
        });
        this.smallIconLabel.setOpaque(false);
        this.smallIconLabel.setBackground((Color)new JBColor(() -> this.myEditor.getColorsScheme().getDefaultBackground()));
        this.smallIconLabel.setVisible(false);
        NonOpaquePanel statusPanel = new NonOpaquePanel();
        statusPanel.setVisible(!this.myEditor.isOneLineMode());
        statusPanel.setLayout(new BoxLayout((Container)statusPanel, 0));
        statusPanel.add(this.statusToolbar.getComponent());
        statusPanel.add(this.smallIconLabel);
        ((JBScrollPane)this.myEditor.getScrollPane()).setStatusComponent((JComponent)statusPanel);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this.resourcesDisposable);
        connection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 instanceof HintManagerImpl.ActionToIgnore) {
                    return;
                }
                EditorMarkupModelImpl.this.myPopupManager.hidePopup();
            }
        });
        connection.subscribe(LafManagerListener.TOPIC, source -> this.myPopupManager.updateUI());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                EditorMarkupModelImpl.this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget() && (EditorMarkupModelImpl.this.analyzerStatus == null || EditorMarkupModelImpl.this.analyzerStatus.getController().enableToolbar());
                EditorMarkupModelImpl.this.updateTrafficLightVisibility();
            }
        });
        this.myStatusUpdates = new MergingUpdateQueue(this.getClass().getName(), 50, true, MergingUpdateQueue.ANY_COMPONENT, this.resourcesDisposable);
        this.myErrorStripeMarkersModel = new ErrorStripeMarkersModel(this.myEditor);
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        this.updateTrafficLightVisibility();
    }

    public void afterDocumentChange(@NotNull Document document) {
        this.myPopupManager.hidePopup();
        this.updateTrafficLightVisibility();
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        this.updateTrafficLightVisibility();
    }

    private void updateTrafficLightVisibility() {
        this.myStatusUpdates.queue(Update.create((Object)"visibility", this::doUpdateTrafficLightVisibility));
    }

    private void doUpdateTrafficLightVisibility() {
        if (this.trafficLightVisible) {
            if (this.showToolbar && this.myEditor.myView != null) {
                VisualPosition pos = this.myEditor.getCaretModel().getPrimaryCaret().getVisualPosition();
                Point point = this.myEditor.visualPositionToXY(pos);
                point = SwingUtilities.convertPoint(this.myEditor.getContentComponent(), point, this.myEditor.getScrollPane());
                JComponent stComponent = this.statusToolbar.getComponent();
                if (stComponent.isVisible()) {
                    Rectangle bounds2 = SwingUtilities.convertRectangle(stComponent, stComponent.getBounds(), this.myEditor.getScrollPane());
                    if (!bounds2.isEmpty() && bounds2.contains(point)) {
                        this.cachedToolbarBounds = bounds2;
                        stComponent.setVisible(false);
                        this.smallIconLabel.setVisible(true);
                    }
                } else if (!this.cachedToolbarBounds.contains(point)) {
                    stComponent.setVisible(true);
                    this.smallIconLabel.setVisible(false);
                }
            } else {
                this.statusToolbar.getComponent().setVisible(false);
                this.smallIconLabel.setVisible(true);
            }
        } else {
            this.statusToolbar.getComponent().setVisible(false);
            this.smallIconLabel.setVisible(false);
        }
    }

    private void fillEPActions(final DefaultActionGroup actions) {
        InspectionWidgetActionProvider.EP_NAME.getExtensionList().forEach(p -> {
            Separator separator = p.getSeparator();
            if (separator != null) {
                actions.add((AnAction)separator, Constraints.FIRST);
            }
            actions.add(p.getAction((Editor)this.myEditor), Constraints.FIRST);
        });
        InspectionWidgetActionProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<InspectionWidgetActionProvider>(){

            public void extensionAdded(@NotNull InspectionWidgetActionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Separator separator = extension.getSeparator();
                if (separator != null) {
                    actions.add((AnAction)separator, Constraints.FIRST);
                }
                actions.add(extension.getAction((Editor)EditorMarkupModelImpl.this.myEditor), Constraints.FIRST);
            }

            public void extensionRemoved(@NotNull InspectionWidgetActionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                actions.remove(extension.getAction((Editor)EditorMarkupModelImpl.this.myEditor));
                Separator separator = extension.getSeparator();
                if (separator != null) {
                    actions.remove((AnAction)separator);
                }
            }
        }, this.resourcesDisposable);
    }

    private AnAction createAction(@NotNull String id2, @NotNull Icon icon2) {
        AnAction delegate = ActionManager.getInstance().getAction(id2);
        MarkupModelDelegateAction result2 = new MarkupModelDelegateAction(delegate, icon2);
        result2.copyShortcutFrom(delegate);
        return result2;
    }

    private int offsetToLine(int offset, @NotNull Document document) {
        if (offset < 0) {
            return 0;
        }
        if (offset > document.getTextLength()) {
            return this.myEditor.getVisibleLineCount();
        }
        return this.myEditor.offsetToVisualLine(offset);
    }

    private void repaintVerticalScrollBar() {
        this.myEditor.getVerticalScrollBar().repaint();
    }

    void recalcEditorDimensions() {
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        int scrollBarHeight = Math.max(0, scrollBar.getSize().height);
        this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight();
        assert (this.myEditorScrollbarTop >= 0);
        int editorScrollbarBottom = scrollBar.getIncScrollButtonHeight();
        this.myEditorTargetHeight = scrollBarHeight - this.myEditorScrollbarTop - editorScrollbarBottom;
        this.myEditorSourceHeight = this.myEditor.getPreferredHeight();
        this.dimensionsAreValid = scrollBarHeight != 0;
    }

    public void setTrafficLightIconVisible(boolean value2) {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            if (value2 != this.trafficLightVisible) {
                this.trafficLightVisible = value2;
                this.updateTrafficLightVisibility();
            }
            this.repaint();
        }
    }

    public void repaintTrafficLightIcon() {
        if (this.myErrorStripeRenderer == null) {
            return;
        }
        this.myStatusUpdates.queue(Update.create((Object)"icon", () -> {
            AnalyzerStatus newStatus;
            if (this.myErrorStripeRenderer != null && !AnalyzerStatus.equals((AnalyzerStatus)(newStatus = this.myErrorStripeRenderer.getStatus((Editor)this.myEditor)), (AnalyzerStatus)this.analyzerStatus)) {
                this.changeStatus(newStatus);
            }
        }));
    }

    private void changeStatus(AnalyzerStatus newStatus) {
        this.statusTimer.cancelAllRequests();
        boolean resetAnalyzingStatus = this.analyzerStatus != null && this.analyzerStatus.isTextStatus() && this.analyzerStatus.getAnalyzingType() == AnalyzingType.COMPLETE;
        this.analyzerStatus = newStatus;
        this.smallIconLabel.setIcon(this.analyzerStatus.getAnalyzingType() == AnalyzingType.COMPLETE ? this.analyzerStatus.getIcon() : AllIcons.General.InspectionsEye);
        if (this.showToolbar != this.analyzerStatus.getController().enableToolbar()) {
            this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget() && this.analyzerStatus.getController().enableToolbar();
            this.updateTrafficLightVisibility();
        }
        boolean analyzing = this.analyzerStatus.getAnalyzingType() != AnalyzingType.COMPLETE;
        this.hasAnalyzed = !resetAnalyzingStatus && (this.hasAnalyzed || this.isAnalyzing && !analyzing);
        this.isAnalyzing = analyzing;
        if (this.analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
            this.showNavigation = this.analyzerStatus.getShowNavigation();
        } else {
            this.statusTimer.addRequest(() -> {
                this.hasAnalyzed = false;
                ActivityTracker.getInstance().inc();
            }, 3000);
        }
        this.myPopupManager.updateVisiblePopup();
        ActivityTracker.getInstance().inc();
    }

    private LightweightHint getCurrentHint() {
        if (this.myCurrentHint == null) {
            return null;
        }
        LightweightHint hint = (LightweightHint)this.myCurrentHint.get();
        if (hint == null || !hint.isVisible()) {
            this.myCurrentHint = null;
            hint = null;
        }
        return hint;
    }

    @NotNull
    private static Rectangle getBoundsOnScreen(@NotNull LightweightHint hint) {
        JComponent component2 = hint.getComponent();
        Point location = hint.getLocationOn(component2);
        SwingUtilities.convertPointToScreen(location, component2);
        return new Rectangle(location, hint.getSize());
    }

    private boolean showToolTipByMouseMove(@NotNull MouseEvent e) {
        boolean isVisible;
        int visualLine;
        MouseEvent me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getY() + 1, e.getClickCount(), e.isPopupTrigger());
        LightweightHint currentHint = this.getCurrentHint();
        if (currentHint != null && (this.myKeepHint || this.myMouseMovementTracker.isMovingTowards(e, EditorMarkupModelImpl.getBoundsOnScreen(currentHint)))) {
            return true;
        }
        this.myLastVisualLine = visualLine = this.getVisualLineByEvent(e);
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        int visualY = this.myEditor.visualLineToY(visualLine);
        boolean bl = isVisible = this.myWheelAccumulator == 0 && area.contains(area.x, visualY);
        if (UIUtil.uiParents((Component)this.myEditor.getComponent(), (boolean)false).filter(EditorWindowHolder.class).isEmpty() || isVisible || !UISettings.getInstance().getShowEditorToolTip()) {
            THashSet highlighters = new THashSet();
            this.getNearestHighlighters(this, me.getY(), (Collection<? super RangeHighlighter>)highlighters);
            this.getNearestHighlighters(((EditorEx)this.getEditor()).getFilteredDocumentMarkupModel(), me.getY(), (Collection<? super RangeHighlighter>)highlighters);
            if (highlighters.isEmpty()) {
                return false;
            }
            int y = e.getY();
            RangeHighlighter nearest = this.getNearestRangeHighlighter(e);
            if (nearest != null) {
                ProperTextRange range2 = this.offsetsToYPositions(nearest.getStartOffset(), nearest.getEndOffset());
                int eachStartY = range2.getStartOffset();
                int eachEndY = range2.getEndOffset();
                y = eachStartY + (eachEndY - eachStartY) / 2;
            }
            if (currentHint != null && y == this.myCurrentHintAnchorY) {
                return true;
            }
            me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), me.getX(), y + 1, e.getClickCount(), e.isPopupTrigger());
            TooltipRenderer bigRenderer = this.myTooltipRendererProvider.calcTooltipRenderer((Collection<? extends RangeHighlighter>)highlighters);
            if (bigRenderer != null) {
                LightweightHint hint = this.showTooltip(bigRenderer, EditorMarkupModelImpl.createHint(me).setForcePopup(true));
                this.myCurrentHint = new WeakReference<LightweightHint>(hint);
                this.myCurrentHintAnchorY = y;
                this.myKeepHint = false;
                this.myMouseMovementTracker.reset();
                return true;
            }
            return false;
        }
        float rowRatio = (float)visualLine / (float)(this.myEditor.getVisibleLineCount() - 1);
        int y = this.myRowAdjuster != 0 ? (int)(rowRatio * (float)this.myEditor.getVerticalScrollBar().getHeight()) : me.getY();
        me = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), y, me.getClickCount(), me.isPopupTrigger());
        ArrayList highlighters = new ArrayList();
        this.collectRangeHighlighters(this, visualLine, highlighters);
        this.collectRangeHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), visualLine, highlighters);
        this.myEditorFragmentRenderer.show(visualLine, highlighters, me.isAltDown(), EditorMarkupModelImpl.createHint(me));
        return true;
    }

    private static HintHint createHint(MouseEvent me) {
        return new HintHint(me).setAwtTooltip(true).setPreferredPosition(Balloon.Position.atLeft).setBorderInsets((Insets)JBUI.insets((int)1)).setShowImmediately(true).setAnimationEnabled(false);
    }

    private int getVisualLineByEvent(@NotNull MouseEvent e) {
        int y = e.getY();
        if (e.getSource() == this.myEditor.getVerticalScrollBar() && y == this.myEditor.getVerticalScrollBar().getHeight() - 1) {
            ++y;
        }
        return EditorMarkupModelImpl.fitLineToEditor(this.myEditor, this.myEditor.offsetToVisualLine(this.yPositionToOffset(y + this.myWheelAccumulator, true)));
    }

    static int fitLineToEditor(EditorImpl editor, int visualLine) {
        int lineCount = editor.getVisibleLineCount();
        int shift = 0;
        if (visualLine >= lineCount - 1) {
            CharSequence sequence = editor.getDocument().getCharsSequence();
            shift = sequence.length() < 1 ? 0 : (sequence.charAt(sequence.length() - 1) == '\n' ? 1 : 0);
        }
        return Math.max(0, Math.min(lineCount - shift, visualLine));
    }

    private int getOffset(int visualLine, boolean startLine) {
        return this.myEditor.visualPositionToOffset(new VisualPosition(visualLine, startLine ? 0 : Integer.MAX_VALUE));
    }

    private void collectRangeHighlighters(@NotNull MarkupModelEx markupModel, int visualLine, @NotNull Collection<? super RangeHighlighterEx> highlighters) {
        int startOffset = this.getOffset(EditorMarkupModelImpl.fitLineToEditor(this.myEditor, visualLine - EditorFragmentRenderer.PREVIEW_LINES), true);
        int endOffset = this.getOffset(EditorMarkupModelImpl.fitLineToEditor(this.myEditor, visualLine + EditorFragmentRenderer.PREVIEW_LINES), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip == null || tooltip instanceof HighlightInfo && ((HighlightInfo)tooltip).type == HighlightInfoType.TODO || highlighter.getStartOffset() >= endOffset || highlighter.getEndOffset() <= startOffset || highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) == null)) {
                highlighters.add((RangeHighlighterEx)highlighter);
            }
            return true;
        }));
    }

    @Nullable
    private RangeHighlighter getNearestRangeHighlighter(@NotNull MouseEvent e) {
        ArrayList highlighters = new ArrayList();
        this.getNearestHighlighters(this, e.getY(), highlighters);
        this.getNearestHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), e.getY(), highlighters);
        RangeHighlighter nearestMarker = null;
        int yPos = 0;
        for (RangeHighlighter highlighter : highlighters) {
            int newYPos = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset()).getStartOffset();
            if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
            nearestMarker = highlighter;
            yPos = newYPos;
        }
        return nearestMarker;
    }

    private void getNearestHighlighters(@NotNull MarkupModelEx markupModel, int scrollBarY, @NotNull Collection<? super RangeHighlighter> nearest) {
        int startOffset = this.yPositionToOffset(scrollBarY - this.getMinMarkHeight(), true);
        int endOffset = this.yPositionToOffset(scrollBarY + this.getMinMarkHeight(), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            ProperTextRange range2;
            if (highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) != null && scrollBarY >= (range2 = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset())).getStartOffset() - this.getMinMarkHeight() * 2 && scrollBarY <= range2.getEndOffset() + this.getMinMarkHeight() * 2) {
                nearest.add((RangeHighlighter)highlighter);
            }
            return true;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClick(@NotNull MouseEvent e) {
        int offset;
        RangeHighlighter marker = this.getNearestRangeHighlighter(e);
        LogicalPosition logicalPositionToScroll = null;
        LightweightHint editorPreviewHint = this.myEditorFragmentRenderer.getEditorPreviewHint();
        if (marker == null) {
            if (editorPreviewHint == null) return;
            logicalPositionToScroll = this.myEditor.visualToLogicalPosition(new VisualPosition(this.myEditorFragmentRenderer.getStartVisualLine(), 0));
            offset = this.myEditor.getDocument().getLineStartOffset(logicalPositionToScroll.line);
        } else {
            offset = marker.getStartOffset();
        }
        DocumentEx doc = this.myEditor.getDocument();
        if (doc.getLineCount() > 0 && editorPreviewHint == null) {
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.myEditor.getCaretModel().moveToOffset(lineEnd);
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getSelectionModel().removeSelection();
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        if (logicalPositionToScroll != null) {
            int lineY = this.myEditor.logicalPositionToXY((LogicalPosition)logicalPositionToScroll).y;
            int relativePopupOffset = this.myEditorFragmentRenderer.getRelativeY();
            scrollingModel.scrollVertically(lineY - relativePopupOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.CENTER);
        }
        scrollingModel.enableAnimation();
        if (marker == null) return;
        this.myErrorStripeMarkersModel.fireErrorMarkerClicked(marker, e);
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.disposeErrorPanel();
            MyErrorPanel panel2 = new MyErrorPanel();
            this.myEditor.getVerticalScrollBar().setPersistentUI((ScrollBarUI)((Object)panel2));
            this.rebuildErrorStripeMarksModel();
        } else {
            this.myErrorStripeMarkersModel.clear();
            this.myEditor.getVerticalScrollBar().setPersistentUI(JBScrollBar.createUI(null));
        }
    }

    @Nullable
    private MyErrorPanel getErrorPanel() {
        ScrollBarUI ui = this.myEditor.getVerticalScrollBar().getUI();
        return ui instanceof MyErrorPanel ? (MyErrorPanel)((Object)ui) : null;
    }

    @NotNull
    ErrorStripeMarkersModel getErrorStripeMarkersModel() {
        return this.myErrorStripeMarkersModel;
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.setPopupHandler(handler2);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider) {
        this.myTooltipRendererProvider = provider;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        return this.myTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public void setErrorStripeRenderer(@Nullable ErrorStripeRenderer renderer) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = renderer;
    }

    @Override
    @Nullable
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        this.disposeErrorPanel();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.statusToolbar.getComponent().removeComponentListener(this.toolbarComponentListener);
        ((JBScrollPane)this.myEditor.getScrollPane()).setStatusComponent(null);
        this.myErrorStripeRenderer = null;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditorFragmentRenderer.clearHint();
        this.myPopupManager.hidePopup();
        this.myPopupManager = null;
        Disposer.dispose((Disposable)this.resourcesDisposable);
        super.dispose();
    }

    private void disposeErrorPanel() {
        MyErrorPanel panel2 = this.getErrorPanel();
        if (panel2 != null) {
            panel2.uninstallListeners();
        }
    }

    public void rebuild() {
        this.rebuildErrorStripeMarksModel();
    }

    private void rebuildErrorStripeMarksModel() {
        ErrorStripeMarkersModel errorStripeMarkersModel = this.myErrorStripeMarkersModel;
        errorStripeMarkersModel.clear();
        int textLength = this.myEditor.getDocument().getTextLength();
        this.processRangeHighlightersOverlappingWith(0, textLength, (Processor<? super RangeHighlighterEx>)((Processor)ex -> {
            errorStripeMarkersModel.afterAdded((RangeHighlighterEx)ex, false);
            return true;
        }));
        this.myEditor.getFilteredDocumentMarkupModel().processRangeHighlightersOverlappingWith(0, textLength, (Processor<? super RangeHighlighterEx>)((Processor)ex -> {
            errorStripeMarkersModel.afterAdded((RangeHighlighterEx)ex, true);
            return true;
        }));
    }

    void repaint() {
        this.repaint(-1, -1);
    }

    void repaint(int startOffset, int endOffset) {
        ProperTextRange range2 = this.offsetsToYPositions(startOffset, endOffset);
        this.markDirtied(range2);
        if (startOffset == -1 || endOffset == -1) {
            this.myDirtyYPositions = WHOLE_DOCUMENT;
        }
        EditorImpl.MyScrollBar bar = this.myEditor.getVerticalScrollBar();
        ((Component)((Object)bar)).repaint(0, range2.getStartOffset(), ((JComponent)((Object)bar)).getWidth(), range2.getLength() + this.getMinMarkHeight());
    }

    private boolean isMirrored() {
        return this.myEditor.isMirrored();
    }

    private boolean transparent() {
        return !this.myEditor.shouldScrollBarBeOpaque();
    }

    private void hideMyEditorPreviewHint() {
        this.myEditorFragmentRenderer.hideHint();
        this.myRowAdjuster = 0;
        this.myWheelAccumulator = 0;
        this.myLastVisualLine = 0;
    }

    private LightweightHint showTooltip(TooltipRenderer tooltipObject, @NotNull HintHint hintHint) {
        this.hideMyEditorPreviewHint();
        return TooltipController.getInstance().showTooltipByMouseMove(this.myEditor, hintHint.getTargetPoint(), tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP, hintHint);
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener2, @NotNull Disposable parent) {
        this.myErrorStripeMarkersModel.addErrorMarkerListener(listener2, parent);
    }

    private void markDirtied(@NotNull ProperTextRange yPositions) {
        if (this.myDirtyYPositions != WHOLE_DOCUMENT) {
            int start2 = Math.max(0, yPositions.getStartOffset() - this.myEditor.getLineHeight());
            int end = this.myEditorScrollbarTop + this.myEditorTargetHeight == 0 ? yPositions.getEndOffset() + this.myEditor.getLineHeight() : Math.min(this.myEditorScrollbarTop + this.myEditorTargetHeight, yPositions.getEndOffset() + this.myEditor.getLineHeight());
            ProperTextRange adj = new ProperTextRange(start2, Math.max(end, start2));
            this.myDirtyYPositions = this.myDirtyYPositions == null ? adj : this.myDirtyYPositions.union((TextRange)adj);
        }
        this.myEditorScrollbarTop = 0;
        this.myEditorSourceHeight = 0;
        this.myEditorTargetHeight = 0;
        this.dimensionsAreValid = false;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        this.myMinMarkHeight = Math.min(minMarkHeight, EditorMarkupModelImpl.getMaxStripeSize());
    }

    @Override
    public boolean isErrorStripeVisible() {
        return this.getErrorPanel() != null;
    }

    @NotNull
    private ProperTextRange offsetsToYPositions(int start2, int end) {
        int endY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        DocumentEx document = this.myEditor.getDocument();
        int startLineNumber = end == -1 ? 0 : this.offsetToLine(start2, document);
        int editorStartY = this.myEditor.visualLineToY(startLineNumber);
        int editorTargetHeight = Math.max(0, this.myEditorTargetHeight);
        int startY = this.myEditorSourceHeight < editorTargetHeight ? this.myEditorScrollbarTop + editorStartY : this.myEditorScrollbarTop + (int)((float)editorStartY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        int endLineNumber = this.offsetToLine(end, document);
        if (end == -1 || start2 == -1) {
            endY = Math.min(this.myEditorSourceHeight, editorTargetHeight);
        } else if (startLineNumber == endLineNumber) {
            endY = startY;
        } else if (this.myEditorSourceHeight < editorTargetHeight) {
            endY = this.myEditorScrollbarTop + this.myEditor.visualLineToY(endLineNumber);
        } else {
            int editorEndY = this.myEditor.visualLineToY(endLineNumber);
            endY = this.myEditorScrollbarTop + (int)((float)editorEndY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        }
        if (endY < startY) {
            endY = startY;
        }
        return new ProperTextRange(startY, endY);
    }

    private int yPositionToOffset(int y, boolean beginLine) {
        int editorY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        int safeY = Math.max(0, y - this.myEditorScrollbarTop);
        if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
            editorY = safeY;
        } else {
            float fraction = Math.max(0.0f, Math.min(1.0f, (float)safeY / (float)this.myEditorTargetHeight));
            editorY = (int)(fraction * (float)this.myEditorSourceHeight);
        }
        VisualPosition visual = this.myEditor.xyToVisualPosition(new Point(0, editorY));
        int line = this.myEditor.visualToLogicalPosition((VisualPosition)visual).line;
        DocumentEx document = this.myEditor.getDocument();
        if (line < 0) {
            return 0;
        }
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (beginLine) {
            int offset = document.getLineStartOffset(line);
            FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
            return startCollapsed != null ? Math.min(offset, startCollapsed.getStartOffset()) : offset;
        }
        int offset = document.getLineEndOffset(line);
        FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
        return startCollapsed != null ? Math.max(offset, startCollapsed.getEndOffset()) : offset;
    }

    private class MarkupModelDelegateAction
    extends DumbAwareAction
    implements ActionWithDelegate<AnAction> {
        private final AnAction myDelegate;

        private MarkupModelDelegateAction(@NotNull AnAction delegate, Icon icon2) {
            super(delegate.getTemplatePresentation().getText(), null, icon2);
            this.myDelegate = delegate;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)EditorMarkupModelImpl.this.myEditor.getProject());
            AnActionEvent delegateEvent = AnActionEvent.createFromAnAction((AnAction)this.myDelegate, (InputEvent)e.getInputEvent(), (String)"EditorInspectionsToolbar", (DataContext)EditorMarkupModelImpl.this.myEditor.getDataContext());
            if (focusManager.getFocusOwner() != EditorMarkupModelImpl.this.myEditor.getContentComponent()) {
                focusManager.requestFocus((Component)EditorMarkupModelImpl.this.myEditor.getContentComponent(), true).doWhenDone(() -> this.myDelegate.actionPerformed(delegateEvent));
            } else {
                this.myDelegate.actionPerformed(delegateEvent);
            }
        }

        @NotNull
        public AnAction getDelegate() {
            return this.myDelegate;
        }
    }

    public class CompactViewAction
    extends ToggleAction {
        CompactViewAction() {
            super(EditorBundle.message((String)"iw.compact.view", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return !EditorMarkupModelImpl.this.showToolbar;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            EditorMarkupModelImpl.this.showToolbar = !state;
            EditorSettingsExternalizable.getInstance().setShowInspectionWidget(EditorMarkupModelImpl.this.showToolbar);
            EditorMarkupModelImpl.this.updateTrafficLightVisibility();
            ActionsCollector.getInstance().record(e.getProject(), (AnAction)this, e, null);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(EditorMarkupModelImpl.this.analyzerStatus == null || EditorMarkupModelImpl.this.analyzerStatus.getController().enableToolbar());
        }

        public boolean isDumbAware() {
            return true;
        }
    }

    private class EditorToolbarButtonLook
    extends ActionButtonLook {
        private EditorToolbarButtonLook() {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state) {
        }

        @Override
        public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
            Color color;
            if (state == 0) {
                return;
            }
            Rectangle rect = new Rectangle(component2.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
            EditorColorsScheme scheme = EditorMarkupModelImpl.this.myEditor.getColorsScheme();
            Color color2 = color = state == -1 ? scheme.getColor(PRESSED_BACKGROUND) : scheme.getColor(HOVER_BACKGROUND);
            if (color != null) {
                ActionButtonLook.SYSTEM_LOOK.paintLookBackground(g, rect, color);
            }
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
            ActionButtonLook.SYSTEM_LOOK.paintBackground(g, component2, color);
        }

        @Override
        public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2, int x, int y) {
            if (icon2 != null) {
                boolean isDark = ColorUtil.isDark((Color)EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultBackground());
                super.paintIcon(g, actionButton, IconLoader.getDarkIcon((Icon)icon2, (boolean)isDark), x, y);
            }
        }
    }

    private static class StatusComponentLayout
    implements LayoutManager {
        private final List<Pair<Component, String>> actionButtons = new ArrayList<Pair<Component, String>>();

        private StatusComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String s, Component component2) {
            this.actionButtons.add((Pair<Component, String>)Pair.pair((Object)component2, (Object)s));
        }

        @Override
        public void removeLayoutComponent(Component component2) {
            for (int i2 = 0; i2 < this.actionButtons.size(); ++i2) {
                if (!Comparing.equal((Object)component2, (Object)this.actionButtons.get((int)i2).first)) continue;
                this.actionButtons.remove(i2);
                break;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container2) {
            Dimension prefSize;
            JBDimension size = JBUI.emptySize();
            for (Pair<Component, String> c : this.actionButtons) {
                if (!((Component)c.first).isVisible()) continue;
                prefSize = ((Component)c.first).getPreferredSize();
                size.height = Math.max(size.height, prefSize.height);
            }
            for (Pair<Component, String> c : this.actionButtons) {
                if (!((Component)c.first).isVisible()) continue;
                prefSize = ((Component)c.first).getPreferredSize();
                Insets i2 = ((JComponent)c.first).getInsets();
                JBInsets.removeFrom((Dimension)prefSize, (Insets)i2);
                if ("Constraint.Separator".equals(c.second)) {
                    size.width += prefSize.width + i2.left + i2.right;
                    continue;
                }
                int maxBareHeight = size.height - i2.top - i2.bottom;
                size.width += Math.max(prefSize.width, maxBareHeight) + i2.left + i2.right;
            }
            if (size.width > 0 && size.height > 0) {
                JBInsets.addTo((Dimension)size, (Insets)container2.getInsets());
            }
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container container2) {
            return this.preferredLayoutSize(container2);
        }

        @Override
        public void layoutContainer(Container container2) {
            Dimension prefSize = this.preferredLayoutSize(container2);
            if (prefSize.width > 0 && prefSize.height > 0) {
                Insets i2 = container2.getInsets();
                JBInsets.removeFrom((Dimension)prefSize, (Insets)i2);
                int offset = i2.left;
                for (Pair<Component, String> c : this.actionButtons) {
                    if (!((Component)c.first).isVisible()) continue;
                    Dimension cPrefSize = ((Component)c.first).getPreferredSize();
                    if (c.first instanceof StatusButton) {
                        ((Component)c.first).setBounds(offset, i2.top, cPrefSize.width, prefSize.height);
                        offset += cPrefSize.width;
                        continue;
                    }
                    Insets jcInsets = ((JComponent)c.first).getInsets();
                    JBInsets.removeFrom((Dimension)cPrefSize, (Insets)jcInsets);
                    if ("Constraint.Separator".equals(c.second)) {
                        ((Component)c.first).setBounds(offset, i2.top, cPrefSize.width, prefSize.height);
                        offset += cPrefSize.width;
                        continue;
                    }
                    int maxBareHeight = prefSize.height - jcInsets.top - jcInsets.bottom;
                    int width = Math.max(cPrefSize.width, maxBareHeight) + jcInsets.left + jcInsets.right;
                    ((Component)c.first).setBounds(offset, i2.top, width, prefSize.height);
                    offset += width;
                }
            }
        }
    }

    private static class StatusButton
    extends JPanel {
        private static final int LEFT_RIGHT_INDENT = 5;
        private static final int INTER_GROUP_OFFSET = 6;
        private boolean mousePressed;
        private boolean mouseHover;
        private final ActionButtonLook buttonLook;
        private final MouseListener mouseListener;
        private final PropertyChangeListener presentationPropertyListener;
        private final Presentation presentation;
        private final EditorColorsScheme colorsScheme;
        private boolean translucent;

        private StatusButton(final @NotNull AnAction action2, final @NotNull Presentation presentation2, @NotNull ActionButtonLook buttonLook, final @NotNull String place, @NotNull EditorColorsScheme colorsScheme, final @NotNull InspectionPopupManager popupManager, final @NotNull BooleanSupplier hasNavButtons) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.buttonLook = buttonLook;
            this.presentation = presentation2;
            this.colorsScheme = colorsScheme;
            this.presentationPropertyListener = l -> {
                String propName = l.getPropertyName();
                if (propName.equals(EXPANDED_STATUS.toString()) && l.getNewValue() != null) {
                    List newStatus = (List)l.getNewValue();
                    this.updateContents(newStatus);
                    this.translucent = false;
                    this.revalidate();
                    this.repaint();
                } else if (propName.equals(TRANSLUCENT_STATE.toString())) {
                    this.translucent = l.getNewValue() == Boolean.TRUE;
                    this.repaint();
                }
            };
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    DataContext context = this.getDataContext();
                    AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)me, (String)place, (Presentation)presentation2, (DataContext)context, (boolean)false, (boolean)true);
                    if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
                        return;
                    }
                    if (presentation2.isEnabled()) {
                        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
                        manager.fireBeforeActionPerformed(action2, context, event);
                        action2.actionPerformed(event);
                        manager.queueActionPerformedEvent(action2, context, event);
                        ActionsCollector.getInstance().record(event.getProject(), action2, event, null);
                        ActionToolbar toolbar = this.getActionToolbar();
                        if (toolbar != null) {
                            toolbar.updateActionsImmediately();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    mousePressed = true;
                    this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    mousePressed = false;
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                    mouseHover = true;
                    popupManager.scheduleShow(me);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    mouseHover = false;
                    popupManager.scheduleHide();
                    this.repaint();
                }
            };
            List newStatus = (List)presentation2.getClientProperty(EXPANDED_STATUS);
            if (newStatus != null) {
                this.updateContents(newStatus);
            }
            this.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return hasNavButtons.getAsBoolean() ? JBUI.insets((int)2, (int)2, (int)2, (int)0) : JBUI.insets((int)2);
                }
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.presentation.addPropertyChangeListener(this.presentationPropertyListener);
            this.addMouseListener(this.mouseListener);
        }

        @Override
        public void removeNotify() {
            this.presentation.removePropertyChangeListener(this.presentationPropertyListener);
            this.removeMouseListener(this.mouseListener);
        }

        private DataContext getDataContext() {
            ActionToolbar actionToolbar = this.getActionToolbar();
            return actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext((Component)this);
        }

        private ActionToolbar getActionToolbar() {
            return (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)this);
        }

        private void updateContents(@NotNull List<StatusItem> status) {
            this.removeAll();
            this.setEnabled(!status.isEmpty());
            this.setVisible(!status.isEmpty());
            GridBag gc = new GridBag().nextLine();
            if (status.size() == 1 && StringUtil.isEmpty((String)status.get(0).getText())) {
                this.add((Component)this.createStyledLabel(null, status.get(0).getIcon(), 0), gc.next().weightx(1.0).fillCellHorizontally());
            } else if (status.size() > 0) {
                int leftRightOffset = JBUIScale.scale((int)5);
                this.add(Box.createHorizontalStrut(leftRightOffset), gc.next());
                int counter = 0;
                for (StatusItem item : status) {
                    this.add((Component)this.createStyledLabel(item.getText(), item.getIcon(), 2), gc.next().insetLeft(counter++ > 0 ? 6 : 0));
                }
                this.add(Box.createHorizontalStrut(leftRightOffset), gc.next());
            }
        }

        private JLabel createStyledLabel(@Nullable String text, @Nullable Icon icon2, int alignment) {
            JLabel label2 = new JLabel(text, icon2, alignment){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void paintComponent(Graphics graphics) {
                    Graphics2D g2 = (Graphics2D)graphics.create();
                    try {
                        float alpha = translucent ? 0.5f : 1.0f;
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                        super.paintComponent(g2);
                    }
                    finally {
                        g2.dispose();
                    }
                }

                @Override
                public void setUI(LabelUI ui) {
                    super.setUI(ui);
                    if (!SystemInfo.isWindows) {
                        Font font = this.getFont();
                        font = new FontUIResource(font.deriveFont(font.getStyle(), font.getSize() - JBUIScale.scale((int)2)));
                        this.setFont(font);
                    }
                }
            };
            label2.setForeground((Color)new JBColor(() -> (Color)ObjectUtils.notNull((Object)this.colorsScheme.getColor(ICON_TEXT_COLOR), (Object)ICON_TEXT_COLOR.getDefaultColor())));
            label2.setIconTextGap(JBUIScale.scale((int)1));
            return label2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int state = this.mousePressed ? -1 : (this.mouseHover ? 1 : 0);
            this.buttonLook.paintBackground(graphics, (JComponent)this, state);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getComponentCount() == 0) {
                return JBUI.emptySize();
            }
            Dimension size = super.getPreferredSize();
            Insets i2 = this.getInsets();
            size.height = Math.max(EditorMarkupModelImpl.getStatusIconSize() + i2.top + i2.bottom, size.height);
            size.width = Math.max(EditorMarkupModelImpl.getStatusIconSize() + i2.left + i2.right, size.width);
            return size;
        }
    }

    private class StatusAction
    extends DumbAwareAction
    implements CustomComponentAction {
        private StatusAction() {
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            return new StatusButton((AnAction)this, presentation2, new EditorToolbarButtonLook(), place, EditorMarkupModelImpl.this.myEditor.getColorsScheme(), EditorMarkupModelImpl.this.myPopupManager, () -> EditorMarkupModelImpl.this.showNavigation);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EditorMarkupModelImpl.this.myPopupManager.hidePopup();
            if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                EditorMarkupModelImpl.this.analyzerStatus.getController().toggleProblemsView();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                List<StatusItem> newStatus = EditorMarkupModelImpl.this.analyzerStatus.getExpandedStatus();
                Icon newIcon = EditorMarkupModelImpl.this.analyzerStatus.getIcon();
                if (!EditorMarkupModelImpl.this.hasAnalyzed || EditorMarkupModelImpl.this.analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
                    if (newStatus.isEmpty()) {
                        newStatus = Collections.singletonList(new StatusItem("", newIcon));
                        presentation2.putClientProperty(EXPANDED_STATUS, newStatus);
                    }
                    if (!Objects.equals(presentation2.getClientProperty(EXPANDED_STATUS), newStatus)) {
                        presentation2.putClientProperty(EXPANDED_STATUS, newStatus);
                    }
                    presentation2.putClientProperty(TRANSLUCENT_STATE, (Object)(EditorMarkupModelImpl.this.analyzerStatus.getAnalyzingType() != AnalyzingType.COMPLETE ? 1 : 0));
                } else {
                    presentation2.putClientProperty(TRANSLUCENT_STATE, (Object)true);
                }
            } else {
                presentation2.putClientProperty(EXPANDED_STATUS, Collections.emptyList());
            }
        }
    }

    private static class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
            LineTooltipRenderer bigRenderer = null;
            Set tooltips = null;
            for (RangeHighlighter rangeHighlighter : highlighters) {
                String text;
                Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
                if (tooltipObject == null || (text = tooltipObject instanceof HighlightInfo ? ((HighlightInfo)tooltipObject).getToolTip() : tooltipObject.toString()) == null) continue;
                if (tooltips == null) {
                    tooltips = new THashSet();
                }
                if (!tooltips.add(text)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text, new Object[]{highlighters});
                    continue;
                }
                bigRenderer.addBelow(text);
            }
            return bigRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
            return new LineTooltipRenderer(text, new Object[]{text});
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
            return new LineTooltipRenderer(text, width, new Object[]{text});
        }

        @Override
        @NotNull
        public TrafficTooltipRenderer createTrafficTooltipRenderer(final @NotNull Runnable onHide, @NotNull Editor editor) {
            return new TrafficTooltipRenderer(){

                @Override
                public void repaintTooltipWindow() {
                }

                @Override
                @NotNull
                public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
                    JLabel label2 = new JLabel("WTF");
                    return new LightweightHint(label2){

                        @Override
                        public void hide() {
                            super.hide();
                            onHide.run();
                        }
                    };
                }
            };
        }
    }

    @DirtyUI
    private class MyErrorPanel
    extends ButtonlessScrollBarUI
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    UISettingsListener {
        private PopupHandler myHandler;
        @Nullable
        private BufferedImage myCachedTrack;
        private int myCachedHeight = -1;
        @Nullable
        private TrafficTooltipRenderer myTrafficTooltipRenderer;

        private MyErrorPanel() {
        }

        public void dropCache() {
            this.myCachedTrack = null;
            this.myCachedHeight = -1;
        }

        public boolean alwaysShowTrack() {
            if (this.scrollbar.getOrientation() == 1) {
                return !EditorMarkupModelImpl.this.transparent();
            }
            return super.alwaysShowTrack();
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.dropCache();
        }

        public void uninstallUI(@NotNull JComponent c) {
            super.uninstallUI(c);
            this.dropCache();
        }

        protected void installListeners() {
            super.installListeners();
            this.scrollbar.addMouseMotionListener(this);
            this.scrollbar.addMouseListener(this);
            this.scrollbar.addMouseWheelListener(this);
        }

        protected void uninstallListeners() {
            this.scrollbar.removeMouseMotionListener(this);
            this.scrollbar.removeMouseListener(this);
            super.uninstallListeners();
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (!uiSettings.getShowEditorToolTip()) {
                EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            }
            EditorMarkupModelImpl.this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
            EditorMarkupModelImpl.this.repaintTrafficLightIcon();
            EditorMarkupModelImpl.this.repaintVerticalScrollBar();
            EditorMarkupModelImpl.this.myPopupManager.updateVisiblePopup();
        }

        protected void paintThumb(@NotNull Graphics g, @NotNull JComponent c, Rectangle thumbBounds) {
            if (this.isMacOverlayScrollbar()) {
                if (!EditorMarkupModelImpl.this.isMirrored()) {
                    super.paintThumb(g, c, thumbBounds);
                } else {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform old = g2d.getTransform();
                    AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                    tx.translate(-c.getWidth(), 0.0);
                    g2d.transform(tx);
                    super.paintThumb(g, c, thumbBounds);
                    g2d.setTransform(old);
                }
            } else {
                super.paintThumb(g, c, thumbBounds);
            }
        }

        protected boolean isThumbTranslucent() {
            return true;
        }

        protected int getThumbOffset(int value2) {
            if (SystemInfo.isMac || Registry.is((String)"editor.full.width.scrollbar")) {
                return EditorMarkupModelImpl.this.getMinMarkHeight() + JBUIScale.scale((int)2);
            }
            return super.getThumbOffset(value2);
        }

        protected boolean isDark() {
            return EditorMarkupModelImpl.this.myEditor.isDarkEnough();
        }

        protected boolean alwaysPaintThumb() {
            return true;
        }

        protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
            Rectangle bounds2 = super.getMacScrollBarBounds(baseBounds, thumb);
            bounds2.width = Math.min(bounds2.width, EditorMarkupModelImpl.getMaxMacThumbWidth());
            int b2 = bounds2.width / 2;
            bounds2.x = EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight() + SCROLLBAR_WIDTH.get() / 2 - b2;
            return bounds2;
        }

        protected int getThickness() {
            return SCROLLBAR_WIDTH.get() + EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight();
        }

        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle trackBounds) {
            if (EditorMarkupModelImpl.this.myEditor.isDisposed()) {
                return;
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                this.doPaintTrack(g, c, trackBounds);
            } else {
                super.paintTrack(g, c, trackBounds);
            }
        }

        protected void doPaintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle bounds2) {
            Rectangle clip = g.getClipBounds().intersection(bounds2);
            if (clip.height == 0) {
                return;
            }
            Rectangle componentBounds = c.getBounds();
            ProperTextRange docRange = ProperTextRange.create((int)0, (int)componentBounds.height);
            if (this.myCachedTrack == null || this.myCachedHeight != componentBounds.height) {
                this.myCachedTrack = UIUtil.createImage((Component)c, (int)componentBounds.width, (int)componentBounds.height, (int)2);
                this.myCachedHeight = componentBounds.height;
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                EditorMarkupModelImpl.this.dimensionsAreValid = false;
                this.paintTrackBasement(this.myCachedTrack.getGraphics(), new Rectangle(0, 0, componentBounds.width, componentBounds.height));
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions == WHOLE_DOCUMENT) {
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions != null) {
                Graphics2D imageGraphics = this.myCachedTrack.createGraphics();
                EditorMarkupModelImpl.this.myDirtyYPositions = EditorMarkupModelImpl.this.myDirtyYPositions.intersection((TextRange)docRange);
                if (EditorMarkupModelImpl.this.myDirtyYPositions == null) {
                    EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                }
                this.repaint(imageGraphics, componentBounds.width, EditorMarkupModelImpl.this.myDirtyYPositions);
                EditorMarkupModelImpl.this.myDirtyYPositions = null;
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCachedTrack, null, (int)0, (int)0);
        }

        private void paintTrackBasement(@NotNull Graphics g, @NotNull Rectangle bounds2) {
            if (EditorMarkupModelImpl.this.transparent()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setComposite(AlphaComposite.getInstance(1));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g2.setComposite(AlphaComposite.getInstance(3));
            } else {
                g.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
        }

        @NotNull
        protected Color adjustColor(Color c) {
            return this.isMacOverlayScrollbar() ? super.adjustColor(c) : EditorImpl.adjustThumbColor(super.adjustColor(c), this.isDark());
        }

        private void repaint(@NotNull Graphics g, int gutterWidth, @NotNull ProperTextRange yrange) {
            Rectangle clip = new Rectangle(0, yrange.getStartOffset(), gutterWidth, yrange.getLength() + EditorMarkupModelImpl.this.getMinMarkHeight());
            this.paintTrackBasement(g, clip);
            int startOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y - EditorMarkupModelImpl.this.getMinMarkHeight(), true);
            int endOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y + clip.height, false);
            Shape oldClip = g.getClip();
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            this.drawErrorStripeMarkers(g, startOffset, endOffset);
            g.setClip(oldClip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawErrorStripeMarkers(@NotNull Graphics g, int startOffset, int endOffset) {
            PriorityQueue<PositionedStripe> thinEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> ((PositionedStripe)o).yEnd));
            PriorityQueue<PositionedStripe> wideEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> ((PositionedStripe)o).yEnd));
            ArrayList<PositionedStripe> thinStripes = new ArrayList<PositionedStripe>();
            ArrayList<PositionedStripe> wideStripes = new ArrayList<PositionedStripe>();
            int[] thinYStart = new int[1];
            int[] wideYStart = new int[1];
            MarkupIterator<RangeHighlighterEx> iterator2 = EditorMarkupModelImpl.this.myErrorStripeMarkersModel.highlighterIterator(startOffset, endOffset);
            try {
                ContainerUtil.process(iterator2, highlighter -> {
                    Color color;
                    int i2;
                    boolean isThin = highlighter.isThinErrorStripeMark();
                    int[] yStart = isThin ? thinYStart : wideYStart;
                    List stripes = isThin ? thinStripes : wideStripes;
                    Queue ends = isThin ? thinEnds : wideEnds;
                    ProperTextRange range2 = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset());
                    int ys = range2.getStartOffset();
                    int ye = range2.getEndOffset();
                    if (ye - ys < EditorMarkupModelImpl.this.getMinMarkHeight()) {
                        ye = ys + EditorMarkupModelImpl.this.getMinMarkHeight();
                    }
                    yStart[0] = this.drawStripesEndingBefore(ys, ends, stripes, g, yStart[0]);
                    int layer = highlighter.getLayer();
                    PositionedStripe stripe = null;
                    for (i2 = 0; i2 < stripes.size(); ++i2) {
                        PositionedStripe s = (PositionedStripe)stripes.get(i2);
                        if (s.layer == layer) {
                            stripe = s;
                            break;
                        }
                        if (s.layer < layer) break;
                    }
                    if ((color = highlighter.getErrorStripeMarkColor(EditorMarkupModelImpl.this.myEditor.getColorsScheme())) == null) {
                        if (EditorMarkupModelImpl.this.reportErrorStripeInconsistency) {
                            EditorMarkupModelImpl.this.reportErrorStripeInconsistency = false;
                            LOG.error("Error stripe marker has no color. highlighter: " + highlighter);
                        }
                        return true;
                    }
                    if (stripe == null) {
                        if (i2 == 0 && yStart[0] != ys) {
                            if (!stripes.isEmpty()) {
                                PositionedStripe top = (PositionedStripe)stripes.get(0);
                                this.drawSpot(g, top.thin, yStart[0], ys, top.color);
                            }
                            yStart[0] = ys;
                        }
                        stripe = new PositionedStripe(color, ye, isThin, layer);
                        stripes.add(i2, stripe);
                        ends.offer(stripe);
                    } else if (stripe.yEnd < ye) {
                        if (!color.equals(stripe.color)) {
                            if (i2 == 0 && yStart[0] != ys) {
                                this.drawSpot(g, stripe.thin, yStart[0], ys, stripe.color);
                                yStart[0] = ys;
                            }
                            stripe.color = color;
                        }
                        ends.remove(stripe);
                        stripe.yEnd = ye;
                        ends.offer(stripe);
                    }
                    return true;
                });
            }
            finally {
                iterator2.dispose();
            }
            this.drawStripesEndingBefore(Integer.MAX_VALUE, thinEnds, thinStripes, g, thinYStart[0]);
            this.drawStripesEndingBefore(Integer.MAX_VALUE, wideEnds, wideStripes, g, wideYStart[0]);
        }

        private int drawStripesEndingBefore(int ys, @NotNull Queue<? extends PositionedStripe> ends, @NotNull List<PositionedStripe> stripes, @NotNull Graphics g, int yStart) {
            PositionedStripe endingStripe;
            while (!ends.isEmpty() && (endingStripe = ends.peek()) != null && endingStripe.yEnd <= ys) {
                ends.remove();
                int i2 = stripes.indexOf(endingStripe);
                stripes.remove(i2);
                if (i2 != 0) continue;
                this.drawSpot(g, endingStripe.thin, yStart, endingStripe.yEnd, endingStripe.color);
                yStart = endingStripe.yEnd;
            }
            return yStart;
        }

        private void drawSpot(@NotNull Graphics g, boolean thinErrorStripeMark, int yStart, int yEnd, @NotNull Color color) {
            int x;
            int paintWidth;
            if (thinErrorStripeMark) {
                paintWidth = EditorMarkupModelImpl.this.getMinMarkHeight();
                int n = x = EditorMarkupModelImpl.this.isMirrored() ? this.getThickness() - paintWidth : 0;
                if (yEnd - yStart < 6) {
                    yEnd += yEnd - --yStart - 1;
                }
            } else {
                x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.this.getMinMarkHeight() + EditorMarkupModelImpl.getThinGap();
                paintWidth = SCROLLBAR_WIDTH.get();
            }
            g.setColor(color);
            g.fillRect(x, yStart, paintWidth, yEnd - yStart);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), () -> this.doMouseClicked(e), EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
        }

        private int getWidth() {
            return this.scrollbar.getWidth();
        }

        private void doMouseClicked(@NotNull MouseEvent e) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)EditorMarkupModelImpl.this.myEditor.getContentComponent(), true));
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth()) {
                EditorMarkupModelImpl.this.doClick(e);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getY() < buttonHeight && EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                this.showTrafficLightTooltip(e);
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth() && EditorMarkupModelImpl.this.showToolTipByMouseMove(e)) {
                UIUtil.setCursor((Component)this.scrollbar, (Cursor)Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e, false);
            if (this.scrollbar.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            if (EditorMarkupModelImpl.this.myEditorFragmentRenderer.getEditorPreviewHint() == null) {
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)e.getComponent().getParent());
                return;
            }
            int units = e.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            if (EditorMarkupModelImpl.this.myLastVisualLine < EditorMarkupModelImpl.this.myEditor.getVisibleLineCount() - 1 && units > 0 || EditorMarkupModelImpl.this.myLastVisualLine > 0 && units < 0) {
                EditorMarkupModelImpl.this.myWheelAccumulator = EditorMarkupModelImpl.this.myWheelAccumulator + units;
            }
            EditorMarkupModelImpl.this.myRowAdjuster = EditorMarkupModelImpl.this.myWheelAccumulator / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            EditorMarkupModelImpl.this.showToolTipByMouseMove(e);
        }

        private void showTrafficLightTooltip(@NotNull MouseEvent e) {
            if (this.myTrafficTooltipRenderer == null) {
                this.myTrafficTooltipRenderer = EditorMarkupModelImpl.this.myTooltipRendererProvider.createTrafficTooltipRenderer(() -> {
                    this.myTrafficTooltipRenderer = null;
                }, EditorMarkupModelImpl.this.myEditor);
            }
            EditorMarkupModelImpl.this.showTooltip(this.myTrafficTooltipRenderer, new HintHint(e).setAwtTooltip(true).setMayCenterPosition(true).setContentActive(false).setPreferredPosition(Balloon.Position.atLeft));
        }

        private void cancelMyToolTips(MouseEvent e, boolean checkIfShouldSurvive) {
            EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            TooltipController tooltipController = TooltipController.getInstance();
            if (!checkIfShouldSurvive || !tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP, e, true);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            LightweightHint currentHint = EditorMarkupModelImpl.this.getCurrentHint();
            if (currentHint != null && !EditorMarkupModelImpl.this.myKeepHint) {
                this.closeHintOnMovingMouseAway(currentHint);
            }
        }

        private void closeHintOnMovingMouseAway(LightweightHint hint) {
            Disposable disposable2 = Disposer.newDisposable();
            IdeEventQueue.getInstance().addDispatcher(e -> {
                if (e.getID() == 501) {
                    EditorMarkupModelImpl.this.myKeepHint = true;
                    Disposer.dispose((Disposable)disposable2);
                } else if (e.getID() == 503 && !hint.isInsideHint(new RelativePoint((MouseEvent)e))) {
                    hint.hide();
                    Disposer.dispose((Disposable)disposable2);
                }
                return false;
            }, disposable2);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            this.cancelMyToolTips(e, true);
        }

        private void setPopupHandler(@NotNull PopupHandler handler2) {
            if (this.myHandler != null) {
                this.scrollbar.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler2;
            this.scrollbar.addMouseListener((MouseListener)handler2);
        }
    }

    private static class PositionedStripe {
        @NotNull
        private Color color;
        private int yEnd;
        private final boolean thin;
        private final int layer;

        private PositionedStripe(@NotNull Color color, int yEnd, boolean thin, int layer) {
            this.color = color;
            this.yEnd = yEnd;
            this.thin = thin;
            this.layer = layer;
        }
    }
}

