/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

class EditorLocation {
    private final Editor myEditor;
    private final Point myPoint;
    private VisualPosition myVisualPosition;
    private LogicalPosition myLogicalPosition;
    private int myOffset = -1;
    private int myVisualLineBaseY = -1;

    EditorLocation(@NotNull Editor editor, @NotNull Point point) {
        this.myEditor = editor;
        this.myPoint = point;
    }

    @NotNull
    Point getPoint() {
        return this.myPoint;
    }

    @NotNull
    VisualPosition getVisualPosition() {
        if (this.myVisualPosition == null) {
            this.myVisualPosition = this.myEditor.xyToVisualPosition(this.myPoint);
        }
        return this.myVisualPosition;
    }

    int getVisualLineBaseY() {
        if (this.myVisualLineBaseY < 0) {
            this.myVisualLineBaseY = this.myEditor.visualLineToY(this.getVisualPosition().line);
        }
        return this.myVisualLineBaseY;
    }

    @NotNull
    LogicalPosition getLogicalPosition() {
        if (this.myLogicalPosition == null) {
            this.myLogicalPosition = this.myEditor.visualToLogicalPosition(this.getVisualPosition());
        }
        return this.myLogicalPosition;
    }

    int getOffset() {
        if (this.myOffset < 0) {
            this.myOffset = this.myEditor.logicalPositionToOffset(this.getLogicalPosition());
        }
        return this.myOffset;
    }
}

