/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.AccessibleGutterLine;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorFilteringMarkupModelEx;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorSizeAdjustmentStrategy;
import com.intellij.openapi.editor.impl.ErrorStripeMarkersModel;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.GutterIconDropAnimator;
import com.intellij.openapi.editor.impl.HighlighterListener;
import com.intellij.openapi.editor.impl.ImmediatePainter;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.toolbar.floating.EditorFloatingToolbar;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacGestureSupportForEditor;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable,
Dumpable,
CodeStyleSettingsListener,
FocusListener {
    public static final int TEXT_ALIGNMENT_LEFT = 0;
    public static final int TEXT_ALIGNMENT_RIGHT = 1;
    private static final int MIN_FONT_SIZE = 8;
    private static final Logger LOG = Logger.getInstance(EditorImpl.class);
    private static final Object DND_COMMAND_GROUP = ObjectUtils.sentinel((String)"DndCommand");
    private static final Object MOUSE_DRAGGED_COMMAND_GROUP = ObjectUtils.sentinel((String)"MouseDraggedGroup");
    private static final Key<JComponent> PERMANENT_HEADER = Key.create((String)"PERMANENT_HEADER");
    static final Key<Boolean> CONTAINS_BIDI_TEXT = Key.create((String)"contains.bidi.text");
    public static final Key<Boolean> FORCED_SOFT_WRAPS = Key.create((String)"forced.soft.wraps");
    public static final Key<Boolean> SOFT_WRAPS_EXIST = Key.create((String)"soft.wraps.exist");
    public static final Key<Boolean> DISABLE_CARET_POSITION_KEEPING = Key.create((String)"editor.disable.caret.position.keeping");
    public static final Key<Boolean> DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION = Key.create((String)"editor.disable.caret.shift.on.whitespace.insertion");
    private static final boolean HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK = Boolean.parseBoolean(System.getProperty("idea.honor.camel.humps.on.triple.click"));
    private static final Key<BufferedImage> BUFFER = Key.create((String)"buffer");
    @NotNull
    private final DocumentEx myDocument;
    private final JPanel myPanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final EditorComponentImpl myEditorComponent;
    @NotNull
    private final EditorGutterComponentImpl myGutterComponent;
    private final TraceableDisposable myTraceableDisposable = new TraceableDisposable(true);
    private final FocusModeModel myFocusModeModel;
    private volatile long myLastTypedActionTimestamp = -1L;
    private String myLastTypedAction;
    private LatencyListener myLatencyPublisher;
    private static final Cursor EMPTY_CURSOR;
    private final Map<Object, Cursor> myCustomCursors = new LinkedHashMap<Object, Cursor>();
    private Cursor myDefaultCursor;
    boolean myCursorSetExternally;
    private final CommandProcessor myCommandProcessor;
    @NotNull
    private final MyScrollBar myVerticalScrollBar;
    private final List<EditorMouseListener> myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final List<EditorMouseMotionListener> myMouseMotionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsInsertMode = true;
    @NotNull
    private final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer = new ScrollingTimer();
    @NotNull
    private final SettingsImpl mySettings;
    private boolean isReleased;
    @Nullable
    private MouseEvent myMousePressedEvent;
    @Nullable
    private MouseEvent myMouseMovedEvent;
    private final MouseListener myMouseListener = new MyMouseAdapter();
    private final MouseMotionListener myMouseMotionListener = new MyMouseMotionListener();
    @Nullable
    private EditorMouseEventArea myMousePressArea;
    private int mySavedSelectionStart = -1;
    private int mySavedSelectionEnd = -1;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private MyEditable myEditable;
    @NotNull
    private EditorColorsScheme myScheme;
    private boolean myIsViewer;
    @NotNull
    private final SelectionModelImpl mySelectionModel;
    @NotNull
    private final EditorMarkupModelImpl myMarkupModel;
    @NotNull
    private final EditorFilteringMarkupModelEx myDocumentMarkupModel;
    @NotNull
    private final MarkupModelListener myMarkupModelListener;
    @NotNull
    private final List<HighlighterListener> myHighlighterListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final FoldingModelImpl myFoldingModel;
    @NotNull
    private final ScrollingModelImpl myScrollingModel;
    @NotNull
    private final CaretModelImpl myCaretModel;
    @NotNull
    private final SoftWrapModelImpl mySoftWrapModel;
    @NotNull
    private final InlayModelImpl myInlayModel;
    @NotNull
    private static final RepaintCursorCommand ourCaretBlinkingCommand;
    @MouseSelectionState
    private int myMouseSelectionState;
    @Nullable
    private FoldRegion myMouseSelectedRegion;
    private int myHorizontalTextAlignment = 0;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private volatile EditorHighlighter myHighlighter;
    private Disposable myHighlighterDisposable = Disposer.newDisposable();
    private final TextDrawingCallback myTextDrawingCallback = new MyTextDrawingCallback();
    private int myScrollBarOrientation;
    private boolean myKeepSelectionOnMousePress;
    private boolean myUpdateCursor;
    private final EditorScrollingPositionKeeper myScrollingPositionKeeper;
    private boolean myRestoreScrollingPosition;
    private int myRangeToRepaintStart;
    private int myRangeToRepaintEnd;
    @Nullable
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final List<FocusChangeListener> myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MyInputMethodHandler myInputMethodRequestsHandler;
    private InputMethodRequests myInputMethodRequestsSwingWrapper;
    private boolean myIsOneLineMode;
    private boolean myIsRendererMode;
    private VirtualFile myVirtualFile;
    private boolean myIsColumnMode;
    @Nullable
    private Color myForcedBackground;
    @Nullable
    private Dimension myPreferredSize;
    private final Alarm myMouseSelectionStateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private Runnable myMouseSelectionStateResetRunnable;
    private boolean myEmbeddedIntoDialogWrapper;
    private int myDragOnGutterSelectionStartLine = -1;
    private RangeMarker myDraggedRange;
    private boolean myDragStarted;
    @NotNull
    private final JPanel myHeaderPanel;
    @Nullable
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private EditorDropHandler myDropHandler;
    private Condition<RangeHighlighter> myHighlightingFilter;
    @NotNull
    private final IndentsModel myIndentsModel;
    @Nullable
    private CharSequence myPlaceholderText;
    @Nullable
    private TextAttributes myPlaceholderAttributes;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myStickySelection;
    private int myStickySelectionStart;
    private boolean myScrollToCaret = true;
    private boolean myPurePaintingMode;
    private boolean myPaintSelection;
    private final EditorSizeAdjustmentStrategy mySizeAdjustmentStrategy = new EditorSizeAdjustmentStrategy();
    private final Disposable myDisposable = Disposer.newDisposable();
    private List<CaretState> myCaretStateBeforeLastPress;
    LogicalPosition myLastMousePressedLocation;
    private VisualPosition myTargetMultiSelectionPosition;
    private boolean myMultiSelectionInProgress;
    private boolean myRectangularSelectionInProgress;
    private boolean myLastPressCreatedCaret;
    private boolean myLastPressWasAtBlockInlay;
    private boolean myCurrentDragIsSubstantial;
    private CaretImpl myPrimaryCaret;
    public final boolean myDisableRtl = Registry.is((String)"editor.disable.rtl");
    public final Object myFractionalMetricsHintValue = EditorImpl.calcFractionalMetricsHint();
    final EditorView myView;
    private boolean myCharKeyPressed;
    private boolean myNeedToSelectPreviousChar;
    private boolean myDocumentChangeInProgress;
    private boolean myErrorStripeNeedsRepaint;
    private String myContextMenuGroupId = "BasicEditorPopupMenu";
    private final List<com.intellij.openapi.editor.ex.EditorPopupHandler> myPopupHandlers = new ArrayList<com.intellij.openapi.editor.ex.EditorPopupHandler>();
    private boolean myUseEditorAntialiasing = true;
    private final ImmediatePainter myImmediatePainter;
    private final List<IntFunction<Collection<LineExtensionInfo>>> myLineExtensionPainters = new SmartList();
    private volatile int myExpectedCaretOffset = -1;
    private boolean myBackgroundImageSet;
    private final EditorKind myKind;
    private boolean myScrollingToCaret;
    private boolean updatingSize;
    private static final Field decrButtonField;
    private static final Field incrButtonField;

    EditorImpl(@NotNull Document document, boolean viewer, @Nullable Project project, @NotNull EditorKind kind) {
        EditorImpl.assertIsDispatchThread();
        this.myProject = project;
        this.myDocument = (DocumentEx)document;
        this.myScheme = this.createBoundColorSchemeDelegate(null);
        this.myScrollPane = new MyScrollPane();
        this.myIsViewer = viewer;
        this.myKind = kind;
        this.mySettings = new SettingsImpl(this, kind);
        MarkupModelEx documentMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myDocumentMarkupModel = new EditorFilteringMarkupModelEx(this, documentMarkup);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.myScrollingModel = new ScrollingModelImpl(this);
        this.myInlayModel = new InlayModelImpl(this);
        Disposer.register((Disposable)this.myCaretModel, (Disposable)this.myInlayModel);
        this.mySoftWrapModel = new SoftWrapModelImpl(this);
        this.myCommandProcessor = CommandProcessor.getInstance();
        this.myImmediatePainter = new ImmediatePainter(this);
        this.myMarkupModelListener = new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.canImpactGutterSize(highlighter), EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes(EditorImpl.this.getColorsScheme())));
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.canImpactGutterSize(highlighter), EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes(EditorImpl.this.getColorsScheme())));
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                EditorImpl.this.onHighlighterChanged(highlighter, renderersChanged, fontStyleOrColorChanged);
            }
        };
        ErrorStripeMarkersModel errorStripeMarkersModel = this.myMarkupModel.getErrorStripeMarkersModel();
        this.myDocumentMarkupModel.addMarkupModelListener(this.myCaretModel, errorStripeMarkersModel.createMarkupListener(true));
        this.myMarkupModel.addMarkupModelListener(this.myCaretModel, errorStripeMarkersModel.createMarkupListener(false));
        this.myMarkupModel.addErrorMarkerListener(new ErrorStripeListener(){

            @Override
            public void errorMarkerChanged(@NotNull ErrorStripeEvent e) {
                EditorImpl.this.errorStripeMarkerChanged((RangeHighlighterEx)e.getHighlighter());
            }
        }, this.myCaretModel);
        this.myDocumentMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myDocument.addDocumentListener(this.myFoldingModel, this.myCaretModel);
        this.myDocument.addDocumentListener(this.myCaretModel, this.myCaretModel);
        this.myDocument.addDocumentListener(new EditorDocumentAdapter(), this.myCaretModel);
        this.myDocument.addDocumentListener(this.mySoftWrapModel, this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.myMarkupModel, this.myCaretModel);
        this.myFoldingModel.addListener(this.mySoftWrapModel, this.myCaretModel);
        this.myInlayModel.addListener((InlayModel.Listener)this.myFoldingModel, this.myCaretModel);
        this.myInlayModel.addListener(this.myCaretModel, this.myCaretModel);
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretModel.addCaretListener(new CaretListener(){
            @Nullable
            private LightweightHint myCurrentHint;
            @Nullable
            private IndentGuideDescriptor myCurrentCaretGuide;

            public void caretPositionChanged(@NotNull CaretEvent e) {
                IndentGuideDescriptor newGuide;
                if (EditorImpl.this.myStickySelection) {
                    int selectionStart = Math.min(EditorImpl.this.myStickySelectionStart, EditorImpl.this.getDocument().getTextLength());
                    EditorImpl.this.mySelectionModel.setSelection(selectionStart, EditorImpl.this.myCaretModel.getVisualPosition(), EditorImpl.this.myCaretModel.getOffset());
                }
                if (!Comparing.equal((Object)this.myCurrentCaretGuide, (Object)(newGuide = EditorImpl.this.myIndentsModel.getCaretIndentGuide()))) {
                    EditorImpl.this.repaintGuide(newGuide);
                    EditorImpl.this.repaintGuide(this.myCurrentCaretGuide);
                    this.myCurrentCaretGuide = newGuide;
                    if (this.myCurrentHint != null) {
                        this.myCurrentHint.hide();
                        this.myCurrentHint = null;
                    }
                    if (newGuide != null) {
                        Rectangle visibleArea = EditorImpl.this.getScrollingModel().getVisibleArea();
                        int endLine = newGuide.startLine;
                        if (EditorImpl.this.logicalLineToY(endLine) < visibleArea.y) {
                            int startLine = Math.max(newGuide.codeConstructStartLine, endLine - EditorFragmentComponent.getAvailableVisualLinesAboveEditor(EditorImpl.this) + 1);
                            TextRange textRange = new TextRange(EditorImpl.this.myDocument.getLineStartOffset(startLine), EditorImpl.this.myDocument.getLineEndOffset(endLine));
                            this.myCurrentHint = EditorFragmentComponent.showEditorFragmentHint(EditorImpl.this, textRange, false, false);
                        }
                    }
                }
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (EditorImpl.this.myPrimaryCaret != null) {
                    EditorImpl.this.myPrimaryCaret.updateVisualPosition();
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
                EditorImpl.this.myPrimaryCaret.updateVisualPosition();
            }
        });
        this.myCaretModel.addCaretListener(this.myMarkupModel, this.myCaretModel);
        this.myCaretCursor = new CaretCursor();
        this.myScrollBarOrientation = 1;
        this.mySoftWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListener(){

            @Override
            public void recalculationEnds() {
                if (EditorImpl.this.myCaretModel.isUpToDate()) {
                    EditorImpl.this.myCaretModel.updateVisualPosition();
                }
            }

            @Override
            public void softWrapsChanged() {
                EditorImpl.this.myGutterComponent.clearLineToGutterRenderersCache();
            }
        });
        NullEditorHighlighter highlighter = new NullEditorHighlighter();
        this.setHighlighter(highlighter);
        new FoldingPopupManager(this);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myVerticalScrollBar = (MyScrollBar)((Object)this.myScrollPane.getVerticalScrollBar());
        if (this.shouldScrollBarBeOpaque()) {
            this.myVerticalScrollBar.setOpaque(true);
        }
        this.myPanel = new JPanel();
        ComponentUtil.putClientProperty((JComponent)this.myPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            JComponent component2 = this.getPermanentHeaderComponent();
            if (component2 != null && component2.getParent() == null) {
                return Collections.singleton(component2).iterator();
            }
            return Collections.emptyIterator();
        });
        this.myHeaderPanel = new MyHeaderPanel();
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        this.initComponent();
        this.myView = new EditorView(this);
        this.myView.reinitSettings();
        this.myInlayModel.addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

            public void onUpdated(@NotNull Inlay inlay, int changeFlags) {
                EditorImpl.this.onInlayUpdated(inlay, changeFlags);
            }

            public void onBatchModeFinish(@NotNull Editor editor) {
                EditorImpl.this.onInlayBatchModeFinish();
            }
        }, this.myCaretModel);
        if (UISettings.getInstance().getPresentationMode()) {
            this.setFontSize(UISettings.getInstance().getPresentationModeFontSize());
        }
        this.myGutterComponent.updateSize();
        Dimension preferredSize = this.getPreferredSize();
        this.myEditorComponent.setSize(preferredSize);
        this.updateCaretCursor();
        if (SystemInfo.isMacIntel64 && SystemInfo.isJetBrainsJvm) {
            new MacGestureSupportForEditor(this.getComponent());
        }
        this.myScrollingModel.addVisibleAreaListener(this::moveCaretIntoViewIfCoveredByToolWindowBelow);
        this.myScrollingModel.addVisibleAreaListener(this.myMarkupModel);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("writable".equals(e.getPropertyName())) {
                    EditorImpl.this.myEditorComponent.repaint();
                }
            }
        };
        this.myDocument.addPropertyChangeListener(propertyChangeListener);
        Disposer.register((Disposable)this.myDisposable, () -> this.myDocument.removePropertyChangeListener(propertyChangeListener));
        CodeStyleSettingsManager.getInstance((Project)this.myProject).addListener((CodeStyleSettingsListener)this);
        this.myFocusModeModel = new FocusModeModel(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFocusModeModel);
        this.myPopupHandlers.add(new DefaultPopupHandler());
        this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScrollingPositionKeeper);
    }

    public void applyFocusMode() {
        this.myFocusModeModel.applyFocusMode(this.myCaretModel.getPrimaryCaret());
    }

    public boolean isInFocusMode(FoldRegion region) {
        return this.myFocusModeModel.isInFocusMode((RangeMarker)region);
    }

    public Segment getFocusModeRange() {
        return this.myFocusModeModel.getFocusModeRange();
    }

    public FocusModeModel getFocusModeModel() {
        return this.myFocusModeModel;
    }

    @Override
    public void focusGained(@NotNull FocusEvent e) {
        this.myCaretCursor.activate();
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusGained(e);
    }

    @Override
    public void focusLost(@NotNull FocusEvent e) {
        this.clearCaretThread();
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusLost(e);
    }

    private boolean canImpactGutterSize(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter.getGutterIconRenderer() != null) {
            return true;
        }
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer == null) {
            return false;
        }
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
        return position == LineMarkerRendererEx.Position.LEFT && !this.myGutterComponent.myForceLeftFreePaintersAreaShown || position == LineMarkerRendererEx.Position.RIGHT && !this.myGutterComponent.myForceRightFreePaintersAreaShown;
    }

    private void errorStripeMarkerChanged(@NotNull RangeHighlighterEx highlighter) {
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if (this.myDocumentChangeInProgress) {
            this.myErrorStripeNeedsRepaint = true;
            return;
        }
        if (this.myFoldingModel.isInBatchFoldingOperation()) {
            this.myErrorStripeNeedsRepaint = true;
        } else {
            int start2 = highlighter.getAffectedAreaStartOffset();
            int end = highlighter.getAffectedAreaEndOffset();
            this.myMarkupModel.repaint(start2, end);
        }
    }

    private void onHighlighterChanged(@NotNull RangeHighlighterEx highlighter, boolean canImpactGutterSize, boolean fontStyleOrColorChanged) {
        int endLine;
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if (canImpactGutterSize) {
            this.updateGutterSize();
        }
        if (this.myDocumentChangeInProgress) {
            return;
        }
        int textLength = this.myDocument.getTextLength();
        int start2 = MathUtil.clamp((int)highlighter.getAffectedAreaStartOffset(), (int)0, (int)textLength);
        int end = MathUtil.clamp((int)highlighter.getAffectedAreaEndOffset(), (int)0, (int)textLength);
        if (this.getGutterComponentEx().getCurrentAccessibleLine() != null && AccessibleGutterLine.isAccessibleGutterElement(highlighter.getGutterIconRenderer())) {
            this.escapeGutterAccessibleLine(start2, end);
        }
        int startLine = start2 == -1 ? 0 : this.myDocument.getLineNumber(start2);
        int n = endLine = end == -1 ? this.myDocument.getLineCount() : this.myDocument.getLineNumber(end);
        if (start2 != end && fontStyleOrColorChanged) {
            this.myView.invalidateRange(start2, end);
        }
        if (!this.myFoldingModel.isInBatchFoldingOperation()) {
            this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, this.getDocument().getLineCount()));
        }
        this.updateCaretCursor();
    }

    private void onInlayUpdated(@NotNull Inlay inlay, int changeFlags) {
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if ((changeFlags & 4) != 0) {
            this.updateGutterSize();
        }
        if (this.myDocument.isInEventsHandling() || (changeFlags & 3) == 0) {
            return;
        }
        this.validateSize();
        int offset = inlay.getOffset();
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.INLINE) {
            this.repaint(offset, offset, false);
        } else if (placement == Inlay.Placement.AFTER_LINE_END) {
            int lineEndOffset = DocumentUtil.getLineEndOffset(offset, this.myDocument);
            this.repaint(lineEndOffset, lineEndOffset, false);
        } else {
            int visualLine = this.offsetToVisualLine(offset);
            int y = EditorUtil.getVisualLineAreaStartY(this, visualLine);
            this.repaintToScreenBottomStartingFrom(y);
        }
    }

    private void onInlayBatchModeFinish() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.validateSize();
        this.updateGutterSize();
        this.myEditorComponent.repaint();
        this.myGutterComponent.repaint();
        this.myMarkupModel.repaint();
        this.updateCaretCursor();
    }

    private void moveCaretIntoViewIfCoveredByToolWindowBelow(VisibleAreaEvent e) {
        int caretY;
        Rectangle oldRectangle = e.getOldRectangle();
        Rectangle newRectangle = e.getNewRectangle();
        if (!this.myScrollingToCaret && oldRectangle != null && oldRectangle.height != newRectangle.height && oldRectangle.y == newRectangle.y && newRectangle.height > 0 && (double)(caretY = this.myView.visualLineToY(this.myCaretModel.getVisualPosition().line)) < oldRectangle.getMaxY() && (double)caretY > newRectangle.getMaxY()) {
            this.myScrollingToCaret = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myScrollingToCaret = false;
                if (!this.isReleased) {
                    EditorUtil.runWithAnimationDisabled(this, () -> this.myScrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE));
                }
            }, ModalityState.any());
        }
    }

    boolean shouldScrollBarBeOpaque() {
        return !this.myBackgroundImageSet && !Registry.is((String)"editor.transparent.scrollbar");
    }

    @NotNull
    static Color adjustThumbColor(@NotNull Color base, boolean dark) {
        return dark ? ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)1.35), (double)0.5) : ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)0.68), (double)0.4);
    }

    boolean isDarkEnough() {
        return ColorUtil.isDark((Color)this.getBackgroundColor());
    }

    private void repaintCaretRegion(CaretEvent e) {
        CaretImpl caretImpl = (CaretImpl)e.getCaret();
        if (caretImpl != null) {
            caretImpl.updateVisualPosition();
            if (caretImpl.hasSelection()) {
                this.repaint(caretImpl.getSelectionStart(), caretImpl.getSelectionEnd(), false);
            }
        }
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        return new MyColorSchemeDelegate(customGlobalScheme);
    }

    private void repaintGuide(@Nullable IndentGuideDescriptor guide) {
        if (guide != null) {
            this.repaintLines(guide.startLine, guide.endLine);
        }
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return (int)this.myView.getPrefixTextWidthInPixels();
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.mySoftWrapModel.recalculate();
        this.myView.setPrefix(prefixText, attributes);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myPurePaintingMode;
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myPurePaintingMode = enabled;
    }

    @Override
    public void registerLineExtensionPainter(IntFunction<Collection<LineExtensionInfo>> lineExtensionPainter) {
        this.myLineExtensionPainters.add(lineExtensionPainter);
    }

    public boolean processLineExtensions(int line, Processor<? super LineExtensionInfo> processor2) {
        for (IntFunction<Collection<LineExtensionInfo>> painter : this.myLineExtensionPainters) {
            for (LineExtensionInfo extension : painter.apply(line)) {
                if (processor2.process((Object)extension)) continue;
                return false;
            }
        }
        if (this.myProject != null && this.myVirtualFile != null) {
            for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                Collection<LineExtensionInfo> extensions2;
                if (LightEdit.owns((Project)this.myProject) && !(painter instanceof LightEditCompatible) || (extensions2 = painter.getLineExtensions(this.myProject, this.myVirtualFile, line)) == null) continue;
                for (LineExtensionInfo extension : extensions2) {
                    if (processor2.process((Object)extension)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback2) {
        this.myVerticalScrollBar.registerRepaintCallback(callback2);
    }

    @Override
    public int getExpectedCaretOffset() {
        int expectedCaretOffset = this.myExpectedCaretOffset;
        return expectedCaretOffset == -1 ? this.getCaretModel().getOffset() : expectedCaretOffset;
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId2) {
        this.myContextMenuGroupId = groupId2;
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myContextMenuGroupId;
    }

    @Override
    public void installPopupHandler(@NotNull com.intellij.openapi.editor.ex.EditorPopupHandler popupHandler) {
        this.myPopupHandlers.add(popupHandler);
    }

    @Override
    public void uninstallPopupHandler(@NotNull com.intellij.openapi.editor.ex.EditorPopupHandler popupHandler) {
        this.myPopupHandlers.remove(popupHandler);
    }

    @Nullable
    private Cursor getCustomCursor() {
        return (Cursor)ContainerUtil.getFirstItem(this.myCustomCursors.values());
    }

    @Override
    public void setCustomCursor(@NotNull Object requestor, @Nullable Cursor cursor) {
        if (cursor == null) {
            this.myCustomCursors.remove(requestor);
        } else {
            this.myCustomCursors.put(requestor, cursor);
        }
        this.updateEditorCursor();
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myIsViewer = isViewer;
    }

    public boolean isViewer() {
        return this.myIsViewer || this.myIsRendererMode;
    }

    @Override
    public boolean isRendererMode() {
        return this.myIsRendererMode;
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myIsRendererMode = isRendererMode;
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myVirtualFile = vFile;
        this.reinitSettings();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public SelectionModelImpl getSelectionModel() {
        return this.mySelectionModel;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        return this.myMarkupModel;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        return this.myDocumentMarkupModel;
    }

    @Override
    @NotNull
    public FoldingModelImpl getFoldingModel() {
        return this.myFoldingModel;
    }

    @NotNull
    public CaretModelImpl getCaretModel() {
        return this.myCaretModel;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        return this.myScrollingModel;
    }

    @Override
    @NotNull
    public SoftWrapModelImpl getSoftWrapModel() {
        return this.mySoftWrapModel;
    }

    @NotNull
    public InlayModelImpl getInlayModel() {
        return this.myInlayModel;
    }

    @NotNull
    public EditorKind getEditorKind() {
        return this.myKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorImpl.assertReadAccess();
        return this.mySettings;
    }

    public void resetSizes() {
        this.myView.reset();
    }

    @Override
    public void reinitSettings() {
        this.reinitSettings(true);
    }

    private void reinitSettings(boolean updateGutterSize) {
        EditorImpl.assertIsDispatchThread();
        EditorColorsScheme scheme = this.myScheme;
        while (scheme instanceof DelegateColorScheme) {
            if (scheme instanceof MyColorSchemeDelegate) {
                ((MyColorSchemeDelegate)scheme).updateGlobalScheme();
                break;
            }
            scheme = ((DelegateColorScheme)scheme).getDelegate();
        }
        boolean softWrapsUsedBefore = this.mySoftWrapModel.isSoftWrappingEnabled();
        this.mySettings.reinitSettings();
        this.mySoftWrapModel.reinitSettings();
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        EditorImpl.ourCaretBlinkingCommand.setBlinkCaret(this.mySettings.isBlinkCaret());
        EditorImpl.ourCaretBlinkingCommand.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.myView.reinitSettings();
        this.myFoldingModel.refreshSettings();
        this.myFoldingModel.rebuild();
        this.myInlayModel.reinitSettings();
        if (softWrapsUsedBefore ^ this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.validateSize();
        }
        this.myHighlighter.setColorScheme(this.myScheme);
        this.myMarkupModel.rebuild();
        this.myGutterComponent.reinitSettings(updateGutterSize);
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
        this.myCaretModel.updateVisualPosition();
        this.getCaretModel().doWithCaretMerging(() -> this.myCaretModel.getAllCarets().forEach(caret -> caret.moveToOffset(caret.getOffset())));
        if (this.myVirtualFile != null && this.myProject != null) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
        if (this.myFocusModeModel != null) {
            this.myFocusModeModel.clearFocusMode();
        }
    }

    void throwEditorNotDisposedError(@NonNls @NotNull String msg) {
        this.myTraceableDisposable.throwObjectNotDisposedError(msg);
    }

    public void throwDisposalError(@NonNls @NotNull String msg) {
        this.myTraceableDisposable.throwDisposalError(msg);
    }

    void release() {
        EditorImpl.assertIsDispatchThread();
        if (this.isReleased) {
            this.throwDisposalError("Double release of editor:");
        }
        this.myTraceableDisposable.kill(null);
        this.isReleased = true;
        this.mySizeAdjustmentStrategy.cancelAllRequests();
        this.cancelAutoResetForMouseSelectionState();
        this.myFoldingModel.dispose();
        this.mySoftWrapModel.release();
        this.myMarkupModel.dispose();
        this.myScrollingModel.dispose();
        this.myGutterComponent.dispose();
        this.myMousePressedEvent = null;
        this.myMouseMovedEvent = null;
        Disposer.dispose((Disposable)this.myCaretModel);
        Disposer.dispose((Disposable)this.mySoftWrapModel);
        Disposer.dispose((Disposable)this.myView);
        this.clearCaretThread();
        this.myFocusListeners.clear();
        this.myMouseListeners.clear();
        this.myMouseMotionListeners.clear();
        this.myEditorComponent.removeFocusListener(this);
        this.myEditorComponent.removeMouseListener(this.myMouseListener);
        this.myGutterComponent.removeMouseListener(this.myMouseListener);
        this.myEditorComponent.removeMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.removeMouseMotionListener(this.myMouseMotionListener);
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myVerticalScrollBar.setPersistentUI(JBScrollBar.createUI(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            if (ourCaretBlinkingCommand.myEditor == this) {
                ourCaretBlinkingCommand.myEditor = null;
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        this.myScrollPane.setViewportView(this.myEditorComponent);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.myEditorComponent.setTransferHandler(new MyTransferHandler());
        this.myEditorComponent.setAutoscrolls(false);
        if (this.mayShowToolbar()) {
            JBLayeredPane layeredPane = new JBLayeredPane(){

                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle r = this.getBounds();
                    for (Component c : components) {
                        if (c instanceof JScrollPane) {
                            c.setBounds(0, 0, r.width, r.height);
                            continue;
                        }
                        Dimension d = c.getPreferredSize();
                        int rightInsets = EditorImpl.this.getVerticalScrollBar().getWidth() + (EditorImpl.this.isMirrored() ? EditorImpl.this.myGutterComponent.getWidth() : 0);
                        c.setBounds(r.width - d.width - rightInsets - 20, 20, d.width, d.height);
                    }
                }

                public Dimension getPreferredSize() {
                    return EditorImpl.this.myScrollPane.getPreferredSize();
                }
            };
            layeredPane.add((Component)this.myScrollPane, JLayeredPane.DEFAULT_LAYER);
            layeredPane.add((Component)new EditorFloatingToolbar(this), JLayeredPane.POPUP_LAYER);
            this.myPanel.add((Component)layeredPane);
        } else {
            this.myPanel.add(this.myScrollPane);
        }
        this.myEditorComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                    EditorImpl.this.myCharKeyPressed = true;
                }
            }

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                if (event.isConsumed()) {
                    return;
                }
                if (EditorImpl.this.processKeyTyped(event)) {
                    event.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditorImpl.this.myCharKeyPressed = false;
            }
        });
        this.myEditorComponent.addMouseListener(this.myMouseListener);
        this.myGutterComponent.addMouseListener(this.myMouseListener);
        this.myEditorComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myEditorComponent.addFocusListener(this);
        UiNotifyConnector connector = new UiNotifyConnector((Component)this.myEditorComponent, new Activatable(){

            public void showNotify() {
                EditorImpl.this.myGutterComponent.updateSizeOnShowNotify();
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)connector);
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(@NotNull DropTargetDropEvent e) {
                    }

                    @Override
                    public void dragOver(@NotNull DropTargetDragEvent e) {
                        Point location = e.getLocation();
                        EditorImpl.this.getCaretModel().moveToVisualPosition(EditorImpl.this.getTargetPosition(location.x, location.y, true));
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        EditorImpl.this.requestFocus();
                    }
                });
            }
        }
        catch (TooManyListenersException e2) {
            LOG.error((Throwable)e2);
        }
        this.myPanel.addHierarchyListener(e -> this.mySoftWrapModel.getApplianceManager().updateAvailableArea());
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            @DirtyUI
            public void componentResized(@NotNull ComponentEvent e) {
                EditorImpl.this.myMarkupModel.recalcEditorDimensions();
                EditorImpl.this.myMarkupModel.repaint();
                if (!EditorImpl.this.isRightAligned()) {
                    return;
                }
                EditorImpl.this.updateCaretCursor();
                EditorImpl.this.myCaretCursor.repaint();
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isEmbeddedIntoDialogWrapper() && !this.isOneLineMode() && !DiffUtil.isDiffEditor(this) && this.isFileEditor();
    }

    private boolean isFileEditor() {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = documentManager.getFile((Document)this.myDocument);
        return virtualFile != null && virtualFile.isValid();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(fontSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSize(int fontSize, @Nullable Point zoomCenter) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        Rectangle visibleArea = this.myScrollingModel.getVisibleArea();
        Point zoomCenterRelative = zoomCenter == null ? new Point() : zoomCenter;
        Point zoomCenterAbsolute = new Point(visibleArea.x + zoomCenterRelative.x, visibleArea.y + zoomCenterRelative.y);
        LogicalPosition zoomCenterLogical = this.xyToLogicalPosition(zoomCenterAbsolute);
        int oldLineHeight = this.getLineHeight();
        int intraLineOffset = zoomCenterAbsolute.y % oldLineHeight;
        this.myScheme.setEditorFontSize(fontSize);
        fontSize = this.myScheme.getEditorFontSize();
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
        this.myScrollPane.getViewport().invalidate();
        Point shiftedZoomCenterAbsolute = this.logicalPositionToXY(zoomCenterLogical);
        this.myScrollingModel.disableAnimation();
        try {
            int targetX = visibleArea.x == 0 ? 0 : shiftedZoomCenterAbsolute.x - zoomCenterRelative.x;
            int targetY = shiftedZoomCenterAbsolute.y - zoomCenterRelative.y + (intraLineOffset * this.getLineHeight() + oldLineHeight / 2) / oldLineHeight;
            this.myScrollingModel.scroll(targetX, targetY);
        }
        finally {
            this.myScrollingModel.enableAnimation();
        }
    }

    public int getFontSize() {
        return this.myScheme.getEditorFontSize();
    }

    @NotNull
    public ActionCallback type(@NotNull String text) {
        ActionCallback result2 = new ActionCallback();
        for (int i2 = 0; i2 < text.length(); ++i2) {
            this.myLastTypedActionTimestamp = System.currentTimeMillis();
            char c = text.charAt(i2);
            this.myLastTypedAction = Character.toString(c);
            if (this.processKeyTyped(c)) continue;
            result2.setRejected();
            return result2;
        }
        result2.setDone();
        return result2;
    }

    private boolean processKeyTyped(char c) {
        if (ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile((Document)this.myDocument);
        if (file2 != null && !file2.isValid()) {
            return false;
        }
        DataContext context = this.getDataContext();
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)this.myEditorComponent);
        if (graphics != null) {
            PaintUtil.alignTxToInt((Graphics2D)((Graphics2D)graphics), (Point2D)PaintUtil.insets2offset((Insets)this.getInsets()), (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
            this.processKeyTypedImmediately(c, graphics, context);
            graphics.dispose();
        }
        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, context);
        EditorUIUtil.hideCursorInEditor(this);
        this.processKeyTypedNormally(c, context);
        return true;
    }

    void processKeyTypedImmediately(char c, Graphics graphics, DataContext dataContext) {
        EditorActionPlan plan = new EditorActionPlan(this);
        EditorActionManager.getInstance();
        TypedAction.getInstance().beforeActionPerformed((Editor)this, c, dataContext, (ActionPlan)plan);
        if (this.myImmediatePainter.paint(graphics, plan)) {
            this.measureTypingLatency();
            this.myLastTypedActionTimestamp = -1L;
        }
    }

    void processKeyTypedNormally(char c, DataContext dataContext) {
        EditorActionManager.getInstance();
        TypedAction.getInstance().actionPerformed((Editor)this, c, dataContext);
    }

    private void fireFocusLost(@NotNull FocusEvent event) {
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusLost(this, event);
        }
    }

    private void fireFocusGained(@NotNull FocusEvent event) {
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusGained(this, event);
        }
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        if (this.isReleased) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.getDocument();
        Disposer.dispose((Disposable)this.myHighlighterDisposable);
        document.addDocumentListener((DocumentListener)highlighter);
        this.myHighlighterDisposable = () -> document.removeDocumentListener((DocumentListener)highlighter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myHighlighterDisposable);
        highlighter.setEditor((HighlighterClient)this);
        highlighter.setText(document.getImmutableCharSequence());
        if (!(highlighter instanceof EmptyEditorHighlighter)) {
            EditorHighlighterCache.rememberEditorHighlighterForCachesOptimization(document, highlighter);
        }
        this.myHighlighter = highlighter;
        if (this.myPanel != null) {
            this.reinitSettings();
        }
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorImpl.assertReadAccess();
        return this.myHighlighter;
    }

    @NotNull
    public EditorComponentImpl getContentComponent() {
        return this.myEditorComponent;
    }

    @Override
    @NotNull
    public EditorGutterComponentImpl getGutterComponentEx() {
        return this.myGutterComponent;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removePropertyChangeListener(listener2));
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsInsertMode;
        this.myIsInsertMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, mode);
        this.myCaretCursor.repaint();
    }

    public boolean isInsertMode() {
        return this.myIsInsertMode;
    }

    @Override
    public void setColumnMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsColumnMode;
        this.myIsColumnMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, mode);
    }

    public boolean isColumnMode() {
        return this.myIsColumnMode;
    }

    public int yToVisualLine(int y) {
        return this.myView.yToVisualLine(y);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        return this.myView.xyToVisualPosition(p);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        return this.myView.xyToVisualPosition(p);
    }

    @NotNull
    public Point2D offsetToPoint2D(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        return this.myView.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
    }

    @NotNull
    public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        Point2D point2D = this.offsetToPoint2D(offset, leanForward, beforeSoftWrap);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        return this.offsetToVisualPosition(offset, false, false);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.myView.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
    }

    public int offsetToVisualColumnInFoldRegion(@NotNull FoldRegion region, int offset, boolean leanTowardsLargerOffsets) {
        EditorImpl.assertIsDispatchThread();
        return this.myView.offsetToVisualColumnInFoldRegion(region, offset, leanTowardsLargerOffsets);
    }

    public int visualColumnToOffsetInFoldRegion(@NotNull FoldRegion region, int visualColumn, boolean leansRight) {
        EditorImpl.assertIsDispatchThread();
        return this.myView.visualColumnToOffsetInFoldRegion(region, visualColumn, leansRight);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        return this.myView.offsetToLogicalPosition(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretActive() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            ourCaretBlinkingCommand.myEditor = this;
        }
    }

    public int offsetToVisualLine(int offset) {
        return this.myView.offsetToVisualLine(offset, false);
    }

    public int visualLineStartOffset(int visualLine) {
        return this.myView.visualLineToOffset(visualLine);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        return this.visualToLogicalPosition(this.xyToVisualPosition(pp));
    }

    private int logicalToVisualLine(int logicalLine) {
        return logicalLine < this.myDocument.getLineCount() ? this.offsetToVisualLine(this.myDocument.getLineStartOffset(logicalLine)) : this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line;
    }

    private int logicalLineToY(int line) {
        int visualLine = this.logicalToVisualLine(line);
        return this.visualLineToY(visualLine);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        VisualPosition visible = this.logicalToVisualPosition(pos);
        return this.visualPositionToXY(visible);
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        Point2D point2D = this.myView.visualPositionToXY(visible);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition visible) {
        return this.myView.visualPositionToXY(visible);
    }

    public float getScale() {
        if (!Registry.is((String)"editor.scale.gutter.icons")) {
            return 1.0f;
        }
        float normLineHeight = (float)this.getLineHeight() / this.myScheme.getLineSpacing();
        return normLineHeight / JBUIScale.scale((float)16.0f);
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        return this.myView.findNearestDirectionBoundary(offset, lookForward);
    }

    public int visualLineToY(int line) {
        return this.myView.visualLineToY(line);
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.repaint(startOffset, endOffset, true);
        this.myHighlighterListeners.forEach(listener2 -> listener2.highlighterChanged(startOffset, endOffset));
    }

    public void addHighlighterListener(HighlighterListener listener2, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener2, this.myHighlighterListeners, (Disposable)parentDisposable);
    }

    void repaint(int startOffset, int endOffset, boolean invalidateTextLayout) {
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        endOffset = Math.min(endOffset, this.myDocument.getTextLength());
        if (invalidateTextLayout) {
            this.myView.invalidateRange(startOffset, endOffset);
        }
        if (!this.isShowing()) {
            return;
        }
        if (this.myDocumentChangeInProgress) {
            if (startOffset < this.myRangeToRepaintStart) {
                this.myRangeToRepaintStart = startOffset;
            }
            if (endOffset < this.myRangeToRepaintEnd) {
                this.myRangeToRepaintEnd = endOffset;
            }
            return;
        }
        if (startOffset <= endOffset) {
            int startLine = this.myView.offsetToVisualLine(startOffset, false);
            int endLine = this.myView.offsetToVisualLine(endOffset, true);
            this.doRepaint(startLine, endLine);
        }
    }

    private boolean isShowing() {
        return this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBottom(int startLine) {
        int yStartLine = this.logicalLineToY(startLine);
        this.repaintToScreenBottomStartingFrom(yStartLine);
    }

    private void repaintToScreenBottomStartingFrom(int y) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yEndLine = visibleArea.y + visibleArea.height;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, y, visibleArea.x + visibleArea.width, yEndLine - y);
        this.myGutterComponent.repaint(0, y, this.myGutterComponent.getWidth(), yEndLine - y);
        this.myMarkupModel.repaint();
    }

    private void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        int startVisualLine = this.logicalToVisualLine(startLine);
        int endVisualLine = this.myDocument.getTextLength() <= 0 ? 0 : this.offsetToVisualLine(this.myDocument.getLineEndOffset(Math.min(this.myDocument.getLineCount() - 1, endLine)));
        this.doRepaint(startVisualLine, endVisualLine);
    }

    private void doRepaint(int startVisualLine, int endVisualLine) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStart = this.visualLineToY(startVisualLine);
        int height = this.visualLineToY(endVisualLine) + this.getLineHeight() + 2 - yStart;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStart, visibleArea.x + visibleArea.width, height);
        this.myGutterComponent.repaint(0, yStart, this.myGutterComponent.getWidth(), height);
    }

    private void bulkUpdateStarted() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be started from batch inlay operation");
        }
        this.myView.getPreferredSize();
        this.myScrollingModel.onBulkDocumentUpdateStarted();
        this.myScrollingPositionKeeper.savePosition();
        this.myCaretModel.onBulkDocumentUpdateStarted();
        this.mySoftWrapModel.onBulkDocumentUpdateStarted();
        this.myFoldingModel.onBulkDocumentUpdateStarted();
    }

    private void bulkUpdateFinished() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be finished from batch inlay operation");
        }
        this.myFoldingModel.onBulkDocumentUpdateFinished();
        this.mySoftWrapModel.onBulkDocumentUpdateFinished();
        this.myView.reset();
        this.myCaretModel.onBulkDocumentUpdateFinished();
        this.setMouseSelectionState(0);
        this.validateSize();
        this.updateGutterSize();
        this.repaintToScreenBottom(0);
        this.updateCaretCursor();
        if (!Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING))) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void beforeChangedUpdate(DocumentEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDocumentChangeInProgress = true;
        if (this.isStickySelection()) {
            this.setStickySelection(false);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.myRangeToRepaintStart = Integer.MAX_VALUE;
        this.myRangeToRepaintEnd = 0;
        boolean bl = this.myRestoreScrollingPosition = this.getCaretModel().getOffset() < e.getOffset() || this.getCaretModel().getOffset() > e.getOffset() + e.getOldLength();
        if (this.myRestoreScrollingPosition) {
            this.myScrollingPositionKeeper.savePosition();
        }
    }

    void invokeDelayedErrorStripeRepaint() {
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint();
            this.myErrorStripeNeedsRepaint = false;
        }
    }

    private void changedUpdate(DocumentEvent e) {
        this.myDocumentChangeInProgress = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint(e.getOffset(), e.getOffset() + e.getNewLength());
            this.myErrorStripeNeedsRepaint = false;
        }
        this.setMouseSelectionState(0);
        if (this.getGutterComponentEx().getCurrentAccessibleLine() != null) {
            this.escapeGutterAccessibleLine(e.getOffset(), e.getOffset() + e.getNewLength());
        }
        this.validateSize();
        int startLine = this.offsetToLogicalLine(e.getOffset());
        int endLine = this.offsetToLogicalLine(e.getOffset() + e.getNewLength());
        if (startLine != endLine || StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1) {
            this.myGutterComponent.clearLineToGutterRenderersCache();
        }
        if (this.myRangeToRepaintStart < this.myDocument.getLineStartOffset(startLine)) {
            startLine = this.myDocument.getLineNumber(this.myRangeToRepaintStart);
        }
        if (this.myRangeToRepaintEnd > this.myDocument.getLineEndOffset(endLine)) {
            endLine = this.myDocument.getLineNumber(this.myRangeToRepaintEnd);
        }
        if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
            this.repaintToScreenBottom(startLine);
        } else {
            this.repaintLines(startLine, endLine);
        }
        this.updateCaretCursor();
        if (this.myRestoreScrollingPosition && !Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING))) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void escapeGutterAccessibleLine(int offsetStart, int offsetEnd) {
        int startVisLine = this.offsetToVisualLine(offsetStart);
        int endVisLine = this.offsetToVisualLine(offsetEnd);
        int line = this.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (startVisLine <= line && endVisLine >= line) {
            this.getGutterComponentEx().escapeCurrentAccessibleLine();
        }
    }

    public void hideCursor() {
        if (!this.myIsViewer && EMPTY_CURSOR != null && Registry.is((String)"ide.hide.cursor.when.typing")) {
            this.myDefaultCursor = EMPTY_CURSOR;
            this.updateEditorCursor();
        }
    }

    public boolean isCursorHidden() {
        return this.myDefaultCursor == EMPTY_CURSOR;
    }

    public boolean isScrollToCaret() {
        return this.myScrollToCaret;
    }

    public void setScrollToCaret(boolean scrollToCaret) {
        this.myScrollToCaret = scrollToCaret;
    }

    @NotNull
    public Disposable getDisposable() {
        return this.myDisposable;
    }

    private static int countLineFeeds(@NotNull CharSequence c) {
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        EditorImpl.assertIsDispatchThread();
        if (!this.updatingSize) {
            this.updatingSize = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (!this.isDisposed()) {
                        this.myGutterComponent.updateSize();
                    }
                }
                finally {
                    this.updatingSize = false;
                }
            }, ModalityState.any(), __ -> this.isDisposed());
        }
    }

    void validateSize() {
        if (this.isReleased) {
            return;
        }
        Dimension dim = this.getPreferredSize();
        if (!(dim.equals(this.myPreferredSize) || this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode() || (dim = this.mySizeAdjustmentStrategy.adjust(dim, this.myPreferredSize, this)).equals(this.myPreferredSize))) {
            this.myPreferredSize = dim;
            this.updateGutterSize();
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.recalcEditorDimensions();
            this.myMarkupModel.repaint();
        }
    }

    void recalculateSizeAndRepaint() {
        this.validateSize();
        this.myEditorComponent.repaint();
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        return this.myDocument;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        this.myMouseListeners.add(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        boolean success = this.myMouseListeners.remove(listener2);
        LOG.assertTrue(success || this.isReleased);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        this.myMouseMotionListeners.add(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        boolean success = this.myMouseMotionListeners.remove(listener2);
        LOG.assertTrue(success || this.isReleased);
    }

    @Override
    public boolean isStickySelection() {
        return this.myStickySelection;
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myStickySelection = enable;
        if (enable) {
            this.myStickySelectionStart = this.getCaretModel().getOffset();
        } else {
            this.mySelectionModel.removeSelection();
        }
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    public boolean isRightAligned() {
        return this.myHorizontalTextAlignment == 1;
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    public void stopDumbLater() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::stopDumb, ModalityState.current(), __ -> this.isDisposed());
    }

    private void stopDumb() {
        this.putUserData(BUFFER, null);
    }

    public void startDumb() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !this.myEditorComponent.isShowing()) {
            return;
        }
        if (!Registry.is((String)"editor.dumb.mode.available")) {
            return;
        }
        this.putUserData(BUFFER, null);
        Rectangle rect = ((JViewport)this.myEditorComponent.getParent()).getViewRect();
        BufferedImage image = UIUtil.createImage((Component)this.myEditorComponent, (int)rect.width, (int)rect.height, (int)1);
        Graphics2D imageGraphics = image.createGraphics();
        ((Graphics)imageGraphics).translate(-rect.x, -rect.y);
        Graphics2D graphics = JBSwingUtilities.runGlobalCGTransform((JComponent)this.myEditorComponent, (Graphics)imageGraphics);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        this.myEditorComponent.paintComponent(graphics);
        graphics.dispose();
        this.putUserData(BUFFER, image);
    }

    public boolean isDumb() {
        return this.getUserData(BUFFER) != null;
    }

    void paint(@NotNull Graphics2D g) {
        BufferedImage buffer;
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        BufferedImage bufferedImage = buffer = Registry.is((String)"editor.dumb.mode.available") ? (BufferedImage)this.getUserData(BUFFER) : null;
        if (buffer != null) {
            Rectangle rect = this.getContentComponent().getVisibleRect();
            StartupUiUtil.drawImage((Graphics)g, (BufferedImage)buffer, null, (int)rect.x, (int)rect.y);
            return;
        }
        if (this.isReleased) {
            g.setColor(this.getDisposedBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        if (this.myUpdateCursor && !this.myPurePaintingMode) {
            this.setCursorPosition();
            this.myUpdateCursor = false;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.myView.paint(g);
        boolean isBackgroundImageSet = IdeBackgroundUtil.isEditorBackgroundImageSet(this.myProject);
        if (this.myBackgroundImageSet != isBackgroundImageSet) {
            this.myBackgroundImageSet = isBackgroundImageSet;
            EditorImpl.updateOpaque(this.myScrollPane.getHorizontalScrollBar());
            EditorImpl.updateOpaque(this.myScrollPane.getVerticalScrollBar());
        }
    }

    Color getDisposedBackground() {
        return new JBColor(new Color(128, 255, 128), new Color(128, 255, 128));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        return this.myIndentsModel;
    }

    public void setHeaderComponent(JComponent header2) {
        this.myHeaderPanel.removeAll();
        JComponent jComponent = header2 = header2 == null ? this.getPermanentHeaderComponent() : header2;
        if (header2 != null) {
            this.myHeaderPanel.add(header2);
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
        if (SystemInfo.isMac) {
            TouchBarsManager.onUpdateEditorHeader(this, header2);
        }
    }

    public boolean hasHeaderComponent() {
        JComponent header2 = this.getHeaderComponent();
        return header2 != null && header2 != this.getPermanentHeaderComponent();
    }

    @Override
    @Nullable
    public JComponent getPermanentHeaderComponent() {
        return (JComponent)this.getUserData(PERMANENT_HEADER);
    }

    @Override
    public void setPermanentHeaderComponent(@Nullable JComponent component2) {
        this.putUserData(PERMANENT_HEADER, component2);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.myHeaderPanel.getComponentCount() > 0) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myScrollPane.setBackground(color);
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myForcedBackground = null;
            return;
        }
        this.myForcedBackground = color;
    }

    @NotNull
    Color getForegroundColor() {
        return this.myScheme.getDefaultForeground();
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        if (this.myForcedBackground != null) {
            return this.myForcedBackground;
        }
        return this.getBackgroundIgnoreForced();
    }

    @Override
    @NotNull
    public TextDrawingCallback getTextDrawingCallback() {
        return this.myTextDrawingCallback;
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text) {
        this.myPlaceholderText = text;
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myPlaceholderAttributes = attributes;
    }

    @Nullable
    public TextAttributes getPlaceholderAttributes() {
        return this.myPlaceholderAttributes;
    }

    public CharSequence getPlaceholder() {
        return this.myPlaceholderText;
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show2) {
        this.myShowPlaceholderWhenFocused = show2;
    }

    public boolean getShowPlaceholderWhenFocused() {
        return this.myShowPlaceholderWhenFocused;
    }

    Color getBackgroundColor(@NotNull TextAttributes attributes) {
        Color attrColor = attributes.getBackgroundColor();
        return Comparing.equal((Object)attrColor, (Object)this.myScheme.getDefaultBackground()) ? this.getBackgroundColor() : attrColor;
    }

    @NotNull
    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            return color;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        return readOnlyColor != null ? readOnlyColor : color;
    }

    @Nullable
    public TextRange getComposedTextRange() {
        return this.myInputMethodRequestsHandler == null || this.myInputMethodRequestsHandler.composedText == null ? null : this.myInputMethodRequestsHandler.composedTextRange;
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myView.getMaxWidthInRange(startOffset, endOffset);
    }

    public boolean isPaintSelection() {
        return this.myPaintSelection || !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    public void setPaintSelection(boolean paintSelection) {
        this.myPaintSelection = paintSelection;
    }

    @NotNull
    @NonNls
    public String dumpState() {
        return "allow caret inside tab: " + this.mySettings.isCaretInsideTabs() + ", allow caret after line end: " + this.mySettings.isVirtualSpace() + ", soft wraps: " + (this.mySoftWrapModel.isSoftWrappingEnabled() ? "on" : "off") + ", caret model: " + this.getCaretModel().dumpState() + ", soft wraps data: " + this.getSoftWrapModel().dumpState() + "\n\nfolding data: " + this.getFoldingModel().dumpState() + "\ninlay model: " + this.getInlayModel().dumpState() + (this.myDocument instanceof DocumentImpl ? "\n\ndocument info: " + ((DocumentImpl)this.myDocument).dumpState() : "") + "\nfont preferences: " + this.myScheme.getFontPreferences() + "\npure painting mode: " + this.myPurePaintingMode + "\ninsets: " + this.myEditorComponent.getInsets() + (this.myView == null ? "" : "\nview: " + this.myView.dumpState());
    }

    public CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
        return this.myCaretCursor.getCaretLocations(onlyIfShown);
    }

    public int getAscent() {
        return this.myView.getAscent();
    }

    public int getLineHeight() {
        return this.myView.getLineHeight();
    }

    public int getDescent() {
        return this.myView.getDescent();
    }

    public int getCharHeight() {
        return this.myView.getCharHeight();
    }

    @NotNull
    public FontMetrics getFontMetrics(@JdkConstants.FontStyle int fontType) {
        EditorFontType ft;
        if (fontType == 0) {
            ft = EditorFontType.PLAIN;
        } else if (fontType == 1) {
            ft = EditorFontType.BOLD;
        } else if (fontType == 2) {
            ft = EditorFontType.ITALIC;
        } else if (fontType == 3) {
            ft = EditorFontType.BOLD_ITALIC;
        } else {
            LOG.error("Unknown font type: " + fontType);
            ft = EditorFontType.PLAIN;
        }
        return this.myEditorComponent.getFontMetrics(this.myScheme.getFont(ft));
    }

    public int getPreferredHeight() {
        return this.isReleased ? 0 : this.myView.getPreferredHeight();
    }

    public Dimension getPreferredSize() {
        return this.isReleased ? new Dimension() : (Registry.is((String)"idea.true.smooth.scrolling.dynamic.scrollbars") ? new Dimension(this.getPreferredWidthOfVisibleLines(), this.myView.getPreferredHeight()) : this.myView.getPreferredSize());
    }

    private int getPreferredWidthOfVisibleLines() {
        Rectangle area = this.getScrollingModel().getVisibleArea();
        VisualPosition begin = this.xyToVisualPosition(area.getLocation());
        VisualPosition end = this.xyToVisualPosition(new Point(area.x + area.width, area.y + area.height));
        return Math.max(this.myView.getPreferredWidth(begin.line, end.line), this.getScrollingWidth());
    }

    private int getScrollingWidth() {
        BoundedRangeModel model;
        JScrollBar scrollbar = this.myScrollPane.getHorizontalScrollBar();
        if (scrollbar != null && (model = scrollbar.getModel()) != null) {
            return model.getValue() + model.getExtent();
        }
        return 0;
    }

    @Override
    @NotNull
    public Dimension getContentSize() {
        return this.isReleased ? new Dimension() : this.myView.getPreferredSize();
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public void setBorder(Border border) {
        this.myScrollPane.setBorder(border);
    }

    public Insets getInsets() {
        return this.myScrollPane.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        return this.myView.logicalPositionToOffset(pos);
    }

    public int getVisibleLineCount() {
        return Math.max(1, this.getVisibleLogicalLinesCount() + this.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber());
    }

    private int getVisibleLogicalLinesCount() {
        return this.getDocument().getLineCount() - this.myFoldingModel.getTotalNumberOfFoldedLines();
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        return this.myView.logicalToVisualPosition(logicalPos, false);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        return this.myView.visualToLogicalPosition(visiblePos);
    }

    private int offsetToLogicalLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    private VisualPosition getTargetPosition(int x, int y, boolean trimToLineWidth) {
        if (this.myDocument.getLineCount() == 0) {
            return new VisualPosition(0, 0);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int visualLineCount = this.getVisibleLineCount();
        if (this.yToVisualLine(y) >= visualLineCount) {
            y = this.visualLineToY(Math.max(0, visualLineCount - 1));
        }
        VisualPosition visualPosition = this.xyToVisualPosition(new Point(x, y));
        if (trimToLineWidth && !this.mySettings.isVirtualSpace()) {
            LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
            LogicalPosition lineEndPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logicalPosition.line));
            if (logicalPosition.column > lineEndPosition.column) {
                visualPosition = this.logicalToVisualPosition(lineEndPosition.leanForward(true));
            } else if (this.mySoftWrapModel.isInsideSoftWrap(visualPosition)) {
                VisualPosition beforeSoftWrapPosition = this.myView.logicalToVisualPosition(logicalPosition, true);
                visualPosition = visualPosition.line == beforeSoftWrapPosition.line ? beforeSoftWrapPosition : this.myView.logicalToVisualPosition(logicalPosition, false);
            }
        }
        return visualPosition;
    }

    private boolean checkIgnore(@NotNull MouseEvent e) {
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (!(this.myInitialMouseEvent == null || e.getComponent() == this.myInitialMouseEvent.getComponent() && e.getPoint().equals(this.myInitialMouseEvent.getPoint()))) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        this.myIgnoreMouseEventsConsecutiveToInitial = false;
        this.myInitialMouseEvent = null;
        e.consume();
        return true;
    }

    private void processMouseReleased(@NotNull MouseEvent e) {
        if (this.checkIgnore(e)) {
            return;
        }
        if (!(e.getSource() != this.myGutterComponent || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed())) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        FoldRegion region = this.getFoldingModel().getFoldingPlaceholderAt(e.getPoint());
        if (region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(() -> region.setExpanded(true), true, false);
            this.validateMousePointer(e, null);
        }
        if (!(this.myMousePressedEvent == null || !this.myKeepSelectionOnMousePress || this.myLastPressWasAtBlockInlay || this.myDragStarted || this.myMousePressedEvent.getClickCount() != 1 || this.myMousePressedEvent.isShiftDown() || this.myMousePressedEvent.isPopupTrigger() || EditorImpl.isToggleCaretEvent(this.myMousePressedEvent) || EditorImpl.isCreateRectangularSelectionEvent(this.myMousePressedEvent))) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return this.getProjectAwareDataContext(DataManager.getInstance().getDataContext((Component)this.getContentComponent()));
    }

    @NotNull
    private DataContext getProjectAwareDataContext(@NotNull DataContext original) {
        if (CommonDataKeys.PROJECT.getData(original) == this.myProject) {
            return original;
        }
        return dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            return original.getData(dataId);
        };
    }

    private boolean isInsideGutterWhitespaceArea(@NotNull MouseEvent e) {
        EditorMouseEventArea area = this.getMouseEventArea(e);
        return area == EditorMouseEventArea.FOLDING_OUTLINE_AREA && this.myGutterComponent.convertX(e.getX()) > this.myGutterComponent.getWhitespaceSeparatorOffset();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (this.myGutterComponent != e.getSource()) {
            return EditorMouseEventArea.EDITING_AREA;
        }
        int x = this.myGutterComponent.convertX(e.getX());
        return this.myGutterComponent.getEditorMouseAreaByOffset(x);
    }

    private void requestFocus() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (focusManager.getFocusOwner() != this.myEditorComponent) {
            focusManager.requestFocus((Component)this.myEditorComponent, true);
        }
    }

    private void validateMousePointer(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        if (e.getSource() == this.myGutterComponent) {
            this.myGutterComponent.validateMousePointer(e);
        } else {
            this.myGutterComponent.setActiveFoldRegions(Collections.emptyList());
            this.myDefaultCursor = this.getDefaultCursor(e, editorMouseEvent);
            this.updateEditorCursor();
        }
    }

    private void updateEditorCursor() {
        Cursor cursor;
        Cursor customCursor = this.getCustomCursor();
        if (customCursor == null && this.myCursorSetExternally && this.myEditorComponent.isCursorSet() && (cursor = this.myEditorComponent.getCursor()) != Cursor.getPredefinedCursor(0) && cursor != Cursor.getPredefinedCursor(2) && cursor != EMPTY_CURSOR && (!SystemInfo.isMac || cursor != MacUIUtil.getInvertedTextCursor())) {
            return;
        }
        UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)(customCursor == null ? this.myDefaultCursor : customCursor));
        this.myCursorSetExternally = false;
    }

    private Cursor getDefaultCursor(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        Cursor result2 = null;
        if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
            int offset;
            int n = offset = editorMouseEvent == null ? this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint())) : editorMouseEvent.getOffset();
            if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                result2 = Cursor.getPredefinedCursor(0);
            }
        }
        if (result2 == null) {
            FoldRegion foldRegion;
            FoldRegion foldRegion2 = foldRegion = editorMouseEvent == null ? this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint()) : editorMouseEvent.getCollapsedFoldRegion();
            if (foldRegion != null) {
                result2 = Cursor.getPredefinedCursor(12);
            }
        }
        return result2 == null ? UIUtil.getTextCursor((Color)this.getBackgroundColor()) : result2;
    }

    private void runMouseDraggedCommand(@NotNull MouseEvent e) {
        if (this.myCommandProcessor == null || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        this.myCommandProcessor.executeCommand(this.myProject, () -> this.processMouseDragged(e), "", MOUSE_DRAGGED_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)this.getDocument());
    }

    private void processMouseDragged(@NotNull MouseEvent e) {
        boolean columnSelectionDrag;
        if (!SwingUtilities.isLeftMouseButton(e) && !SwingUtilities.isMiddleMouseButton(e) || Registry.is((String)"editor.disable.drag.with.right.button") && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        EditorMouseEventArea eventArea = this.getMouseEventArea(e);
        if (eventArea == EditorMouseEventArea.ANNOTATIONS_AREA) {
            return;
        }
        if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !this.isInsideGutterWhitespaceArea(e)) {
            if (this.myDragOnGutterSelectionStartLine >= 0) {
                this.mySelectionModel.removeSelection();
                this.myCaretModel.moveToOffset(this.myDragOnGutterSelectionStartLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(this.myDragOnGutterSelectionStartLine) : this.myDocument.getTextLength());
            }
            this.myDragOnGutterSelectionStartLine = -1;
        }
        boolean columnSelectionDragEvent = EditorImpl.isColumnSelectionDragEvent(e);
        boolean toggleCaretEvent = EditorImpl.isToggleCaretEvent(e);
        boolean addRectangularSelectionEvent = EditorImpl.isAddRectangularSelectionEvent(e);
        boolean bl = columnSelectionDrag = this.isColumnMode() && !this.myLastPressCreatedCaret || columnSelectionDragEvent;
        if (!columnSelectionDragEvent && toggleCaretEvent && !this.myLastPressCreatedCaret) {
            return;
        }
        if (this.myLastPressWasAtBlockInlay) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < visibleArea.x && visibleArea.x > 0) {
            dx = x - visibleArea.x;
        } else if (x > visibleArea.x + visibleArea.width) {
            dx = x - visibleArea.x - visibleArea.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < visibleArea.y && visibleArea.y > 0) {
            dy = y - visibleArea.y;
        } else if (y > visibleArea.y + visibleArea.height && visibleArea.y + visibleArea.height < this.myEditorComponent.getHeight()) {
            dy = y - visibleArea.y - visibleArea.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            SelectionModelImpl selectionModel = this.getSelectionModel();
            Caret leadCaret = this.getLeadCaret();
            int oldSelectionStart = leadCaret.getLeadSelectionOffset();
            VisualPosition oldVisLeadSelectionStart = leadCaret.getLeadSelectionPosition();
            int oldCaretOffset = this.getCaretModel().getOffset();
            boolean multiCaretSelection = columnSelectionDrag || toggleCaretEvent;
            VisualPosition newVisualCaret = this.getTargetPosition(x, y, !multiCaretSelection);
            LogicalPosition newLogicalCaret = this.visualToLogicalPosition(newVisualCaret);
            if (multiCaretSelection) {
                this.myMultiSelectionInProgress = true;
                this.myRectangularSelectionInProgress = columnSelectionDrag || addRectangularSelectionEvent;
                this.myTargetMultiSelectionPosition = this.xyToVisualPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
            } else {
                this.getCaretModel().moveToVisualPosition(newVisualCaret);
            }
            int newCaretOffset = this.getCaretModel().getOffset();
            newVisualCaret = this.getCaretModel().getVisualPosition();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
            } else if (multiCaretSelection) {
                if (this.myLastMousePressedLocation != null && (this.myCurrentDragIsSubstantial || !newLogicalCaret.equals((Object)this.myLastMousePressedLocation))) {
                    this.createSelectionTill(newLogicalCaret);
                    this.blockActionsIfNeeded(e, this.myLastMousePressedLocation, newLogicalCaret);
                }
            } else {
                if (this.getMouseSelectionState() != 0) {
                    this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                    this.cancelAutoResetForMouseSelectionState();
                    return;
                }
                if (!this.myKeepSelectionOnMousePress) {
                    if ((this.myMousePressArea == EditorMouseEventArea.LINE_NUMBERS_AREA || this.myMousePressArea == EditorMouseEventArea.LINE_MARKERS_AREA) && selectionModel.hasSelection()) {
                        if (newCaretOffset >= selectionModel.getSelectionEnd()) {
                            oldSelectionStart = selectionModel.getSelectionStart();
                            oldVisLeadSelectionStart = selectionModel.getSelectionStartPosition();
                        } else if (newCaretOffset <= selectionModel.getSelectionStart()) {
                            oldSelectionStart = selectionModel.getSelectionEnd();
                            oldVisLeadSelectionStart = selectionModel.getSelectionEndPosition();
                        }
                    }
                    if (oldVisLeadSelectionStart != null) {
                        this.setSelectionAndBlockActions(e, oldVisLeadSelectionStart, oldSelectionStart, newVisualCaret, newCaretOffset);
                    } else {
                        this.setSelectionAndBlockActions(e, oldSelectionStart, newCaretOffset);
                    }
                    this.cancelAutoResetForMouseSelectionState();
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        if (!this.myDragStarted) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                throw new UnsupportedOperationException("Drag'n'drop operation shouldn't be started in tests");
                            }
                            this.myDragStarted = true;
                            boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                            this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                            this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                        }
                    } else {
                        selectionModel.removeSelection();
                    }
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
            this.onSubstantialDrag(e);
        }
    }

    private void setupSpecialSelectionOnMouseDrag(int newCaretOffset, int caretShift) {
        int newSelectionStart;
        int newSelectionEnd = newCaretOffset;
        if (caretShift < 0) {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretStart(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionEnd);
        } else {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretEnd(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionStart);
        }
        if (newSelectionEnd < 0) {
            newSelectionEnd = newCaretOffset;
        }
        this.mySelectionModel.setSelection(newSelectionStart, newSelectionEnd);
        this.myCaretModel.moveToOffset(newSelectionEnd);
    }

    private int validateOffset(int offset) {
        if (offset < 0) {
            return 0;
        }
        if (offset > this.myDocument.getTextLength()) {
            return this.myDocument.getTextLength();
        }
        return offset;
    }

    private void clearDnDContext() {
        if (this.myDraggedRange != null) {
            this.myDraggedRange.dispose();
            this.myDraggedRange = null;
        }
        this.myGutterComponent.myDnDInProgress = false;
    }

    private void createSelectionTill(@NotNull LogicalPosition targetPosition) {
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>(this.myCaretStateBeforeLastPress);
        if (this.myRectangularSelectionInProgress) {
            caretStates.addAll(EditorModificationUtil.calcBlockSelectionState((Editor)this, (LogicalPosition)this.myLastMousePressedLocation, (LogicalPosition)targetPosition));
        } else {
            LogicalPosition selectionStart = this.myLastMousePressedLocation;
            LogicalPosition selectionEnd = targetPosition;
            if (this.getMouseSelectionState() != 0) {
                int newCaretOffset = this.logicalPositionToOffset(targetPosition);
                if (newCaretOffset < this.mySavedSelectionStart) {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(newCaretOffset), 0));
                    }
                } else {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionStart);
                    int selectionEndOffset = Math.max(newCaretOffset, this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 1) {
                        targetPosition = selectionEnd = this.offsetToLogicalPosition(selectionEndOffset);
                    } else if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(selectionEndOffset) + 1, 0));
                    }
                }
                this.cancelAutoResetForMouseSelectionState();
            }
            caretStates.add(new CaretState(targetPosition, selectionStart, selectionEnd));
        }
        this.myCaretModel.setCaretsAndSelections(caretStates);
    }

    private Caret getLeadCaret() {
        List<Caret> allCarets = this.myCaretModel.getAllCarets();
        Caret firstCaret = allCarets.get(0);
        if (firstCaret == this.myCaretModel.getPrimaryCaret()) {
            return allCarets.get(allCarets.size() - 1);
        }
        return firstCaret;
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, int startOffset, int endOffset) {
        this.mySelectionModel.setSelection(startOffset, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, VisualPosition startPosition, int startOffset, VisualPosition endPosition, int endOffset) {
        this.mySelectionModel.setSelection(startPosition, startOffset, endPosition, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset || !Comparing.equal((Object)startPosition, (Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void blockActionsIfNeeded(@NotNull MouseEvent mouseDragEvent, @NotNull LogicalPosition startPosition, @NotNull LogicalPosition endPosition) {
        if (this.myCurrentDragIsSubstantial || !startPosition.equals((Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void onSubstantialDrag(@NotNull MouseEvent mouseDragEvent) {
        IdeEventQueue.getInstance().blockNextEvents(mouseDragEvent, IdeEventQueue.BlockMode.ACTIONS);
        this.myCurrentDragIsSubstantial = true;
    }

    static Object calcFractionalMetricsHint() {
        return Registry.is((String)"editor.text.fractional.metrics") ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
    }

    void updateCaretCursor() {
        this.myUpdateCursor = true;
        if (this.myCaretCursor.myIsShown) {
            this.myCaretCursor.myStartTime = System.currentTimeMillis();
        } else {
            this.myCaretCursor.myIsShown = true;
            this.myCaretCursor.repaint();
        }
    }

    private void setCursorPosition() {
        ArrayList<CaretRectangle> caretPoints = new ArrayList<CaretRectangle>();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            boolean isRtl = caret.isAtRtlLocation();
            VisualPosition caretPosition = caret.getVisualPosition();
            Point2D pos1 = this.visualPositionToPoint2D(caretPosition.leanRight(!isRtl));
            Point2D pos2 = this.visualPositionToPoint2D(new VisualPosition(caretPosition.line, Math.max(0, caretPosition.column + (isRtl ? -1 : 1)), isRtl));
            float width = (float)Math.abs(pos2.getX() - pos1.getX());
            if (!isRtl && this.myInlayModel.hasInlineElementAt(caretPosition)) {
                width = Math.min(width, (float)Math.ceil(this.myView.getPlainSpaceWidth()));
            }
            caretPoints.add(new CaretRectangle(pos1, width, caret, isRtl));
        }
        this.myCaretCursor.setPositions(caretPoints.toArray(new CaretRectangle[0]));
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        boolean old = this.myCaretCursor.isActive();
        if (b) {
            this.myCaretCursor.activate();
        } else {
            this.myCaretCursor.passivate();
        }
        return old;
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        boolean old = this.myCaretCursor.isEnabled();
        this.myCaretCursor.setEnabled(enabled);
        return old;
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        this.myFocusListeners.add(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        ContainerUtil.add((Object)listener2, this.myFocusListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myIsOneLineMode;
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myEmbeddedIntoDialogWrapper;
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        EditorImpl.assertIsDispatchThread();
        this.myEmbeddedIntoDialogWrapper = b;
        this.myScrollPane.setFocusable(!b);
        this.myEditorComponent.setFocusCycleRoot(!b);
        this.myEditorComponent.setFocusable(b);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        JComponent component2;
        this.myIsOneLineMode = isOneLineMode;
        this.getScrollPane().setInputMap(1, null);
        JBScrollPane pane2 = (JBScrollPane)ObjectUtils.tryCast((Object)this.getScrollPane(), JBScrollPane.class);
        JComponent jComponent = component2 = pane2 == null ? null : pane2.getStatusComponent();
        if (component2 != null) {
            component2.setVisible(!this.isOneLineMode());
        }
        this.reinitSettings();
    }

    private static void updateOpaque(JScrollBar bar) {
        if (bar instanceof OpaqueAwareScrollBar) {
            bar.setOpaque(((OpaqueAwareScrollBar)((Object)bar)).myOpaque);
        }
    }

    private MyEditable getViewer() {
        if (this.myEditable == null) {
            this.myEditable = new MyEditable();
        }
        return this.myEditable;
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.getViewer();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.getViewer();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.getViewer();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.getViewer();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        EditorImpl.assertIsDispatchThread();
        this.myScheme = scheme;
        this.reinitSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        return this.myScheme;
    }

    static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        EditorImpl.assertIsDispatchThread();
        if (this.myScrollBarOrientation == type) {
            return;
        }
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollBarOrientation = type;
        this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, type == 0 ? JBScrollPane.Flip.HORIZONTAL : null);
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myScrollPane.setVerticalScrollBarPolicy(b ? 22 : 21);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myScrollPane.setHorizontalScrollBarPolicy(b ? 30 : 31);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myScrollBarOrientation;
    }

    public boolean isMirrored() {
        return this.myScrollBarOrientation != 1;
    }

    @NotNull
    MyScrollBar getVerticalScrollBar() {
        return this.myVerticalScrollBar;
    }

    @MouseSelectionState
    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    private void setMouseSelectionState(@MouseSelectionState int mouseSelectionState) {
        if (this.getMouseSelectionState() == mouseSelectionState) {
            return;
        }
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
        this.myMouseSelectionStateAlarm.cancelAllRequests();
        if (this.myMouseSelectionState != 0) {
            if (this.myMouseSelectionStateResetRunnable == null) {
                this.myMouseSelectionStateResetRunnable = () -> this.resetMouseSelectionState(null, null);
            }
            this.myMouseSelectionStateAlarm.addRequest(this.myMouseSelectionStateResetRunnable, Registry.intValue((String)"editor.mouseSelectionStateResetTimeout"), ModalityState.stateForComponent((Component)this.myEditorComponent));
        }
    }

    private void resetMouseSelectionState(@Nullable MouseEvent event, @Nullable EditorMouseEvent editorMouseEvent) {
        MouseEvent e;
        this.setMouseSelectionState(0);
        MouseEvent mouseEvent = e = event != null ? event : this.myMouseMovedEvent;
        if (e != null) {
            this.validateMousePointer(e, editorMouseEvent);
        }
    }

    private void cancelAutoResetForMouseSelectionState() {
        this.myMouseSelectionStateAlarm.cancelAllRequests();
    }

    void replaceInputMethodText(@NotNull InputMethodEvent e) {
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.replaceInputMethodText(e);
    }

    void inputMethodCaretPositionChanged(@NotNull InputMethodEvent e) {
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.setInputMethodCaretPosition(e);
    }

    @NotNull
    InputMethodRequests getInputMethodRequests() {
        if (this.myInputMethodRequestsHandler == null) {
            this.myInputMethodRequestsHandler = new MyInputMethodHandler();
            this.myInputMethodRequestsSwingWrapper = new MyInputMethodHandleSwingThreadWrapper(this.myInputMethodRequestsHandler);
        }
        return this.myInputMethodRequestsSwingWrapper;
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        this.myLastTypedActionTimestamp = -1L;
        if (e.getID() != 400) {
            return false;
        }
        char c = e.getKeyChar();
        if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            this.myLastTypedActionTimestamp = e.getWhen();
            this.myLastTypedAction = Character.toString(c);
            this.processKeyTyped(c);
            return true;
        }
        return false;
    }

    public void recordLatencyAwareAction(String actionId, long timestampMs) {
        this.myLastTypedActionTimestamp = timestampMs;
        this.myLastTypedAction = actionId;
    }

    void measureTypingLatency() {
        if (this.myLastTypedActionTimestamp == -1L) {
            return;
        }
        LatencyListener latencyPublisher = this.myLatencyPublisher;
        if (latencyPublisher == null) {
            this.myLatencyPublisher = latencyPublisher = (LatencyListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LatencyListener.TOPIC);
        }
        latencyPublisher.recordTypingLatency((Editor)this, this.myLastTypedAction, System.currentTimeMillis() - this.myLastTypedActionTimestamp);
        this.myLastTypedActionTimestamp = -1L;
    }

    public boolean isProcessingTypedAction() {
        return this.myLastTypedActionTimestamp != -1L;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
    }

    EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(@NotNull EditorDropHandler dropHandler) {
        this.myDropHandler = dropHandler;
    }

    public void setHighlightingFilter(@Nullable Condition<RangeHighlighter> filter2) {
        if (this.myHighlightingFilter == filter2) {
            return;
        }
        Condition<RangeHighlighter> oldFilter = this.myHighlightingFilter;
        this.myHighlightingFilter = filter2;
        for (RangeHighlighter highlighter : this.myDocumentMarkupModel.getDelegate().getAllHighlighters()) {
            boolean newAvailable;
            boolean oldAvailable = oldFilter == null || oldFilter.value((Object)highlighter);
            boolean bl = newAvailable = filter2 == null || filter2.value((Object)highlighter);
            if (oldAvailable == newAvailable) continue;
            boolean styleOrColorChanged = EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes(this.getColorsScheme()));
            this.myMarkupModelListener.attributesChanged((RangeHighlighterEx)highlighter, true, styleOrColorChanged);
            this.myMarkupModel.getErrorStripeMarkersModel().attributesChanged((RangeHighlighterEx)highlighter, true);
        }
    }

    boolean isHighlighterAvailable(@NotNull RangeHighlighter highlighter) {
        return this.myHighlightingFilter == null || this.myHighlightingFilter.value((Object)highlighter);
    }

    private boolean hasBlockInlay(@NotNull Point point) {
        Inlay inlay = this.myInlayModel.getElementAt(point);
        return inlay != null && (inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE);
    }

    private static boolean isColumnSelectionDragEvent(@NotNull MouseEvent e) {
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelectionOnMouseDrag");
    }

    private static boolean isToggleCaretEvent(@NotNull MouseEvent e) {
        return EditorImpl.isMouseActionEvent(e, "EditorAddOrRemoveCaret") || EditorImpl.isAddRectangularSelectionEvent(e);
    }

    private static boolean isAddRectangularSelectionEvent(@NotNull MouseEvent e) {
        return EditorImpl.isMouseActionEvent(e, "EditorAddRectangularSelectionOnMouseDrag");
    }

    private static boolean isCreateRectangularSelectionEvent(@NotNull MouseEvent e) {
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelection");
    }

    private static boolean isMouseActionEvent(@NotNull MouseEvent e, String actionId) {
        MouseShortcut mouseShortcut;
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return false;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        List mappedActions = keymap2.getActionIds(mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)e));
        if (!mappedActions.contains(actionId)) {
            return false;
        }
        if (mappedActions.size() < 2 || e.getID() == 506) {
            return true;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String mappedActionId : mappedActions) {
            AnActionEvent actionEvent;
            AnAction action2;
            if (actionId.equals(mappedActionId) || !ActionUtil.lastUpdateAndCheckDumb((AnAction)(action2 = actionManager.getAction(mappedActionId)), (AnActionEvent)(actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)e, (String)"MainMenu", (DataContext)DataManager.getInstance().getDataContext(e.getComponent()))), (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void selectWordAtCaret(boolean honorCamelCase) {
        this.mySelectionModel.selectWordAtCaret(honorCamelCase);
        this.setMouseSelectionState(1);
        this.mySavedSelectionStart = this.mySelectionModel.getSelectionStart();
        this.mySavedSelectionEnd = this.mySelectionModel.getSelectionEnd();
        this.getCaretModel().moveToOffset(this.mySavedSelectionEnd);
    }

    private boolean tweakSelectionEvent(@NotNull MouseEvent e) {
        return this.getSelectionModel().hasSelection() && e.getButton() == 1 && e.isShiftDown() && this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA;
    }

    private boolean tweakSelectionIfNecessary(@NotNull MouseEvent e) {
        if (!this.tweakSelectionEvent(e)) {
            return false;
        }
        int startSelectionOffset = this.getSelectionModel().getSelectionStart();
        int startVisLine = this.offsetToVisualLine(startSelectionOffset);
        int endSelectionOffset = this.getSelectionModel().getSelectionEnd();
        int endVisLine = this.offsetToVisualLine(endSelectionOffset - 1);
        int clickVisLine = this.yToVisualLine(e.getPoint().y);
        if (clickVisLine < startVisLine) {
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else if (clickVisLine > endVisLine) {
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(this.getSelectionModel().getSelectionStart(), endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset, true);
        } else if (startVisLine == endVisLine) {
            this.getSelectionModel().removeSelection();
        } else if (this.getSelectionModel().getLeadSelectionOffset() == endSelectionOffset) {
            if (clickVisLine == startVisLine) {
                ++clickVisLine;
            }
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else {
            if (clickVisLine == endVisLine) {
                --clickVisLine;
            }
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(startSelectionOffset, endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset);
        }
        e.consume();
        return true;
    }

    boolean useEditorAntialiasing() {
        return this.myUseEditorAntialiasing;
    }

    public void setUseEditorAntialiasing(boolean value2) {
        this.myUseEditorAntialiasing = value2;
    }

    private EditorMouseEvent createEditorMouseEvent(MouseEvent e) {
        Point point = e.getPoint();
        EditorMouseEventArea area = this.getMouseEventArea(e);
        boolean inEditingArea = area == EditorMouseEventArea.EDITING_AREA;
        EditorLocation location = new EditorLocation(this, inEditingArea ? point : new Point(0, point.y));
        VisualPosition visualPosition = location.getVisualPosition();
        LogicalPosition logicalPosition = location.getLogicalPosition();
        int offset = location.getOffset();
        Inlay inlayCandidate = inEditingArea ? this.myInlayModel.getElementAt(location, true) : null;
        Inlay inlay = inlayCandidate == null || (inlayCandidate.getPlacement() == Inlay.Placement.BELOW_LINE || inlayCandidate.getPlacement() == Inlay.Placement.ABOVE_LINE) && (double)inlayCandidate.getWidthInPixels() <= point.getX() ? null : inlayCandidate;
        FoldRegion collapseFoldRegion = inEditingArea ? this.myFoldingModel.getFoldingPlaceholderAt(location) : null;
        GutterIconRenderer gutterIconRenderer = inEditingArea ? null : this.myGutterComponent.getGutterRenderer(point);
        boolean overText = inlayCandidate == null && this.offsetToLogicalPosition(offset).equals((Object)logicalPosition);
        return new EditorMouseEvent((Editor)this, e, area, offset, logicalPosition, visualPosition, overText, collapseFoldRegion, inlay, gutterIconRenderer);
    }

    static boolean handleDrop(@NotNull EditorImpl editor, @NotNull Transferable t, int dropAction) {
        EditorDropHandler dropHandler = editor.getDropHandler();
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            try {
                GutterDraggableObject object;
                Object attachedObject;
                if (t.isDataFlavorSupported(GutterDraggableObject.flavor) && (attachedObject = t.getTransferData(GutterDraggableObject.flavor)) instanceof GutterIconRenderer && (object = ((GutterIconRenderer)attachedObject).getDraggableObject()) != null) {
                    object.remove();
                    Point mouseLocationOnScreen = MouseInfo.getPointerInfo().getLocation();
                    JComponent editorComponent = editor.getComponent();
                    Point editorComponentLocationOnScreen = editorComponent.getLocationOnScreen();
                    Disposable painterListenersDisposable = Disposer.newDisposable((String)"PainterListenersDisposable");
                    Disposer.register((Disposable)editor.getDisposable(), (Disposable)painterListenersDisposable);
                    GutterIconDropAnimator painter = new GutterIconDropAnimator(new Point(mouseLocationOnScreen.x - editorComponentLocationOnScreen.x, mouseLocationOnScreen.y - editorComponentLocationOnScreen.y), editor.getGutterComponentEx().getDragImage((GutterMark)((GutterIconRenderer)attachedObject)), painterListenersDisposable);
                    IdeGlassPaneUtil.installPainter((JComponent)editorComponent, (Painter)painter, (Disposable)painterListenersDisposable);
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
            dropHandler.handleDrop(t, editor.getProject(), null, dropAction);
            return true;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (editor.myDraggedRange != null && editor.myDraggedRange.getStartOffset() <= caretOffset && caretOffset < editor.myDraggedRange.getEndOffset()) {
            return false;
        }
        if (editor.myDraggedRange != null) {
            editor.getCaretModel().moveToOffset(editor.mySavedCaretOffsetForDNDUndoHack);
        }
        CommandProcessor.getInstance().executeCommand(editor.myProject, () -> {
            try {
                int offset;
                editor.getSelectionModel().removeSelection();
                if (editor.myDraggedRange != null) {
                    editor.getCaretModel().moveToOffset(caretOffset);
                    offset = caretOffset;
                } else {
                    offset = editor.getCaretModel().getOffset();
                }
                if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                    return;
                }
                editor.putUserData(LAST_PASTED_REGION, null);
                AnAction pasteAction = ActionManager.getInstance().getAction("EditorPaste");
                if (pasteAction instanceof EditorAction) {
                    EditorTextInsertHandler handler2 = (EditorTextInsertHandler)((EditorAction)pasteAction).getHandlerOfType(EditorTextInsertHandler.class);
                    if (handler2 == null) {
                        LOG.error("No suitable paste handler found");
                    } else {
                        handler2.execute((Editor)editor, editor.getDataContext(), () -> t);
                    }
                } else {
                    LOG.error("Couldn't find paste action: " + pasteAction);
                }
                TextRange range2 = (TextRange)editor.getUserData(LAST_PASTED_REGION);
                if (range2 != null) {
                    editor.getCaretModel().moveToOffset(range2.getStartOffset());
                    editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
        return true;
    }

    @NotNull
    public EditorGutter getGutter() {
        return this.getGutterComponentEx();
    }

    public boolean isInDistractionFreeMode() {
        return EditorUtil.isRealFileEditor(this) && (Registry.is((String)"editor.distraction.free.mode") || this.isInPresentationMode());
    }

    boolean isInPresentationMode() {
        return UISettings.getInstance().getPresentationMode() && EditorUtil.isRealFileEditor(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    private void invokePopupIfNeeded(EditorMouseEvent event) {
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().isPopupTrigger() && !event.isConsumed()) {
            for (int i2 = this.myPopupHandlers.size() - 1; i2 >= 0 && !this.myPopupHandlers.get(i2).handlePopup(event); --i2) {
            }
        }
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (this.myProject != null) {
            PsiFile editorFile;
            if (event.getPsiFile() != null && (editorFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile((Document)this.getDocument())) != event.getPsiFile()) {
                return;
            }
            int oldTabSize = EditorUtil.getTabSize(this);
            this.mySettings.reinitSettings();
            int newTabSize = EditorUtil.getTabSize(this);
            if (oldTabSize != newTabSize) {
                this.reinitSettings(false);
            } else {
                this.myEditorComponent.repaint();
            }
        }
    }

    public void bidiTextFound() {
        if (this.myProject != null && this.myVirtualFile != null && this.replace(CONTAINS_BIDI_TEXT, null, Boolean.TRUE)) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
    }

    void validateState() {
        this.myView.validateState();
        this.mySoftWrapModel.validateState();
        this.myFoldingModel.validateState();
        this.myCaretModel.validateState();
        this.myInlayModel.validateState();
    }

    static {
        Cursor emptyCursor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtil.createImage((int)1, (int)1, (int)2), new Point(), "Empty cursor");
            }
            catch (Exception e) {
                LOG.warn("Couldn't create an empty cursor", (Throwable)e);
            }
        }
        EMPTY_CURSOR = emptyCursor;
        ourCaretBlinkingCommand = new RepaintCursorCommand();
        ourCaretBlinkingCommand.start();
        decrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"decrButton");
        incrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"incrButton");
    }

    private static class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        @Override
        public void setAttributes(TextAttributes attributes) {
        }

        @Override
        public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        }
    }

    private class MyTextDrawingCallback
    implements TextDrawingCallback {
        private MyTextDrawingCallback() {
        }

        @Override
        public void drawChars(@NotNull Graphics g, char @NotNull [] data2, int start2, int end, int x, int y, Color color, @NotNull FontInfo fontInfo) {
            EditorImpl.this.myView.drawChars(g, data2, start2, end, x, y, color, fontInfo);
        }
    }

    private class MyHeaderPanel
    extends JPanel {
        private int myOldHeight;

        private MyHeaderPanel() {
            super(new BorderLayout());
        }

        @Override
        public void revalidate() {
            this.myOldHeight = this.getHeight();
            super.revalidate();
        }

        @Override
        protected void validateTree() {
            int height = this.myOldHeight;
            super.validateTree();
            if ((height -= this.getHeight()) != 0 && (this.myOldHeight != 0 || this.getComponentCount() <= 0 || EditorImpl.this.getPermanentHeaderComponent() != this.getComponent(0))) {
                EditorImpl.this.myVerticalScrollBar.setValue(EditorImpl.this.myVerticalScrollBar.getValue() - height);
            }
            this.myOldHeight = this.getHeight();
        }
    }

    private class TablessBorder
    extends SideBorder {
        private TablessBorder() {
            super(JBColor.border(), 15);
        }

        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c instanceof JComponent) {
                Insets insets = ((JComponent)c).getInsets();
                if (insets.left > 0) {
                    super.paintBorder(c, g, x, y, width, height);
                } else {
                    g.setColor(UIUtil.getPanelBackground());
                    g.fillRect(x, y, width, 1);
                    g.setColor(Gray._50.withAlpha(90));
                    g.fillRect(x, y, width, 1);
                }
            }
        }

        @NotNull
        public Insets getBorderInsets(Component c) {
            boolean paintTop;
            Container splitters = SwingUtilities.getAncestorOfClass(EditorsSplitters.class, c);
            boolean thereIsSomethingAbove = !SystemInfo.isMac || UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() || this.toolWindowIsNotEmpty();
            Component header2 = EditorImpl.this.myHeaderPanel == null ? null : (Component)ArrayUtil.getFirstElement((Object[])EditorImpl.this.myHeaderPanel.getComponents());
            boolean bl = paintTop = thereIsSomethingAbove && header2 == null && UISettings.getInstance().getEditorTabPlacement() != 1;
            return splitters == null ? super.getBorderInsets(c) : JBUI.insetsTop((int)(paintTop ? 1 : 0));
        }

        private boolean toolWindowIsNotEmpty() {
            if (EditorImpl.this.myProject == null) {
                return false;
            }
            return !ToolWindowManagerEx.getInstanceEx(EditorImpl.this.myProject).getIdsOn(ToolWindowAnchor.TOP).isEmpty();
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    @DirtyUI
    private class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        public void setUI(ScrollPaneUI ui) {
            super.setUI(ui);
            this.setInputMap(1, null);
        }

        public void layout() {
            if (EditorImpl.this.isInDistractionFreeMode()) {
                EditorImpl.this.myGutterComponent.updateSize(true, true);
            }
            super.layout();
        }

        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize(e)) {
                int size = EditorImpl.this.myScheme.getEditorFontSize() - e.getWheelRotation();
                if (size >= 8) {
                    EditorImpl.this.setFontSize(size, SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()));
                }
                return;
            }
            super.processMouseWheelEvent(e);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new OpaqueAwareScrollBar(0);
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        protected void setupCorners() {
            super.setupCorners();
            this.setBorder((Border)((Object)new TablessBorder()));
        }
    }

    private class DefaultPopupHandler
    extends ContextMenuPopupHandler {
        private DefaultPopupHandler() {
        }

        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            String contextMenuGroupId = EditorImpl.this.myContextMenuGroupId;
            Inlay inlay = EditorImpl.this.myInlayModel.getElementAt(event.getMouseEvent().getPoint());
            if (inlay != null) {
                ActionGroup group = inlay.getRenderer().getContextMenuGroup(inlay);
                if (group != null) {
                    return group;
                }
                String inlayContextMenuGroupId = inlay.getRenderer().getContextMenuGroupId(inlay);
                if (inlayContextMenuGroupId != null) {
                    contextMenuGroupId = inlayContextMenuGroupId;
                }
            }
            return ContextMenuPopupHandler.getGroupForId(contextMenuGroupId);
        }
    }

    private class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        private EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            EditorImpl.this.beforeChangedUpdate(e);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            EditorImpl.this.changedUpdate(e);
        }

        public void bulkUpdateStarting(@NotNull Document document) {
            EditorImpl.this.bulkUpdateStarted();
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            EditorImpl.this.bulkUpdateFinished();
        }

        @Override
        public int getPriority() {
            return 160;
        }
    }

    private static class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        private static EditorImpl getEditor(@NotNull JComponent comp) {
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            return editorComponent.getEditor();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Component comp = support.getComponent();
            return comp instanceof JComponent && EditorImpl.handleDrop(MyTransferHandler.getEditor((JComponent)comp), support.getTransferable(), support.getDropAction());
        }

        @Override
        public boolean canImport(@NotNull JComponent comp, DataFlavor @NotNull [] transferFlavors) {
            EditorImpl editor = MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = editor.getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(transferFlavors)) {
                return true;
            }
            if (Registry.is((String)"debugger.click.disable.breakpoints") && ArrayUtil.contains((Object)GutterDraggableObject.flavor, (Object[])transferFlavors)) {
                return true;
            }
            if (editor.isViewer()) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                return false;
            }
            return ArrayUtil.contains((Object)DataFlavor.stringFlavor, (Object[])transferFlavors);
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            EditorImpl editor = MyTransferHandler.getEditor(c);
            String s = editor.getSelectionModel().getSelectedText();
            if (s == null) {
                return null;
            }
            int selectionStart = editor.getSelectionModel().getSelectionStart();
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            editor.myDraggedRange = editor.getDocument().createRangeMarker(selectionStart, selectionEnd);
            Transferable transferable = CopyAction.getSelection(editor);
            return transferable == null ? new StringSelection(s) : transferable;
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data2, int action2) {
            if (data2 == null) {
                return;
            }
            Component last = DnDManager.getInstance().getLastDropHandler();
            if (last != null && !(last instanceof EditorComponentImpl) && !(last instanceof EditorGutterComponentImpl)) {
                return;
            }
            EditorImpl editor = MyTransferHandler.getEditor(source);
            if (action2 == 2 && !editor.isViewer() && editor.myDraggedRange != null) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MyTransferHandler.removeDraggedOutFragment(editor));
            }
            editor.clearDnDContext();
        }

        private static void removeDraggedOutFragment(EditorImpl editor) {
            if (!FileDocumentManager.getInstance().requestWriting((Document)editor.getDocument(), editor.getProject())) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(editor.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                DocumentEx doc = editor.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    doc.deleteString(editor.myDraggedRange.getStartOffset(), editor.myDraggedRange.getEndOffset());
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler((Document)doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }), EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
        }
    }

    private class MyColorSchemeDelegate
    extends DelegateColorScheme {
        private final FontPreferencesImpl myFontPreferences;
        private final FontPreferencesImpl myConsoleFontPreferences;
        private final Map<TextAttributesKey, TextAttributes> myOwnAttributes;
        private final Map<ColorKey, Color> myOwnColors;
        private final EditorColorsScheme myCustomGlobalScheme;
        private Map<EditorFontType, Font> myFontsMap;
        private int myMaxFontSize;
        private int myFontSize;
        private int myConsoleFontSize;
        private String myFaceName;
        private Float myLineSpacing;
        private boolean myFontPreferencesAreSetExplicitly;

        private MyColorSchemeDelegate(EditorColorsScheme globalScheme) {
            super(globalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : globalScheme);
            this.myFontPreferences = new FontPreferencesImpl();
            this.myConsoleFontPreferences = new FontPreferencesImpl();
            this.myOwnAttributes = new HashMap<TextAttributesKey, TextAttributes>();
            this.myOwnColors = new HashMap<ColorKey, Color>();
            this.myMaxFontSize = EditorFontsConstants.getMaxEditorFontSize();
            this.myFontSize = -1;
            this.myConsoleFontSize = -1;
            this.myCustomGlobalScheme = globalScheme;
            this.updateGlobalScheme();
        }

        private void reinitFonts() {
            EditorColorsScheme delegate = this.getDelegate();
            String editorFontName = this.getEditorFontName();
            int editorFontSize = this.getEditorFontSize();
            if (!this.myFontPreferencesAreSetExplicitly) {
                this.updatePreferences(this.myFontPreferences, editorFontName, editorFontSize, delegate == null ? null : delegate.getFontPreferences());
            }
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.updatePreferences(this.myConsoleFontPreferences, consoleFontName, consoleFontSize, delegate == null ? null : delegate.getConsoleFontPreferences());
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            this.myFontsMap.put(EditorFontType.PLAIN, new Font(editorFontName, 0, editorFontSize));
            this.myFontsMap.put(EditorFontType.BOLD, new Font(editorFontName, 1, editorFontSize));
            this.myFontsMap.put(EditorFontType.ITALIC, new Font(editorFontName, 2, editorFontSize));
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, new Font(editorFontName, 3, editorFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_PLAIN, new Font(consoleFontName, 0, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_BOLD, new Font(consoleFontName, 1, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_ITALIC, new Font(consoleFontName, 2, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_BOLD_ITALIC, new Font(consoleFontName, 3, consoleFontSize));
        }

        private void updatePreferences(@NotNull FontPreferencesImpl preferences, @NotNull String fontName, int fontSize, @Nullable FontPreferences delegatePreferences) {
            preferences.clear();
            preferences.register(fontName, fontSize);
            if (delegatePreferences != null) {
                boolean first = true;
                for (String font : delegatePreferences.getRealFontFamilies()) {
                    if (!first) {
                        preferences.register(font, fontSize);
                    }
                    first = false;
                }
            }
            preferences.setUseLigatures(delegatePreferences != null && delegatePreferences.useLigatures());
        }

        private void reinitFontsAndSettings() {
            this.reinitFonts();
            EditorImpl.this.reinitSettings();
        }

        @Override
        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getDelegate().getAttributes(key);
        }

        @Override
        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
            this.myOwnAttributes.put(key, attributes);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getDelegate().getColor(key);
        }

        @Override
        public void setColor(ColorKey key, Color color) {
            if (color == AbstractColorsScheme.INHERITED_COLOR_MARKER) {
                this.myOwnColors.remove(key);
            } else {
                this.myOwnColors.put(key, color);
            }
            EditorImpl.this.myCaretModel.reinitSettings();
            EditorImpl.this.mySelectionModel.reinitSettings();
        }

        @Override
        public int getEditorFontSize() {
            if (this.myFontPreferencesAreSetExplicitly) {
                return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
            }
            if (this.myFontSize == -1) {
                return this.getDelegate().getEditorFontSize();
            }
            return this.myFontSize;
        }

        @Override
        public void setEditorFontSize(int fontSize) {
            if (fontSize < 8) {
                fontSize = 8;
            }
            if (fontSize > this.myMaxFontSize) {
                fontSize = this.myMaxFontSize;
            }
            if (fontSize == this.myFontSize) {
                return;
            }
            this.myFontPreferencesAreSetExplicitly = false;
            this.myFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getFontPreferences() {
            return !this.myFontPreferencesAreSetExplicitly && this.myFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getFontPreferences() : this.myFontPreferences;
        }

        @Override
        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (this.myFontPreferencesAreSetExplicitly && Comparing.equal((Object)preferences, (Object)((Object)this.myFontPreferences))) {
                return;
            }
            this.myFontPreferencesAreSetExplicitly = true;
            this.myFaceName = null;
            this.myFontSize = -1;
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            return this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getConsoleFontPreferences() : this.myConsoleFontPreferences;
        }

        @Override
        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (Comparing.equal((Object)preferences, (Object)((Object)this.myConsoleFontPreferences))) {
                return;
            }
            preferences.copyTo((FontPreferences)this.myConsoleFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        public String getEditorFontName() {
            if (this.myFontPreferencesAreSetExplicitly) {
                return this.myFontPreferences.getFontFamily();
            }
            if (this.myFaceName == null) {
                return this.getDelegate().getEditorFontName();
            }
            return this.myFaceName;
        }

        @Override
        public void setEditorFontName(String fontName) {
            if (Objects.equals(fontName, this.myFaceName)) {
                return;
            }
            this.myFontPreferencesAreSetExplicitly = false;
            this.myFaceName = fontName;
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                return font;
            }
            return this.getDelegate().getFont(key);
        }

        @Override
        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.reinitFontsAndSettings();
            }
            this.myFontsMap.put(key, font);
            EditorImpl.this.reinitSettings();
        }

        @Override
        @Nullable
        public Object clone() {
            return null;
        }

        private void updateGlobalScheme() {
            this.setDelegate(this.myCustomGlobalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myCustomGlobalScheme);
        }

        @Override
        public void setDelegate(@NotNull EditorColorsScheme delegate) {
            super.setDelegate(delegate);
            int globalFontSize = this.getDelegate().getEditorFontSize();
            this.myMaxFontSize = Math.max(EditorFontsConstants.getMaxEditorFontSize(), globalFontSize);
            this.reinitFonts();
        }

        @Override
        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        public int getConsoleFontSize() {
            return this.myConsoleFontSize == -1 ? super.getConsoleFontSize() : this.myConsoleFontSize;
        }

        @Override
        public float getLineSpacing() {
            return this.myLineSpacing == null ? super.getLineSpacing() : this.myLineSpacing.floatValue();
        }

        @Override
        public void setLineSpacing(float lineSpacing) {
            float oldLineSpacing = this.getLineSpacing();
            float newLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
            this.myLineSpacing = Float.valueOf(newLineSpacing);
            if (oldLineSpacing != newLineSpacing) {
                EditorImpl.this.reinitSettings();
            }
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        @DirtyUI
        public void mouseDragged(@NotNull MouseEvent e) {
            if (EditorImpl.this.myDraggedRange != null || ((EditorImpl)EditorImpl.this).myGutterComponent.myDnDInProgress) {
                return;
            }
            EditorImpl.this.validateMousePointer(e, null);
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> EditorImpl.this.runMouseDraggedCommand(e));
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseDragged(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
        }

        @Override
        @DirtyUI
        public void mouseMoved(@NotNull MouseEvent e) {
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            if (EditorImpl.this.getMouseSelectionState() != 0) {
                if (EditorImpl.this.myMousePressedEvent != null && EditorImpl.this.myMousePressedEvent.getComponent() == e.getComponent()) {
                    Point lastPoint = EditorImpl.this.myMousePressedEvent.getPoint();
                    Point point = e.getPoint();
                    int deadZone = Registry.intValue((String)"editor.mouseSelectionStateResetDeadZone");
                    if (Math.abs(lastPoint.x - point.x) >= deadZone || Math.abs(lastPoint.y - point.y) >= deadZone) {
                        EditorImpl.this.resetMouseSelectionState(e, event);
                    }
                } else {
                    EditorImpl.this.validateMousePointer(e, event);
                }
            } else {
                EditorImpl.this.validateMousePointer(e, event);
            }
            EditorImpl.this.myMouseMovedEvent = e;
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseMoved(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            EditorImpl.this.requestFocus();
            this.runMousePressedCommand(e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            EditorImpl.this.myMousePressArea = null;
            EditorImpl.this.myLastMousePressedLocation = null;
            this.runMouseReleasedCommand(e);
            if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                this.runMouseClickedCommand(e);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            this.runMouseExitedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseExited(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMousePressedCommand(@NotNull MouseEvent e) {
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            EditorImpl.this.myLastPressWasAtBlockInlay = false;
            EditorImpl.this.myLastMousePressedLocation = event.getLogicalPosition();
            EditorImpl.this.myCaretStateBeforeLastPress = EditorImpl.isToggleCaretEvent(e) ? EditorImpl.this.myCaretModel.getCaretsAndSelections() : Collections.emptyList();
            EditorImpl.this.myCurrentDragIsSubstantial = false;
            EditorImpl.this.myDragStarted = false;
            EditorImpl.this.clearDnDContext();
            boolean forceProcessing = false;
            EditorImpl.this.myMousePressedEvent = e;
            EditorImpl.this.myExpectedCaretOffset = event.getOffset();
            try {
                for (EditorMouseListener mouseListener : EditorImpl.this.myMouseListeners) {
                    boolean wasConsumed = event.isConsumed();
                    mouseListener.mousePressed(event);
                    if (!wasConsumed && event.isConsumed() && mouseListener instanceof EditorPopupHandler) {
                        forceProcessing = true;
                    }
                    if (!EditorImpl.this.isReleased) continue;
                    return;
                }
            }
            finally {
                EditorImpl.this.myExpectedCaretOffset = -1;
            }
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA || event.getArea() == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !EditorImpl.this.isInsideGutterWhitespaceArea(e)) {
                EditorImpl.this.myDragOnGutterSelectionStartLine = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, e);
            }
            if (event.isConsumed() && !forceProcessing) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> {
                    if (this.processMousePressed(e) && EditorImpl.this.myProject != null && !EditorImpl.this.myProject.isDefault()) {
                        IdeDocumentHistory.getInstance(EditorImpl.this.myProject).includeCurrentCommandAsNavigation();
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
            EditorImpl.this.invokePopupIfNeeded(event);
        }

        private void runMouseClickedCommand(@NotNull MouseEvent e) {
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseClicked(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
        }

        private void runMouseReleasedCommand(@NotNull MouseEvent e) {
            EditorImpl.this.myMultiSelectionInProgress = false;
            EditorImpl.this.myDragOnGutterSelectionStartLine = -1;
            EditorImpl.this.myScrollingTimer.stop();
            if (e.isConsumed()) {
                return;
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseReleased(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
            EditorImpl.this.invokePopupIfNeeded(event);
            if (event.isConsumed()) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> EditorImpl.this.processMouseReleased(e);
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(@NotNull MouseEvent e) {
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseEntered(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(@NotNull MouseEvent e) {
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseExited(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private boolean processMousePressed(@NotNull MouseEvent e) {
            boolean isNavigation;
            boolean moveCaret;
            FoldRegion range2;
            EditorImpl.this.myInitialMouseEvent = e;
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > (long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout")) {
                EditorImpl.this.resetMouseSelectionState(e, null);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            EditorMouseEventArea eventArea = EditorImpl.this.getMouseEventArea(e);
            EditorImpl.this.myMousePressArea = eventArea;
            if (eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && (range2 = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                boolean expansion = !range2.isExpanded();
                int scrollShift = expansion ? 0 : EditorImpl.this.visualLineToY(EditorImpl.this.yToVisualLine(y)) - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(() -> {
                    range2.setExpanded(expansion);
                    if (e.isAltDown()) {
                        for (FoldRegion region : EditorImpl.this.myFoldingModel.getAllFoldRegions()) {
                            if (region.getStartOffset() < range2.getStartOffset() || region.getEndOffset() > range2.getEndOffset()) continue;
                            region.setExpanded(expansion);
                        }
                    }
                }, true, false);
                if (!expansion) {
                    int newY = EditorImpl.this.visualLineToY(EditorImpl.this.offsetToVisualLine(range2.getStartOffset()));
                    EditorUtil.runWithAnimationDisabled(EditorImpl.this, () -> EditorImpl.this.myScrollingModel.scrollVertically(newY - scrollShift));
                }
                EditorImpl.this.myGutterComponent.updateSize();
                EditorImpl.this.validateMousePointer(e, null);
                e.consume();
                return false;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (!EditorImpl.this.tweakSelectionIfNecessary(e)) {
                    EditorImpl.this.myGutterComponent.mousePressed(e);
                }
                if (e.isConsumed()) {
                    return false;
                }
                x = 0;
            }
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            int oldStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int oldEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            boolean toggleCaret = e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isToggleCaretEvent(e);
            boolean lastPressCreatedCaret = EditorImpl.this.myLastPressCreatedCaret;
            if (e.getClickCount() == 1) {
                EditorImpl.this.myLastPressCreatedCaret = false;
            }
            EditorImpl.this.myLastPressWasAtBlockInlay = eventArea == EditorMouseEventArea.EDITING_AREA && EditorImpl.this.hasBlockInlay(e.getPoint());
            boolean bl = moveCaret = eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA || EditorImpl.this.isInsideGutterWhitespaceArea(e) || eventArea == EditorMouseEventArea.EDITING_AREA && !EditorImpl.this.myLastPressWasAtBlockInlay;
            if (moveCaret) {
                VisualPosition visualPosition = EditorImpl.this.getTargetPosition(x, y, true);
                LogicalPosition pos = EditorImpl.this.visualToLogicalPosition(visualPosition);
                if (toggleCaret) {
                    Caret caret = EditorImpl.this.getCaretModel().getCaretAt(visualPosition);
                    if (e.getClickCount() == 1) {
                        if (caret == null) {
                            EditorImpl.this.myLastPressCreatedCaret = EditorImpl.this.getCaretModel().addCaret(visualPosition) != null;
                        } else {
                            EditorImpl.this.getCaretModel().removeCaret(caret);
                        }
                    } else if (e.getClickCount() == 3 && lastPressCreatedCaret) {
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    }
                } else if (e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isCreateRectangularSelectionEvent(e)) {
                    LogicalPosition anchor2;
                    CaretState anchorCaretState = EditorImpl.this.myCaretModel.getCaretsAndSelections().get(0);
                    LogicalPosition logicalPosition = anchor2 = Objects.equals(anchorCaretState.getCaretPosition(), anchorCaretState.getSelectionStart()) ? anchorCaretState.getSelectionEnd() : anchorCaretState.getSelectionStart();
                    if (anchor2 == null) {
                        anchor2 = EditorImpl.this.myCaretModel.getLogicalPosition();
                    }
                    EditorImpl.this.mySelectionModel.setBlockSelection(anchor2, pos);
                } else {
                    EditorImpl.this.getCaretModel().removeSecondaryCarets();
                    EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                }
            }
            if (e.isPopupTrigger()) {
                return false;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            int newStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int newEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            Point p = new Point(x, y);
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(p);
            EditorImpl.this.myKeepSelectionOnMousePress = EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd() && !this.isPointAfterSelectionEnd(p) && (SwingUtilities.isLeftMouseButton(e) && EditorImpl.this.mySettings.isDndEnabled() || SwingUtilities.isRightMouseButton(e));
            boolean bl2 = isNavigation = oldStart == oldEnd && newStart == newEnd && oldStart != newStart;
            if (EditorImpl.this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                EditorImpl.this.mySelectionModel.selectLineAtCaret();
                EditorImpl.this.setMouseSelectionState(2);
                EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                return isNavigation;
            }
            if (moveCaret) {
                if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown()) {
                    if (EditorImpl.this.getMouseSelectionState() != 0) {
                        if (caretOffset < EditorImpl.this.mySavedSelectionStart) {
                            EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionEnd, caretOffset);
                        } else {
                            EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionStart, caretOffset);
                        }
                    } else {
                        int startToUse = oldSelectionStart;
                        if (EditorImpl.this.mySelectionModel.isUnknownDirection() && caretOffset > startToUse) {
                            startToUse = Math.min(oldStart, oldEnd);
                        }
                        EditorImpl.this.mySelectionModel.setSelection(startToUse, caretOffset);
                    }
                } else if (!EditorImpl.this.myKeepSelectionOnMousePress && EditorImpl.this.getSelectionModel().hasSelection() && !EditorImpl.isCreateRectangularSelectionEvent(e) && e.getClickCount() == 1) {
                    if (!toggleCaret) {
                        EditorImpl.this.setMouseSelectionState(0);
                        EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
                    }
                } else if (!(e.getButton() != 1 || eventArea != EditorMouseEventArea.EDITING_AREA && eventArea != EditorMouseEventArea.LINE_NUMBERS_AREA || toggleCaret && !lastPressCreatedCaret)) {
                    switch (e.getClickCount()) {
                        case 2: {
                            EditorImpl.this.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords() && EditorImpl.this.mySettings.isCamelWords());
                            break;
                        }
                        case 3: {
                            if (HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK && EditorImpl.this.mySettings.isCamelWords()) {
                                EditorImpl.this.selectWordAtCaret(false);
                                break;
                            }
                        }
                        case 4: {
                            EditorImpl.this.mySelectionModel.selectLineAtCaret();
                            EditorImpl.this.setMouseSelectionState(2);
                            EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                            EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                            EditorImpl.this.mySelectionModel.setUnknownDirection(true);
                        }
                    }
                }
            }
            return isNavigation;
        }

        private boolean isPointAfterSelectionEnd(Point p) {
            VisualPosition selectionEndPosition = EditorImpl.this.mySelectionModel.getSelectionEndPosition();
            Point selectionEnd = EditorImpl.this.visualPositionToXY(selectionEndPosition);
            return p.y >= selectionEnd.y + EditorImpl.this.getLineHeight() || p.y >= selectionEnd.y && p.x > selectionEnd.x && EditorImpl.this.xyToVisualPosition((Point)p).column > selectionEndPosition.column;
        }
    }

    private class MyInputMethodHandler
    implements InputMethodRequests {
        private String composedText;
        private ProperTextRange composedTextRange;

        private MyInputMethodHandler() {
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            if (EditorImpl.this.isDisposed()) {
                return new Rectangle();
            }
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = this.getLocationOnScreen(EditorImpl.this.getContentComponent());
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedText != null) {
                Point p = this.getLocationOnScreen(EditorImpl.this.getContentComponent());
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (this.composedTextRange.containsOffset(pos)) {
                    return TextHitInfo.leading(pos - this.composedTextRange.getStartOffset());
                }
            }
            return null;
        }

        private Point getLocationOnScreen(Component component2) {
            Point location = new Point();
            SwingUtilities.convertPointToScreen(location, component2);
            if (LOG.isDebugEnabled() && !component2.isShowing()) {
                Container parent;
                Class<?> type = component2.getClass();
                for (parent = component2.getParent(); parent != null && !parent.isShowing(); parent = parent.getParent()) {
                    type = parent.getClass();
                }
                String message = type.getName() + " is not showing";
                if (parent != null) {
                    message = message + " on visible  " + parent.getClass().getName();
                }
                LOG.debug(message);
            }
            return location;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        private String getText(int startIdx, int endIdx) {
            if (startIdx >= 0 && endIdx > startIdx) {
                CharSequence chars = EditorImpl.this.getDocument().getImmutableCharSequence();
                return chars.subSequence(startIdx, endIdx).toString();
            }
            return "";
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex - beginIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, firstPartLength) + this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + composedEndIndex - composedStartIndex, endIndex - beginIndex);
            }
            return new AttributedString(committed).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedText != null) {
                length -= this.composedText.length();
            }
            return length;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text;
            if (EditorImpl.this.myCharKeyPressed) {
                EditorImpl.this.myNeedToSelectPreviousChar = true;
            }
            return (text = EditorImpl.this.getSelectionModel().getSelectedText()) == null ? null : new AttributedString(text).getIterator();
        }

        private void createComposedString(int composedIndex, @NotNull AttributedCharacterIterator text) {
            StringBuffer strBuf = new StringBuffer();
            char c = text.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text.next();
            }
            this.composedText = new String(strBuf);
        }

        private void setInputMethodCaretPosition(@NotNull InputMethodEvent e) {
            if (this.composedText != null) {
                int dot = this.composedTextRange.getStartOffset();
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(@NotNull Runnable runnable2) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, () -> ApplicationManager.getApplication().runWriteAction(runnable2), "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument()));
        }

        private boolean hasRelevantCommittedText(@NotNull InputMethodEvent e) {
            if (e.getCommittedCharacterCount() <= 0) {
                return false;
            }
            AttributedCharacterIterator text = e.getText();
            return text == null || text.first() != '\u00a5';
        }

        private void replaceInputMethodText(@NotNull InputMethodEvent e) {
            if (EditorImpl.this.myNeedToSelectPreviousChar && SystemInfo.isMac && (Registry.is((String)"ide.mac.pressAndHold.brute.workaround") || Registry.is((String)"ide.mac.pressAndHold.workaround") && (this.hasRelevantCommittedText(e) || e.getCaret() == null))) {
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                EditorImpl.this.getCaretModel().runForEachCaret(caret -> {
                    int caretOffset = caret.getOffset();
                    if (caretOffset > 0) {
                        caret.setSelection(caretOffset - 1, caretOffset);
                    }
                });
            }
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text = e.getText();
            DocumentEx doc = EditorImpl.this.getDocument();
            if (this.composedText != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    this.runUndoTransparent(() -> {
                        int docLength = doc.getTextLength();
                        ProperTextRange range2 = this.composedTextRange.intersection(new TextRange(0, docLength));
                        if (range2 != null) {
                            doc.deleteString(range2.getStartOffset(), range2.getEndOffset());
                        }
                    });
                }
                this.composedText = null;
            }
            if (text != null) {
                int composedTextIndex;
                text.first();
                if (commitCount > 0) {
                    char c = text.current();
                    while (commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text.getIndex()) < text.getEndIndex()) {
                    this.createComposedString(composedTextIndex, text);
                    this.runUndoTransparent(() -> EditorModificationUtil.insertStringAtCaret((Editor)EditorImpl.this, (String)this.composedText, (boolean)false, (boolean)false));
                    this.composedTextRange = ProperTextRange.from((int)EditorImpl.this.getCaretModel().getOffset(), (int)this.composedText.length());
                }
            }
        }
    }

    private static class MyInputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private MyInputMethodHandleSwingThreadWrapper(InputMethodRequests delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            return (Rectangle)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getTextLocation(offset));
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            return (TextHitInfo)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getLocationOffset(x, y));
        }

        @Override
        public int getInsertPositionOffset() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getInsertPositionOffset);
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            return (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getCommittedText(beginIndex, endIndex, attributes));
        }

        @Override
        public int getCommittedTextLength() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getCommittedTextLength);
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getSelectedText(attributes));
        }

        private static <T> T execute(Computable<T> computable) {
            return (T)UIUtil.invokeAndWaitIfNeeded(computable);
        }
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider,
    DumbAware {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            this.executeAction("EditorCopy", dataContext);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performCut(@NotNull DataContext dataContext) {
            this.executeAction("EditorCut", dataContext);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            return !EditorImpl.this.isViewer();
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            return this.isCutEnabled(dataContext) && EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performPaste(@NotNull DataContext dataContext) {
            this.executeAction("EditorPaste", dataContext);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            return !EditorImpl.this.isViewer();
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            return !EditorImpl.this.isViewer();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            this.executeAction("EditorDelete", dataContext);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return !EditorImpl.this.isViewer();
        }

        private void executeAction(@NotNull String actionId, @NotNull DataContext dataContext) {
            EditorAction action2 = (EditorAction)ActionManager.getInstance().getAction(actionId);
            if (action2 != null) {
                action2.actionPerformed((Editor)EditorImpl.this, dataContext);
            }
        }
    }

    class MyScrollBar
    extends OpaqueAwareScrollBar {
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(int orientation) {
            super(orientation);
        }

        void setPersistentUI(ScrollBarUI ui) {
            this.myPersistentUI = ui;
            this.setUI(ui);
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            int top = Math.max(0, insets.top);
            if (barUI instanceof ButtonlessScrollBarUI) {
                return top + ((ButtonlessScrollBarUI)barUI).getDecrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton decrButtonValue = (JButton)decrButtonField.get(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return top + decrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            return top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof ButtonlessScrollBarUI) {
                return insets.top + ((ButtonlessScrollBarUI)barUI).getIncrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton incrButtonValue = (JButton)incrButtonField.get(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            if (barUI != null && APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }

        private void registerRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback2) {
            if (this.myPersistentUI instanceof ButtonlessScrollBarUI) {
                ((ButtonlessScrollBarUI)this.myPersistentUI).registerRepaintCallback(callback2);
            }
        }
    }

    private class OpaqueAwareScrollBar
    extends JBScrollBar {
        private boolean myOpaque;

        private OpaqueAwareScrollBar(int orientation) {
            super(orientation);
            ComponentUtil.putClientProperty((JComponent)((Object)this), (Key)ColorKey.FUNCTION_KEY, key -> EditorImpl.this.getColorsScheme().getColor(key));
            this.addPropertyChangeListener("opaque", event -> {
                this.revalidate();
                this.repaint();
            });
        }

        public void setOpaque(boolean opaque) {
            this.myOpaque = opaque;
            super.setOpaque(opaque || EditorImpl.this.shouldScrollBarBeOpaque());
        }

        public boolean isOptimizedDrawingEnabled() {
            return !EditorImpl.this.myBackgroundImageSet;
        }
    }

    private class ScrollingTimer {
        private Timer myTimer;
        private static final int TIMER_PERIOD = 100;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles;
        private int yPassedCycles;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = TimerUtil.createNamedTimer((String)"Editor scroll timer", (int)100, e -> {
                if (EditorImpl.this.isDisposed()) {
                    this.stop();
                    return;
                }
                DocumentRunnable command = new DocumentRunnable(EditorImpl.this.myDocument, EditorImpl.this.myProject){

                    public void run() {
                        int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                        VisualPosition caretPosition = EditorImpl.this.myMultiSelectionInProgress ? EditorImpl.this.myTargetMultiSelectionPosition : EditorImpl.this.getCaretModel().getVisualPosition();
                        int column = caretPosition.column;
                        ScrollingTimer.this.xPassedCycles++;
                        if (ScrollingTimer.this.xPassedCycles >= ScrollingTimer.this.myXCycles) {
                            ScrollingTimer.this.xPassedCycles = 0;
                            column += ScrollingTimer.this.myDx;
                        }
                        int line = caretPosition.line;
                        ScrollingTimer.this.yPassedCycles++;
                        if (ScrollingTimer.this.yPassedCycles >= ScrollingTimer.this.myYCycles) {
                            ScrollingTimer.this.yPassedCycles = 0;
                            line += ScrollingTimer.this.myDy;
                        }
                        line = Math.max(0, line);
                        column = Math.max(0, column);
                        VisualPosition pos = new VisualPosition(line, column);
                        if (!EditorImpl.this.myMultiSelectionInProgress) {
                            EditorImpl.this.getCaretModel().moveToVisualPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        }
                        int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                        int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                        if (EditorImpl.this.getMouseSelectionState() != 0) {
                            EditorImpl.this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                            return;
                        }
                        if (EditorImpl.this.myMultiSelectionInProgress && EditorImpl.this.myLastMousePressedLocation != null) {
                            EditorImpl.this.myTargetMultiSelectionPosition = pos;
                            LogicalPosition newLogicalPosition = EditorImpl.this.visualToLogicalPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollTo(newLogicalPosition, ScrollType.RELATIVE);
                            EditorImpl.this.createSelectionTill(newLogicalPosition);
                        } else {
                            EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                        }
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, (Runnable)command, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }
    }

    class CaretCursor {
        private CaretRectangle[] myLocations = new CaretRectangle[]{new CaretRectangle(new Point(0, 0), 0.0f, null, false)};
        private boolean myEnabled;
        private boolean myIsShown;
        private long myStartTime;

        private CaretCursor() {
            this.setEnabled(true);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                ourCaretBlinkingCommand.myEditor = EditorImpl.this;
                ourCaretBlinkingCommand.setBlinkCaret(blink);
                ourCaretBlinkingCommand.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                this.myIsShown = false;
            }
        }

        private void setPositions(CaretRectangle[] locations) {
            this.myStartTime = System.currentTimeMillis();
            this.myLocations = locations;
        }

        private void repaint() {
            EditorImpl.this.myView.repaintCarets();
        }

        CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
            if (!(!onlyIfShown || this.isEnabled() && this.myIsShown && !EditorImpl.this.isRendererMode() && IJSwingUtilities.hasFocus(EditorImpl.this.getContentComponent()))) {
                return null;
            }
            return this.myLocations;
        }
    }

    public static class CaretRectangle {
        public final Point2D myPoint;
        public final float myWidth;
        public final Caret myCaret;
        public final boolean myIsRtl;

        private CaretRectangle(Point2D point, float width, Caret caret, boolean isRtl) {
            this.myPoint = point;
            this.myWidth = Math.max(width, 2.0f);
            this.myCaret = caret;
            this.myIsRtl = isRtl;
        }
    }

    private static class RepaintCursorCommand
    implements Runnable {
        private long mySleepTime = 500L;
        private boolean myIsBlinkCaret = true;
        @Nullable
        private EditorImpl myEditor;
        private ScheduledFuture<?> mySchedulerHandle;

        private RepaintCursorCommand() {
        }

        public void start() {
            if (this.mySchedulerHandle != null) {
                this.mySchedulerHandle.cancel(false);
            }
            this.mySchedulerHandle = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this, this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        }

        private void setBlinkPeriod(int blinkPeriod) {
            this.mySleepTime = Math.max(blinkPeriod, 10);
            this.start();
        }

        private void setBlinkCaret(boolean value2) {
            this.myIsBlinkCaret = value2;
        }

        @Override
        public void run() {
            if (this.myEditor != null) {
                CaretCursor activeCursor = this.myEditor.myCaretCursor;
                long time = System.currentTimeMillis();
                if ((time -= activeCursor.myStartTime) > this.mySleepTime) {
                    boolean toRepaint = true;
                    if (this.myIsBlinkCaret) {
                        activeCursor.myIsShown = !activeCursor.myIsShown;
                    } else {
                        toRepaint = !activeCursor.myIsShown;
                        activeCursor.myIsShown = true;
                    }
                    if (toRepaint) {
                        activeCursor.repaint();
                    }
                }
            }
        }
    }

    private static @interface MouseSelectionState {
    }
}

