/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFactoryImpl
extends EditorFactory {
    private static final ExtensionPointName<EditorFactoryListener> EP = new ExtensionPointName("com.intellij.editorFactoryListener");
    private static final Logger LOG = Logger.getInstance(EditorFactoryImpl.class);
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final List<Editor> myEditors = ContainerUtil.createLockFreeCopyOnWriteList();

    public EditorFactoryImpl() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Disposer.register((Disposable)project, () -> {
                    Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                    boolean isLastProjectClosed = openProjects.length == 0;
                    ApplicationManager.getApplication().invokeLater(() -> EditorFactoryImpl.this.validateEditorsAreReleased(project, isLastProjectClosed));
                });
            }
        });
        busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
                EditorFactoryImpl.this.refreshAllEditors();
            }
        });
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                for (Editor editor : EditorFactoryImpl.this.myEditors) {
                    ((EditorImpl)editor).beforeModalityStateChanged();
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEditorsAreReleased(@NotNull Project project, boolean isLastProjectClosed) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project && (editor.getProject() != null || !isLastProjectClosed)) continue;
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            finally {
                this.releaseEditor(editor);
            }
        }
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor) {
        if (!(editor instanceof EditorImpl)) {
            throw new RuntimeException("Editor of " + editor.getClass() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        }
        ((EditorImpl)editor).throwEditorNotDisposedError("Editor of " + editor.getClass() + " hasn't been released:");
    }

    @NotNull
    public Document createDocument(char @NotNull [] text) {
        return this.createDocument((CharSequence)new CharArrayCharSequence(text));
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text) {
        DocumentImpl document = new DocumentImpl(text);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl(text, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        return this.createEditor(document, false, null, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document) {
        return this.createEditor(document, true, null, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, Project project) {
        return this.createEditor(document, false, project, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        return this.createEditor(document, false, project, kind);
    }

    public Editor createViewer(@NotNull Document document, Project project) {
        return this.createEditor(document, true, project, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        return this.createEditor(document, true, project, kind);
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull FileType fileType, boolean isViewer) {
        EditorEx editor = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer) {
        EditorEx editor = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer, @NotNull EditorKind kind) {
        EditorEx editor = this.createEditor(document, isViewer, project, kind);
        editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor;
    }

    @NotNull
    private EditorEx createEditor(@NotNull Document document, boolean isViewer, Project project, @NotNull EditorKind kind) {
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project, kind);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        EditorFactoryEvent event = new EditorFactoryEvent((EditorFactory)this, (Editor)editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(event);
        EP.forEachExtensionSafe(it -> it.editorCreated(event));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editors after create: " + this.myEditors.size());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEditor(@NotNull Editor editor) {
        try {
            EditorFactoryEvent event = new EditorFactoryEvent((EditorFactory)this, editor);
            ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(event);
            EP.forEachExtensionSafe(it -> it.editorReleased(event));
        }
        finally {
            try {
                ((EditorImpl)editor).release();
            }
            finally {
                this.myEditors.remove(editor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("number of Editors after release: " + this.myEditors.size());
                }
            }
        }
    }

    @NotNull
    public Stream<Editor> editors(@NotNull Document document, @Nullable Project project) {
        return this.myEditors.stream().filter(editor -> editor.getDocument().equals(document) && (project == null || project.equals(editor.getProject())));
    }

    public Editor @NotNull [] getAllEditors() {
        return this.myEditors.toArray(Editor.EMPTY_ARRAY);
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        return this.myEditorEventMulticaster;
    }

    public static final class MyRawTypedHandler
    implements TypedActionHandlerEx {
        private final TypedActionHandler myDelegate;

        public MyRawTypedHandler(TypedActionHandler delegate) {
            this.myDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, (Object)Boolean.TRUE);
            try {
                this.myDelegate.execute(editor, charTyped, dataContext);
            }
            finally {
                editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, null);
            }
        }

        public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
            if (this.myDelegate instanceof TypedActionHandlerEx) {
                ((TypedActionHandlerEx)this.myDelegate).beforeExecute(editor, c, context, plan);
            }
        }
    }
}

