/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.ClipboardTextPerCaretSplitter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorCopyPasteHelperImpl
extends EditorCopyPasteHelper {
    public void copySelectionToClipboard(@NotNull Editor editor) {
        String s;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList extraData = new ArrayList();
        String string = s = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, extraData) : editor.getSelectionModel().getSelectedText();
        if (s == null) {
            return;
        }
        s = TextBlockTransferable.convertLineSeparators(s, "\n", extraData);
        Transferable contents = editor.getCaretModel().supportsMultipleCarets() ? new TextBlockTransferable(s, extraData, null) : new StringSelection(s);
        CopyPasteManager.getInstance().setContents(contents);
    }

    public static String getSelectedTextForClipboard(@NotNull Editor editor, @NotNull Collection<? super TextBlockTransferableData> extraDataCollector) {
        StringBuilder buf = new StringBuilder();
        String separator = "";
        List carets = editor.getCaretModel().getAllCarets();
        int[] startOffsets = new int[carets.size()];
        int[] endOffsets = new int[carets.size()];
        for (int i2 = 0; i2 < carets.size(); ++i2) {
            buf.append(separator);
            String caretSelectedText = ((Caret)carets.get(i2)).getSelectedText();
            startOffsets[i2] = buf.length();
            if (caretSelectedText != null) {
                buf.append(caretSelectedText);
            }
            endOffsets[i2] = buf.length();
            separator = "\n";
        }
        extraDataCollector.add(new CaretStateTransferableData(startOffsets, endOffsets));
        return buf.toString();
    }

    public TextRange @Nullable [] pasteFromClipboard(@NotNull Editor editor) throws EditorCopyPasteHelper.TooLargeContentException {
        Transferable transferable = EditorModificationUtil.getContentsToPasteToEditor(null);
        return transferable == null ? null : this.pasteTransferable(editor, transferable);
    }

    public TextRange @Nullable [] pasteTransferable(@NotNull Editor editor, @NotNull Transferable content2) throws EditorCopyPasteHelper.TooLargeContentException {
        String text = EditorModificationUtil.getStringContent((Transferable)content2);
        if (text == null) {
            return null;
        }
        int textLength = text.length();
        if (BasePasteHandler.isContentTooLarge(textLength)) {
            throw new EditorCopyPasteHelper.TooLargeContentException(textLength);
        }
        if (editor.getCaretModel().supportsMultipleCarets()) {
            CaretStateTransferableData caretData = null;
            int caretCount = editor.getCaretModel().getCaretCount();
            if (caretCount == 1 && editor.isColumnMode()) {
                int pastedLineCount = LineTokenizer.calcLineCount((CharSequence)text, (boolean)true);
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                Caret caret2 = editor.getCaretModel().getPrimaryCaret();
                for (int i2 = 0; i2 < pastedLineCount - 1 && (caret2 = caret2.clone(false)) != null; ++i2) {
                }
                caretCount = editor.getCaretModel().getCaretCount();
            } else {
                caretData = CaretStateTransferableData.getFrom(content2);
            }
            TextRange[] ranges = new TextRange[caretCount];
            Iterator<String> segments = new ClipboardTextPerCaretSplitter().split(text, caretData, caretCount).iterator();
            int[] index = new int[]{0};
            editor.getCaretModel().runForEachCaret(caret -> {
                String normalizedText = TextBlockTransferable.convertLineSeparators(editor, (String)segments.next());
                normalizedText = EditorCopyPasteHelperImpl.trimTextIfNeeded(editor, normalizedText);
                int caretOffset = caret.getOffset();
                int n = index[0];
                index[0] = n + 1;
                ranges[n] = new TextRange(caretOffset, caretOffset + normalizedText.length());
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)normalizedText, (boolean)false, (boolean)true);
            });
            return ranges;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        String normalizedText = TextBlockTransferable.convertLineSeparators(editor, text);
        normalizedText = EditorCopyPasteHelperImpl.trimTextIfNeeded(editor, normalizedText);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)normalizedText, (boolean)false, (boolean)true);
        return new TextRange[]{new TextRange(caretOffset, caretOffset + text.length())};
    }

    private static String trimTextIfNeeded(Editor editor, String text) {
        Document document;
        JComponent contentComponent = editor.getContentComponent();
        if (contentComponent instanceof JTextComponent && (document = ((JTextComponent)contentComponent).getDocument()) != null && document.getProperty("trimTextOnPaste") == Boolean.TRUE) {
            return text.trim();
        }
        return text;
    }
}

