/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComplementaryFontsRegistry {
    private static final Logger LOG = Logger.getInstance(ComplementaryFontsRegistry.class);
    private static final String DEFAULT_FALLBACK_FONT = "Monospaced";
    private static final Object lock = new Object();
    private static final List<String>[] ourFontNames = new List[4];
    private static final Map<String, Pair<String, Integer>[]> ourStyledFontMap = new HashMap<String, Pair<String, Integer>[]>();
    private static final LinkedHashMap<String, FallBackInfo>[] ourUsedFonts = new LinkedHashMap[]{new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap()};
    public static final FallBackInfo DEFAULT_FONT_INFO = new FallBackInfo("", 0, 0);
    private static final TIntHashSet[] ourUndisplayableChars = new TIntHashSet[]{new TIntHashSet(), new TIntHashSet(), new TIntHashSet(), new TIntHashSet()};
    private static String ourLastFontFamily = "";
    private static int ourLastFontStyle = 0;
    private static FallBackInfo ourLastFallBackInfo = DEFAULT_FONT_INFO;
    @NonNls
    private static final String[] BOLD_NAMES = new String[]{"bold", "demibold", "demi-bold", "demi bold", "negreta", "demi"};
    @NonNls
    private static final String[] ITALIC_NAMES = new String[]{"italic", "cursiva", "oblique", "inclined"};
    @NonNls
    private static final String[] BOLD_ITALIC_NAMES = new String[]{"bolditalic", "bold-italic", "bold italic", "boldoblique", "bold-oblique", "bold oblique", "demibold italic", "negreta cursiva", "demi oblique"};
    @NonNls
    private static final Map<String, Integer> FONT_NAME_TO_STYLE = new HashMap<String, Integer>();
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";
    private static final String ADOBE_BLANK = "Adobe Blank";

    private ComplementaryFontsRegistry() {
    }

    private static void fillStyledFontMap() {
        Font[] allFonts;
        for (Font font : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String name = font.getName();
            Integer style = FONT_NAME_TO_STYLE.get(name);
            if (style == null) {
                if (!Patches.JDK_MAC_FONT_STYLE_BUG) continue;
                style = ComplementaryFontsRegistry.getFontStyle(name);
            }
            if (style == 0) continue;
            String familyName = font.getFamily();
            Pair<String, Integer>[] entry = ourStyledFontMap.get(familyName);
            if (entry == null) {
                entry = new Pair[4];
                for (int i2 = 1; i2 < 4; ++i2) {
                    entry[i2] = Pair.create((Object)familyName, (Object)i2);
                }
                ourStyledFontMap.put(familyName, entry);
            }
            entry[style.intValue()] = Pair.create((Object)name, (Object)0);
        }
    }

    @JdkConstants.FontStyle
    static int getFontStyle(String fontName) {
        fontName = fontName.toLowerCase(Locale.getDefault());
        for (String name : BOLD_ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 3;
        }
        for (String name : ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 2;
        }
        for (String name : BOLD_NAMES) {
            if (!fontName.contains(name)) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(@NotNull CharSequence text, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        assert (0 <= start2 && start2 < end && end <= text.length()) : "Start: " + start2 + ", end: " + end + ", length: " + text.length();
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text.charAt(start2), style, preferences, context);
        }
        int firstCodePoint = Character.codePointAt(text, start2);
        int secondOffset = Character.offsetByCodePoints(text, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
        }
        char[] tmp = CharArrayUtil.fromSequence((CharSequence)text, (int)secondOffset, (int)end);
        return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, tmp, 0, tmp.length, style, preferences, context);
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(char @NotNull [] text, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        assert (0 <= start2 && start2 < end && end <= text.length) : "Start: " + start2 + ", end: " + end + ", length: " + text.length;
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text[start2], style, preferences, context);
        }
        int firstCodePoint = Character.codePointAt(text, start2);
        int secondOffset = Character.offsetByCodePoints(text, start2, end - start2, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
        }
        return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, text, secondOffset, end, style, preferences, context);
    }

    private static FontInfo getFontAbleToDisplay(int codePoint, char @NotNull [] remainingText, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = !Patches.TEXT_LAYOUT_IS_SLOW && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context, len > 1);
            if (result2 != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
                return result2;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, useLigatures, context, false)) != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
            return result2;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, remainingText, start2, end, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        return result2;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = !Patches.TEXT_LAYOUT_IS_SLOW && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context, len > 1);
            if (result2 != null) {
                return result2;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, useLigatures, context, false)) != null) {
            return result2;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        return result2;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, FontRenderContext context) {
        FontInfo result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, defaultFontFamily, false, context, false);
        if (result2 != null) {
            return result2;
        }
        if (!DEFAULT_FALLBACK_FONT.equals(defaultFontFamily) && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, false, context, false)) != null) {
            return result2;
        }
        return ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int originalStyle, @NotNull String defaultFontFamily, boolean useLigatures, FontRenderContext context, boolean disableFontFallback) {
        if (originalStyle < 0 || originalStyle > 3) {
            originalStyle = 0;
        }
        Object object = lock;
        synchronized (object) {
            FallBackInfo fallBackInfo;
            Pair<String, Integer>[] replacement;
            int style = originalStyle;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND && style != 0 && (replacement = ourStyledFontMap.get(defaultFontFamily)) != null) {
                defaultFontFamily = (String)replacement[style].first;
                style = (Integer)replacement[style].second;
            }
            if (ourLastFontStyle == style && ourLastFontFamily.equals(defaultFontFamily) && ComplementaryFontsRegistry.ourLastFallBackInfo.canDisplay(codePoint, disableFontFallback)) {
                fallBackInfo = ourLastFallBackInfo;
            } else {
                LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
                fallBackInfo = usedFonts.get(defaultFontFamily);
                if (fallBackInfo == null) {
                    fallBackInfo = new FallBackInfo(defaultFontFamily, style, originalStyle);
                    usedFonts.put(defaultFontFamily, fallBackInfo);
                }
                ourLastFontFamily = defaultFontFamily;
                ourLastFontStyle = style;
                ourLastFallBackInfo = fallBackInfo;
            }
            return fallBackInfo.canDisplay(codePoint, disableFontFallback) ? fallBackInfo.getFontInfo(size, useLigatures, context) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, char[] remainingText, int start2, int end, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext context) {
        if (style < 0 || style > 3) {
            style = 0;
        }
        Object object = lock;
        synchronized (object) {
            FallBackInfo fallBackInfo = DEFAULT_FONT_INFO;
            TIntHashSet undisplayableChars = ourUndisplayableChars[style];
            if (!undisplayableChars.contains(codePoint)) {
                boolean canDisplayFirst = false;
                LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
                Collection<FallBackInfo> descriptors = usedFonts.values();
                for (FallBackInfo info : descriptors) {
                    if (info.myOriginalStyle != style || !info.canDisplay(codePoint, false)) continue;
                    canDisplayFirst = true;
                    if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                    fallBackInfo = info;
                    break;
                }
                if (fallBackInfo == DEFAULT_FONT_INFO) {
                    List<String> fontNames = ourFontNames[style];
                    for (int i2 = 0; i2 < fontNames.size(); ++i2) {
                        String name = fontNames.get(i2);
                        FallBackInfo info = new FallBackInfo(name, style, style);
                        if (!info.canDisplay(codePoint, false)) continue;
                        canDisplayFirst = true;
                        if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                        usedFonts.put(name, info);
                        fontNames.remove(i2);
                        fallBackInfo = info;
                        break;
                    }
                    if (fallBackInfo == DEFAULT_FONT_INFO && !canDisplayFirst) {
                        undisplayableChars.add(codePoint);
                    }
                }
            }
            return fallBackInfo.getFontInfo(size, useLigatures, context);
        }
    }

    static {
        FONT_NAME_TO_STYLE.put("AnkaCoder-b", 1);
        FONT_NAME_TO_STYLE.put("AnkaCoder-i", 2);
        FONT_NAME_TO_STYLE.put("AnkaCoder-bi", 3);
        FONT_NAME_TO_STYLE.put("SourceCodePro-It", 2);
        FONT_NAME_TO_STYLE.put("SourceCodePro-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("Hasklig-It", 2);
        FONT_NAME_TO_STYLE.put("Hasklig-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("FiraCode-Medium", 1);
        ArrayList<String> fontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            fontNames.add(DEFAULT_FALLBACK_FONT);
        } else {
            String[] families;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND) {
                ComplementaryFontsRegistry.fillStyledFontMap();
            }
            for (String fontName : families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX) || fontName.equals(ADOBE_BLANK)) continue;
                fontNames.add(fontName);
            }
        }
        ComplementaryFontsRegistry.ourFontNames[0] = fontNames;
        for (int i2 = 1; i2 < 4; ++i2) {
            ComplementaryFontsRegistry.ourFontNames[i2] = new ArrayList<String>(fontNames);
        }
    }

    private static class FallBackInfo {
        private final Font myBaseFont;
        private final int myOriginalStyle;
        private final Map<FontKey, FontInfo> myFontInfoMap = new HashMap<FontKey, FontInfo>();
        private final FontKey myLastFontKey = new FontKey(-1, false, new FontRenderContext(null, false, false));
        private FontInfo myLastFontInfo;

        private FallBackInfo(String familyName, @JdkConstants.FontStyle int style, int originalStyle) {
            this.myBaseFont = new Font(familyName, style, 1);
            this.myOriginalStyle = originalStyle;
        }

        private boolean canDisplay(int codePoint, boolean disableFontFallback) {
            return codePoint < 128 || FontInfo.canDisplay(this.myBaseFont, codePoint, disableFontFallback);
        }

        private FontInfo getFontInfo(int size, boolean useLigatures, FontRenderContext fontRenderContext) {
            if (this.myLastFontKey.mySize == size && this.myLastFontKey.myUseLigatures == useLigatures && Objects.equals(this.myLastFontKey.myContext, fontRenderContext)) {
                return this.myLastFontInfo;
            }
            this.myLastFontKey.mySize = size;
            this.myLastFontKey.myUseLigatures = useLigatures;
            this.myLastFontKey.myContext = fontRenderContext;
            FontInfo fontInfo = this.myFontInfoMap.get(this.myLastFontKey);
            if (fontInfo == null) {
                fontInfo = new FontInfo(this.myBaseFont.getName(), size, this.myBaseFont.getStyle(), useLigatures, fontRenderContext);
                this.myFontInfoMap.put(this.myLastFontKey.clone(), fontInfo);
            }
            this.myLastFontInfo = fontInfo;
            return fontInfo;
        }
    }

    private static class FontKey
    implements Cloneable {
        private int mySize;
        private boolean myUseLigatures;
        private FontRenderContext myContext;

        private FontKey(int size, boolean useLigatures, FontRenderContext context) {
            this.mySize = size;
            this.myUseLigatures = useLigatures;
            this.myContext = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontKey key = (FontKey)o;
            if (this.mySize != key.mySize) {
                return false;
            }
            if (this.myUseLigatures != key.myUseLigatures) {
                return false;
            }
            return Objects.equals(this.myContext, key.myContext);
        }

        public int hashCode() {
            int result2 = this.mySize;
            result2 = 31 * result2 + (this.myUseLigatures ? 1 : 0);
            result2 = 31 * result2 + (this.myContext != null ? this.myContext.hashCode() : 0);
            return result2;
        }

        protected FontKey clone() {
            try {
                return (FontKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

