/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BidiContentNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"bidi.content.notification.panel");
    private static final Key<Boolean> DISABLE_NOTIFICATION = Key.create((String)"bidi.content.notification.disable");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        if (!Boolean.TRUE.equals(editor.getUserData(EditorImpl.CONTAINS_BIDI_TEXT)) || Boolean.TRUE.equals(editor.getUserData(DISABLE_NOTIFICATION)) || PropertiesComponent.getInstance().isTrueValue(DISABLE_NOTIFICATION.toString())) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(EditorBundle.message((String)"bidi.content.message", (Object[])new Object[0]));
        panel2.createActionLabel(EditorBundle.message((String)"bidi.content.choose.message", (Object[])new Object[0]), () -> BidiContentNotificationProvider.showChooserPopup(editor));
        panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
            editor.putUserData(DISABLE_NOTIFICATION, (Object)Boolean.TRUE);
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        });
        panel2.createActionLabel(EditorBundle.message((String)"notification.dont.show.again.message", (Object[])new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DISABLE_NOTIFICATION.toString(), "true");
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel2;
    }

    private static void showChooserPopup(Editor editor) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group = actionManager.getAction("EditorBidiTextDirection");
        if (group instanceof ActionGroup) {
            int y;
            int x;
            Component invoker;
            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
            if (event instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                invoker = mouseEvent.getComponent();
                x = mouseEvent.getX();
                y = mouseEvent.getY();
            } else {
                invoker = editor.getContentComponent();
                Point caretPoint = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
                x = caretPoint.x;
                y = caretPoint.y;
            }
            actionManager.createActionPopupMenu("MainMenu", (ActionGroup)group).getComponent().show(invoker, x, y);
        }
    }
}

