/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.RestartableLexer;
import com.intellij.lexer.TokenIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.IntBasedStorage;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.ex.util.ShortBasedStorage;
import com.intellij.openapi.editor.ex.util.ValidatingLexerWrapper;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.SingleCharSequence;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LexerEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance(LexerEditorHighlighter.class);
    private static final int LEXER_INCREMENTALITY_THRESHOLD = 200;
    private static final Set<Class<?>> ourNonIncrementalLexers = new HashSet();
    private HighlighterClient myEditor;
    private final Lexer myLexer;
    private final Map<IElementType, TextAttributes> myAttributesMap = new HashMap<IElementType, TextAttributes>();
    private SegmentArrayWithData mySegments;
    private final SyntaxHighlighter myHighlighter;
    @NotNull
    private EditorColorsScheme myScheme;
    private final int myInitialState;
    protected CharSequence myText;

    public LexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        this.myScheme = scheme;
        this.myLexer = highlighter.getHighlightingLexer();
        this.myLexer.start(Strings.EMPTY_CHAR_SEQUENCE);
        this.myInitialState = this.myLexer.getState();
        this.myHighlighter = highlighter;
        this.mySegments = this.createSegments();
    }

    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new SegmentArrayWithData(this.createStorage());
    }

    @NotNull
    protected DataStorage createStorage() {
        return this.myLexer instanceof RestartableLexer ? new IntBasedStorage() : new ShortBasedStorage();
    }

    public boolean isPlain() {
        return this.myHighlighter instanceof PlainSyntaxHighlighter;
    }

    @Nullable
    protected final Document getDocument() {
        return this.myEditor != null ? this.myEditor.getDocument() : null;
    }

    public final synchronized boolean checkContentIsEqualTo(@NotNull CharSequence sequence) {
        Document document = this.getDocument();
        return document != null && this.isInSyncWithDocument() && Comparing.equal((CharSequence)document.getImmutableCharSequence(), (CharSequence)sequence);
    }

    @NotNull
    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    @NotNull
    protected Lexer getLexer() {
        return this.myLexer;
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        this.myScheme = scheme;
        this.myAttributesMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LexerEditorHighlighter lexerEditorHighlighter = this;
        synchronized (lexerEditorHighlighter) {
            if (!this.isInSyncWithDocument()) {
                Document document = this.getDocument();
                assert (document != null);
                if (document.isInBulkUpdate()) {
                    document.setInBulkUpdate(false);
                }
                this.doSetText(document.getImmutableCharSequence());
            }
            int latestValidOffset = this.mySegments.getLastValidOffset();
            return new HighlighterIteratorImpl(Math.min(startOffset, latestValidOffset));
        }
    }

    public boolean isValid() {
        Project project = this.myEditor.getProject();
        return project != null && !project.isDisposed();
    }

    private boolean isInSyncWithDocument() {
        Document document = this.getDocument();
        return document == null || document.getTextLength() == 0 || this.mySegments.getSegmentCount() > 0;
    }

    private boolean isInitialState(int data2) {
        if (this.myLexer instanceof RestartableLexer) {
            int state = this.mySegments.unpackStateFromData(data2);
            return ((RestartableLexer)this.myLexer).isRestartableState(state);
        }
        return data2 >= 0;
    }

    public synchronized void documentChanged(@NotNull DocumentEvent e) {
        try {
            Class<?> lexerClass;
            int initialState;
            int oldStartIndex;
            int data2;
            int startIndex;
            Document document = e.getDocument();
            CharSequence text = document.getImmutableCharSequence();
            if (document.isInBulkUpdate()) {
                this.myText = null;
                this.mySegments.removeAll();
                return;
            }
            if (this.mySegments.getSegmentCount() == 0) {
                this.setText(text);
                return;
            }
            this.myText = text;
            int oldStartOffset = e.getOffset();
            int segmentIndex = this.mySegments.findSegmentIndex(oldStartOffset) - 2;
            for (startIndex = oldStartIndex = Math.max(0, segmentIndex); !this.isInitialState(data2 = this.mySegments.getSegmentData(startIndex)) && startIndex != 0; --startIndex) {
            }
            int startOffset = this.mySegments.getSegmentStart(startIndex);
            int textLength = text.length();
            if (startOffset == 0 && this.myLexer instanceof RestartableLexer) {
                initialState = ((RestartableLexer)this.myLexer).getStartState();
                this.myLexer.start(text, startOffset, text.length(), initialState);
            } else if (this.myLexer instanceof RestartableLexer) {
                initialState = this.mySegments.unpackStateFromData(this.mySegments.getSegmentData(startIndex));
                ((RestartableLexer)this.myLexer).start(text, startOffset, text.length(), initialState, this.createTokenIterator(startIndex));
            } else {
                initialState = this.myInitialState;
                this.myLexer.start(text, startOffset, text.length(), initialState);
            }
            ValidatingLexerWrapper lexerWrapper = new ValidatingLexerWrapper(this.myLexer);
            IElementType tokenType = lexerWrapper.getTokenType();
            while (tokenType != null && startIndex < oldStartIndex) {
                int lexerState = lexerWrapper.getState();
                int tokenStart = lexerWrapper.getTokenStart();
                int tokenEnd = lexerWrapper.getTokenEnd();
                data2 = this.mySegments.packData(tokenType, lexerState, this.canRestart(lexerState));
                if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data2) break;
                ++startIndex;
                lexerWrapper.advance();
                tokenType = lexerWrapper.getTokenType();
            }
            if (ApplicationManager.getApplication().isInternal() && startOffset == 0 && startIndex > 200 && !ourNonIncrementalLexers.contains(lexerClass = this.myLexer.getClass())) {
                LOG.warn(String.format("%s is probably not incremental: no initial state throughout %d tokens", lexerClass.getName(), startIndex));
                ourNonIncrementalLexers.add(lexerClass);
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
            SegmentArrayWithData insertSegments = new SegmentArrayWithData(this.mySegments.createStorage());
            int repaintEnd = -1;
            int insertSegmentCount = 0;
            int oldEndIndex = -1;
            IElementType tokenType2 = lexerWrapper.getTokenType();
            while (tokenType2 != null) {
                int shiftedTokenStart;
                int index;
                int lexerState = lexerWrapper.getState();
                int tokenStart = lexerWrapper.getTokenStart();
                int tokenEnd = lexerWrapper.getTokenEnd();
                data2 = this.mySegments.packData(tokenType2, lexerState, this.canRestart(lexerState));
                int newEndOffset = e.getOffset() + e.getNewLength();
                if (tokenStart >= newEndOffset && this.canRestart(lexerState) && this.mySegments.getSegmentStart(index = this.mySegments.findSegmentIndex(shiftedTokenStart = tokenStart - e.getNewLength() + e.getOldLength())) == shiftedTokenStart && this.mySegments.getSegmentData(index) == data2) {
                    repaintEnd = tokenStart;
                    oldEndIndex = index;
                    break;
                }
                insertSegments.setElementAt(insertSegmentCount, tokenStart, tokenEnd, data2);
                ++insertSegmentCount;
                lexerWrapper.advance();
                tokenType2 = lexerWrapper.getTokenType();
            }
            int shift = e.getNewLength() - e.getOldLength();
            if (repaintEnd > 0) {
                while (insertSegmentCount > 0 && oldEndIndex > startIndex && LexerEditorHighlighter.segmentsEqual(this.mySegments, oldEndIndex - 1, insertSegments, insertSegmentCount - 1, shift) && !this.hasAdditionalData(oldEndIndex - 1)) {
                    --oldEndIndex;
                    repaintEnd = insertSegments.getSegmentStart(--insertSegmentCount);
                    insertSegments.remove(insertSegmentCount, insertSegmentCount + 1);
                }
            }
            if (repaintEnd == -1) {
                repaintEnd = textLength;
            }
            if (oldEndIndex < 0) {
                oldEndIndex = this.mySegments.getSegmentCount();
            }
            this.mySegments.shiftSegments(oldEndIndex, shift);
            this.mySegments.replace(startIndex, oldEndIndex, insertSegments);
            if (insertSegmentCount == 0 || oldEndIndex == startIndex + 1 && insertSegmentCount == 1 && data2 == this.mySegments.getSegmentData(startIndex)) {
                return;
            }
            this.myEditor.repaint(startOffset, repaintEnd);
        }
        catch (ProcessCanceledException ex) {
            this.myText = null;
            this.mySegments.removeAll();
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new InvalidStateException(this, "Error updating  after " + e, ex);
        }
    }

    @NotNull
    private TokenIterator createTokenIterator(final int start2) {
        return new TokenIterator(){

            public int getStartOffset(int index) {
                return LexerEditorHighlighter.this.mySegments.getSegmentStart(index);
            }

            public int getEndOffset(int index) {
                return LexerEditorHighlighter.this.mySegments.getSegmentEnd(index);
            }

            public IElementType getType(int index) {
                return LexerEditorHighlighter.this.mySegments.unpackTokenFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(index));
            }

            public int getState(int index) {
                return LexerEditorHighlighter.this.mySegments.unpackStateFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(index));
            }

            public int getTokenCount() {
                return LexerEditorHighlighter.this.mySegments.getSegmentCount();
            }

            public int initialTokenIndex() {
                return start2;
            }
        };
    }

    private boolean canRestart(int lexerState) {
        if (this.myLexer instanceof RestartableLexer) {
            return ((RestartableLexer)this.myLexer).isRestartableState(lexerState);
        }
        return lexerState == this.myInitialState;
    }

    protected boolean hasAdditionalData(int segmentIndex) {
        return false;
    }

    @Override
    public int getPriority() {
        return 80;
    }

    private static boolean segmentsEqual(@NotNull SegmentArrayWithData a1, int idx1, @NotNull SegmentArrayWithData a2, int idx2, int offsetShift) {
        return a1.getSegmentStart(idx1) + offsetShift == a2.getSegmentStart(idx2) && a1.getSegmentEnd(idx1) + offsetShift == a2.getSegmentEnd(idx2) && a1.getSegmentData(idx1) == a2.getSegmentData(idx2);
    }

    public HighlighterClient getClient() {
        return this.myEditor;
    }

    final synchronized void resetText(@NotNull CharSequence text) {
        this.myText = null;
        this.doSetText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@NotNull CharSequence text) {
        LexerEditorHighlighter lexerEditorHighlighter = this;
        synchronized (lexerEditorHighlighter) {
            this.doSetText(text);
        }
    }

    private void doSetText(@NotNull CharSequence text) {
        IElementType tokenType;
        if (Comparing.equal((CharSequence)this.myText, (CharSequence)text)) {
            return;
        }
        text = ImmutableCharSequence.asImmutable((CharSequence)text);
        SegmentArrayWithData tempSegments = this.createSegments();
        TokenProcessor processor2 = this.createTokenProcessor(0, tempSegments, text);
        int textLength = text.length();
        ValidatingLexerWrapper lexerWrapper = new ValidatingLexerWrapper(this.myLexer);
        lexerWrapper.start(text, 0, textLength, this.myLexer instanceof RestartableLexer ? ((RestartableLexer)this.myLexer).getStartState() : this.myInitialState);
        int i2 = 0;
        while ((tokenType = lexerWrapper.getTokenType()) != null) {
            int state = lexerWrapper.getState();
            int data2 = tempSegments.packData(tokenType, state, this.canRestart(state));
            processor2.addToken(i2, lexerWrapper.getTokenStart(), lexerWrapper.getTokenEnd(), data2, tokenType);
            if (++i2 % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            lexerWrapper.advance();
        }
        this.myText = text;
        this.mySegments = tempSegments;
        processor2.finish();
        if (textLength > 0 && (this.mySegments.mySegmentCount == 0 || this.mySegments.myEnds[this.mySegments.mySegmentCount - 1] != textLength)) {
            throw new IllegalStateException("Unexpected termination offset for lexer " + this.myLexer);
        }
        if (this.myEditor != null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            UIUtil.invokeLaterIfNeeded(() -> this.myEditor.repaint(0, textLength));
        }
    }

    @NotNull
    protected TokenProcessor createTokenProcessor(int startIndex, SegmentArrayWithData segments, CharSequence myText) {
        return (tokenIndex, startOffset, endOffset, data2, tokenType) -> segments.setElementAt(tokenIndex, startOffset, endOffset, data2);
    }

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter() {
        return this.myHighlighter;
    }

    @NotNull
    private TextAttributes getAttributes(@NotNull IElementType tokenType) {
        TextAttributes attrs = this.myAttributesMap.get(tokenType);
        if (attrs == null) {
            attrs = this.convertAttributes(this.myHighlighter.getTokenHighlights(tokenType));
            this.myAttributesMap.put(tokenType, attrs);
        }
        return attrs;
    }

    @NotNull
    public List<TextAttributes> getAttributesForPreviousAndTypedChars(@NotNull Document document, int offset, char c) {
        CharSequence text = document.getImmutableCharSequence();
        MergingCharSequence newText = StringUtil.replaceSubSequence((CharSequence)text, (int)offset, (int)offset, (CharSequence)new SingleCharSequence(c));
        List<IElementType> tokenTypes = this.getTokenType((CharSequence)newText, offset);
        return Arrays.asList(this.getAttributes(tokenTypes.get(0)).clone(), this.getAttributes(tokenTypes.get(1)).clone());
    }

    @NotNull
    private List<IElementType> getTokenType(@NotNull CharSequence text, int offset) {
        int startOffset = 0;
        int data2 = 0;
        boolean isDataSet = false;
        int oldStartIndex = 0;
        int startIndex = 0;
        if (offset > 0 && this.mySegments.getSegmentCount() > 0) {
            int segmentIndex = this.mySegments.findSegmentIndex(offset - 1) - 2;
            startIndex = oldStartIndex = Math.max(0, segmentIndex);
            while (true) {
                data2 = this.mySegments.getSegmentData(startIndex);
                isDataSet = true;
                if (this.isInitialState(data2) || startIndex == 0) break;
                --startIndex;
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
        }
        int state = this.myLexer instanceof RestartableLexer ? (isDataSet ? this.mySegments.unpackStateFromData(data2) : ((RestartableLexer)this.myLexer).getStartState()) : this.myInitialState;
        if (offset == 0 && this.myLexer instanceof RestartableLexer) {
            this.myLexer.start(text, startOffset, text.length(), ((RestartableLexer)this.myLexer).getStartState());
        } else if (this.myLexer instanceof RestartableLexer) {
            ((RestartableLexer)this.myLexer).start(text, startOffset, text.length(), state, this.createTokenIterator(startIndex));
        } else {
            this.myLexer.start(text, startOffset, text.length(), state);
        }
        ValidatingLexerWrapper lexerWrapper = new ValidatingLexerWrapper(this.myLexer);
        while (lexerWrapper.getTokenType() != null && startIndex < oldStartIndex) {
            int tokenStart = lexerWrapper.getTokenStart();
            int lexerState = lexerWrapper.getState();
            int tokenEnd = lexerWrapper.getTokenEnd();
            data2 = this.mySegments.packData(lexerWrapper.getTokenType(), lexerState, this.canRestart(lexerState));
            if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data2) break;
            ++startIndex;
            lexerWrapper.advance();
        }
        IElementType tokenType1 = null;
        IElementType tokenType2 = null;
        while (lexerWrapper.getTokenType() != null) {
            int lexerState = lexerWrapper.getState();
            data2 = this.mySegments.packData(lexerWrapper.getTokenType(), lexerState, this.canRestart(lexerState));
            if (tokenType1 == null && lexerWrapper.getTokenEnd() >= offset) {
                tokenType1 = this.mySegments.unpackTokenFromData(data2);
            }
            if (lexerWrapper.getTokenEnd() >= offset + 1) {
                tokenType2 = this.mySegments.unpackTokenFromData(data2);
                break;
            }
            lexerWrapper.advance();
        }
        return Arrays.asList(tokenType1, tokenType2);
    }

    @NotNull
    TextAttributes convertAttributes(TextAttributesKey @NotNull [] keys2) {
        TextAttributes resultAttributes = new TextAttributes();
        boolean firstPass = true;
        for (TextAttributesKey key : keys2) {
            TextAttributes attributesByKey = this.myScheme.getAttributes(key);
            if (attributesByKey == null) continue;
            if (firstPass) {
                resultAttributes.copyFrom(attributesByKey);
                firstPass = false;
                continue;
            }
            resultAttributes = TextAttributes.merge((TextAttributes)resultAttributes, (TextAttributes)attributesByKey);
        }
        return resultAttributes;
    }

    public String toString() {
        return this.getClass().getName() + "(" + (this.myLexer.getClass() == FlexAdapter.class ? this.myLexer.toString() : this.myLexer.getClass().getName()) + "): '" + this.myLexer.getBufferSequence() + "'";
    }

    @NotNull
    public SegmentArrayWithData getSegments() {
        return this.mySegments;
    }

    public static class InvalidStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private InvalidStateException(LexerEditorHighlighter highlighter, String message, Throwable cause) {
            super(highlighter.getClass().getName() + "(" + (highlighter.myLexer.getClass() == FlexAdapter.class ? highlighter.myLexer.toString() : highlighter.myLexer.getClass().getName()) + "): " + message, cause);
            this.myAttachments = new Attachment[]{new Attachment("content.txt", highlighter.myLexer.getBufferSequence().toString())};
        }

        public Attachment @NotNull [] getAttachments() {
            return this.myAttachments;
        }
    }

    public class HighlighterIteratorImpl
    implements HighlighterIterator {
        private int mySegmentIndex;

        HighlighterIteratorImpl(int startOffset) {
            try {
                this.mySegmentIndex = LexerEditorHighlighter.this.mySegments.findSegmentIndex(startOffset);
            }
            catch (IllegalStateException e) {
                throw new InvalidStateException(LexerEditorHighlighter.this, "wrong state", e);
            }
        }

        public int currentIndex() {
            return this.mySegmentIndex;
        }

        public TextAttributes getTextAttributes() {
            return LexerEditorHighlighter.this.getAttributes(this.getTokenType());
        }

        public int getStart() {
            return LexerEditorHighlighter.this.mySegments.getSegmentStart(this.mySegmentIndex);
        }

        public int getEnd() {
            return LexerEditorHighlighter.this.mySegments.getSegmentEnd(this.mySegmentIndex);
        }

        public IElementType getTokenType() {
            try {
                return LexerEditorHighlighter.this.mySegments.unpackTokenFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(this.mySegmentIndex));
            }
            catch (IllegalStateException e) {
                throw new InvalidStateException(LexerEditorHighlighter.this, "wrong state", e);
            }
        }

        public void advance() {
            ++this.mySegmentIndex;
        }

        public void retreat() {
            --this.mySegmentIndex;
        }

        public boolean atEnd() {
            return this.mySegmentIndex >= LexerEditorHighlighter.this.mySegments.getSegmentCount() || this.mySegmentIndex < 0;
        }

        public Document getDocument() {
            return LexerEditorHighlighter.this.getDocument();
        }

        public HighlighterClient getClient() {
            return LexerEditorHighlighter.this.getClient();
        }
    }

    protected static interface TokenProcessor {
        public void addToken(int var1, int var2, int var3, int var4, @NotNull IElementType var5);

        default public void finish() {
        }
    }
}

