/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.util.Disposer;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorScrollingPositionKeeper
implements Disposable {
    private final Editor myEditor;
    private int myViewportShift;
    private RangeMarker myTopLeftCornerMarker;

    public EditorScrollingPositionKeeper(@NotNull Editor editor) {
        this.myEditor = editor;
    }

    public void savePosition() {
        this.disposeMarker();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        int caretY = this.myEditor.visualLineToY(this.myEditor.getCaretModel().getVisualPosition().line);
        if (visibleArea.height > 0 && (caretY + this.myEditor.getLineHeight() <= visibleArea.y || caretY >= visibleArea.y + visibleArea.height)) {
            int topLeftCornerOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(visibleArea.getLocation()));
            this.myTopLeftCornerMarker = this.myEditor.getDocument().createRangeMarker(topLeftCornerOffset, topLeftCornerOffset);
            this.myViewportShift = this.myEditor.offsetToXY((int)topLeftCornerOffset).y - visibleArea.y;
        } else {
            this.myTopLeftCornerMarker = null;
            this.myViewportShift = caretY - visibleArea.y;
        }
    }

    public void restorePosition(boolean stopAnimation) {
        boolean disableAnimation;
        int newY;
        if (this.myTopLeftCornerMarker == null) {
            newY = this.myEditor.visualLineToY(this.myEditor.getCaretModel().getVisualPosition().line);
        } else {
            if (!this.myTopLeftCornerMarker.isValid()) {
                return;
            }
            newY = this.myEditor.offsetToXY((int)this.myTopLeftCornerMarker.getStartOffset()).y;
        }
        ScrollingModel scrollingModel = this.myEditor.getScrollingModel();
        Rectangle targetArea = scrollingModel.getVisibleAreaOnScrollingFinished();
        boolean bl = disableAnimation = targetArea.equals(scrollingModel.getVisibleArea()) || stopAnimation;
        if (disableAnimation) {
            scrollingModel.disableAnimation();
        }
        scrollingModel.scroll(targetArea.x, newY - this.myViewportShift);
        if (disableAnimation) {
            scrollingModel.enableAnimation();
        }
    }

    public void dispose() {
        this.disposeMarker();
    }

    private void disposeMarker() {
        if (this.myTopLeftCornerMarker != null) {
            this.myTopLeftCornerMarker.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(@Nullable Editor editor, boolean stopAnimation, @NotNull Runnable operation) {
        if (editor == null) {
            operation.run();
            return;
        }
        EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
        keeper.savePosition();
        try {
            operation.run();
            keeper.restorePosition(stopAnimation);
        }
        finally {
            Disposer.dispose((Disposable)keeper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(@Nullable Document document, boolean stopAnimation, @NotNull Runnable runnable2) {
        ForDocument keeper = new ForDocument(document);
        keeper.savePosition();
        try {
            runnable2.run();
            keeper.restorePosition(stopAnimation);
        }
        finally {
            Disposer.dispose((Disposable)keeper);
        }
    }

    public static class ForDocument
    implements Disposable {
        private final List<EditorScrollingPositionKeeper> myKeepers;

        public ForDocument(@Nullable Document document) {
            this.myKeepers = document == null ? Collections.emptyList() : EditorFactory.getInstance().editors(document).map(EditorScrollingPositionKeeper::new).collect(Collectors.toList());
        }

        public void savePosition() {
            this.myKeepers.forEach(EditorScrollingPositionKeeper::savePosition);
        }

        public void restorePosition(boolean stopAnimation) {
            this.myKeepers.forEach(k -> k.restorePosition(stopAnimation));
        }

        public void dispose() {
            this.myKeepers.forEach(Disposer::dispose);
        }
    }
}

