/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.util.containers.PeekableIterator;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public interface MarkupIterator<T>
extends PeekableIterator<T> {
    public static final MarkupIterator EMPTY = new MarkupIterator(){

        @Override
        public void dispose() {
        }

        public Object peek() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new NoSuchElementException();
        }
    };

    public void dispose();

    @NotNull
    public static <T> MarkupIterator<T> mergeIterators(final @NotNull MarkupIterator<T> iterator1, final @NotNull MarkupIterator<T> iterator2, final @NotNull Comparator<? super T> comparator2) {
        return new MarkupIterator<T>(){

            @Override
            public void dispose() {
                iterator1.dispose();
                iterator2.dispose();
            }

            public boolean hasNext() {
                return iterator1.hasNext() || iterator2.hasNext();
            }

            public T next() {
                return this.choose().next();
            }

            @NotNull
            private MarkupIterator<T> choose() {
                Object t2;
                Object t1 = iterator1.hasNext() ? iterator1.peek() : null;
                Object object = t2 = iterator2.hasNext() ? iterator2.peek() : null;
                if (t1 == null) {
                    return iterator2;
                }
                if (t2 == null) {
                    return iterator1;
                }
                int compare = comparator2.compare(t1, t2);
                return compare < 0 ? iterator1 : iterator2;
            }

            public void remove() {
                throw new NoSuchElementException();
            }

            public T peek() {
                return this.choose().peek();
            }
        };
    }
}

