/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface DocumentEx
extends Document {
    default public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    @NotNull
    public LineIterator createLineIterator();

    public void setModificationStamp(long var1);

    default public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
    }

    default public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
    }

    public void replaceText(@NotNull CharSequence var1, long var2);

    default public void moveText(int srcStart, int srcEnd, int dstOffset) {
        if (!1.$assertionsDisabled && (srcStart > srcEnd || dstOffset > srcStart && dstOffset < srcEnd)) {
            throw new AssertionError();
        }
        if (srcStart < srcEnd && (dstOffset < srcStart || dstOffset > srcEnd)) {
            String fragment = this.getText(new TextRange(srcStart, srcEnd));
            this.insertString(dstOffset, fragment);
            int shift = dstOffset < srcStart ? srcEnd - srcStart : 0;
            this.deleteString(srcStart + shift, srcEnd + shift);
        }
    }

    default public void suppressGuardedExceptions() {
    }

    default public void unSuppressGuardedExceptions() {
    }

    default public boolean isInEventsHandling() {
        return false;
    }

    default public void clearLineModificationFlags() {
    }

    public boolean removeRangeMarker(@NotNull RangeMarkerEx var1);

    public void registerRangeMarker(@NotNull RangeMarkerEx var1, int var2, int var3, boolean var4, boolean var5, int var6);

    @NotNull
    default public List<RangeMarker> getGuardedBlocks() {
        return Collections.emptyList();
    }

    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> var1);

    public boolean processRangeMarkersOverlappingWith(int var1, int var2, @NotNull Processor<? super RangeMarker> var3);

    default public int getModificationSequence() {
        return 0;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

