/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeState;
import java.awt.Color;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorsScheme
extends AbstractColorsScheme
implements ReadOnlyColorsScheme {
    private String myName;

    public DefaultColorsScheme() {
        super(null);
    }

    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key) {
        return key == null ? null : this.getAttributes(key, true);
    }

    @Nullable
    public TextAttributes getAttributes(@NotNull TextAttributesKey key, boolean useDefaults) {
        TextAttributes fallback;
        TextAttributes attrs = (TextAttributes)this.myAttributesMap.get(key.getExternalName());
        if (attrs != null) {
            return attrs;
        }
        TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
        TextAttributes textAttributes = fallback = fallbackKey == null ? null : this.getFallbackAttributes(fallbackKey);
        if (fallback != null && fallback != AbstractColorsScheme.INHERITED_ATTRS_MARKER) {
            return fallback;
        }
        if (!useDefaults) {
            return null;
        }
        TextAttributes keyDefaults = this.getKeyDefaults(key);
        if (keyDefaults != null) {
            return keyDefaults;
        }
        return fallbackKey == null ? null : this.getKeyDefaults(fallbackKey);
    }

    @Nullable
    protected TextAttributes getKeyDefaults(@NotNull TextAttributesKey key) {
        return key.getDefaultAttributes();
    }

    @Nullable
    public Color getColor(@Nullable ColorKey key) {
        return key == null ? null : this.getColor(key, true);
    }

    @Nullable
    public Color getColor(@NotNull ColorKey key, boolean useDefaults) {
        Color fallback;
        Color color = (Color)this.myColorsMap.get(key);
        if (color != null) {
            return color == NULL_COLOR_MARKER ? null : color;
        }
        ColorKey fallbackKey = key.getFallbackColorKey();
        Color color2 = fallback = fallbackKey == null ? null : this.getFallbackColor(fallbackKey);
        if (fallback != null && fallback != AbstractColorsScheme.INHERITED_COLOR_MARKER) {
            return fallback;
        }
        if (!useDefaults) {
            return null;
        }
        Color keyDefaults = key.getDefaultColor();
        if (keyDefaults != null) {
            return keyDefaults;
        }
        return fallbackKey == null ? null : fallbackKey.getDefaultColor();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        super.readExternal(parentNode);
        this.myName = parentNode.getAttributeValue("name");
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
    }

    public void setColor(ColorKey key, Color color) {
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this);
        this.copyTo(newScheme);
        newScheme.setName("Default");
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    public boolean hasEditableCopy() {
        return true;
    }

    public String getEditableCopyName() {
        return "_@user_" + this.myName;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        return SchemeState.NON_PERSISTENT;
    }
}

