/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultColorSchemesManager", defaultStateAsResource=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
@Service
@ApiStatus.Internal
public final class DefaultColorSchemesManager {
    private static final String SCHEME_ELEMENT = "scheme";
    private volatile List<DefaultColorsScheme> mySchemes = Collections.emptyList();

    public static DefaultColorSchemesManager getInstance() {
        return (DefaultColorSchemesManager)ServiceManager.getService(DefaultColorSchemesManager.class);
    }

    public DefaultColorSchemesManager() {
        this.reload();
    }

    public void reload() {
        try {
            this.loadState(JDOMUtil.load(DefaultColorSchemesManager.class, (String)"/DefaultColorSchemesManager.xml"));
        }
        catch (IOException | JDOMException e) {
            ExceptionUtil.rethrow((Throwable)e);
            this.mySchemes = Collections.emptyList();
        }
    }

    public void loadState(@NotNull Element state) {
        ArrayList<DefaultColorsScheme> schemes = new ArrayList<DefaultColorsScheme>();
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            boolean isUpdated = false;
            Attribute nameAttr = schemeElement.getAttribute("name");
            if (nameAttr != null) {
                for (DefaultColorsScheme oldScheme : this.mySchemes) {
                    if (!StringUtil.equals((CharSequence)nameAttr.getValue(), (CharSequence)oldScheme.getName())) continue;
                    oldScheme.readExternal(schemeElement);
                    schemes.add(oldScheme);
                    isUpdated = true;
                }
            }
            if (isUpdated) continue;
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            schemes.add(newScheme);
        }
        schemes.add(EmptyColorScheme.INSTANCE);
        this.mySchemes = Collections.unmodifiableList(schemes);
    }

    @NotNull
    public List<DefaultColorsScheme> getAllSchemes() {
        return this.mySchemes;
    }

    @NotNull
    public List<String> listNames() {
        String[] names2 = new String[this.mySchemes.size()];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = this.mySchemes.get(i2).getName();
        }
        return Arrays.asList(names2);
    }

    @NotNull
    public DefaultColorsScheme getFirstScheme() {
        return this.mySchemes.get(0);
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

