/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectAllOccurrencesAction
extends EditorAction {
    protected SelectAllOccurrencesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends SelectOccurrencesActionHandler {
        private Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return editor.getProject() != null && editor.getCaretModel().supportsMultipleCarets() && (Boolean)IncrementalFindAction.SEARCH_DISABLED.get((UserDataHolder)editor, (Object)false) == false;
        }

        public void doExecute(final @NotNull Editor editor, @Nullable Caret c, DataContext dataContext) {
            TextRange wordSelectionRange;
            Caret caret = c == null ? editor.getCaretModel().getPrimaryCaret() : c;
            boolean wholeWordsSearch = false;
            if (!caret.hasSelection() && (wordSelectionRange = Handler.getSelectionRange(editor, caret)) != null) {
                Handler.setSelection(editor, caret, wordSelectionRange);
                wholeWordsSearch = true;
            }
            String selectedText = caret.getSelectedText();
            Project project = editor.getProject();
            if (project == null || selectedText == null) {
                return;
            }
            int caretShiftFromSelectionStart = caret.getOffset() - caret.getSelectionStart();
            final FindManager findManager = FindManager.getInstance((Project)project);
            final FindModel model = Handler.getFindModel(selectedText, wholeWordsSearch);
            FindUtil.selectSearchResultsInEditor(editor, (Iterator<? extends FindResult>)new Iterator<FindResult>(){
                FindResult findResult;
                {
                    this.findResult = findManager.findString(editor.getDocument().getCharsSequence(), 0, model);
                }

                @Override
                public boolean hasNext() {
                    return this.findResult.isStringFound();
                }

                @Override
                public FindResult next() {
                    FindResult result2 = this.findResult;
                    this.findResult = findManager.findString(editor.getDocument().getCharsSequence(), this.findResult.getEndOffset(), model);
                    return result2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, caretShiftFromSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

