/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class ScrollToTheEndToolbarAction
extends ToggleAction
implements DumbAware {
    private final Editor myEditor;

    public ScrollToTheEndToolbarAction(@NotNull Editor editor) {
        this.myEditor = editor;
        String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
        this.getTemplatePresentation().setDescription(message);
        this.getTemplatePresentation().setText(message);
        this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Document document = this.myEditor.getDocument();
        return document.getLineCount() == 0 || document.getLineNumber(this.myEditor.getCaretModel().getOffset()) == document.getLineCount() - 1;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (state) {
            EditorUtil.scrollToTheEnd(this.myEditor);
        } else {
            int lastLine = Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
            LogicalPosition currentPosition = this.myEditor.getCaretModel().getLogicalPosition();
            LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
            this.myEditor.getCaretModel().moveToLogicalPosition(position);
        }
    }
}

