/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CloneCaretActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveCaretDownWithSelectionAction
extends EditorAction {
    public MoveCaretDownWithSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                editor.getCaretModel().moveCaretRelatively(0, 1, true, editor.isColumnMode(), true);
                return;
            }
            if (editor.isColumnMode()) {
                new CloneCaretActionHandler(false).execute(editor, caret, dataContext);
            } else {
                CaretAction caretAction = c -> c.moveCaretRelatively(0, 1, true, c == editor.getCaretModel().getPrimaryCaret());
                if (caret == null) {
                    editor.getCaretModel().runForEachCaret(caretAction);
                } else {
                    caretAction.perform(caret);
                }
            }
        }
    }
}

