/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.DynamicBundle;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffColorDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private final EventDispatcher<OptionsPanelImpl.ColorDescriptionPanel.Listener> myDispatcher;
    private JPanel myPanel;
    private ColorPanel myBackgroundColorPanel;
    private ColorPanel myIgnoredColorPanel;
    private ColorPanel myStripeMarkColorPanel;
    private JBCheckBox myInheritIgnoredCheckBox;
    @NotNull
    private final ColorAndFontOptions myOptions;

    DiffColorDescriptionPanel(@NotNull ColorAndFontOptions options2) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(OptionsPanelImpl.ColorDescriptionPanel.Listener.class);
        this.myOptions = options2;
        this.add((Component)this.myPanel, "Center");
        this.myBackgroundColorPanel.addActionListener(this::onSettingsChanged);
        this.myIgnoredColorPanel.addActionListener(this::onSettingsChanged);
        this.myStripeMarkColorPanel.addActionListener(this::onSettingsChanged);
        this.myInheritIgnoredCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffColorDescriptionPanel.this.myIgnoredColorPanel.setEnabled(!DiffColorDescriptionPanel.this.myInheritIgnoredCheckBox.isSelected());
                if (DiffColorDescriptionPanel.this.myInheritIgnoredCheckBox.isSelected()) {
                    DiffColorDescriptionPanel.this.myIgnoredColorPanel.setSelectedColor(null);
                } else {
                    Color background = (Color)ObjectUtils.notNull((Object)DiffColorDescriptionPanel.this.myBackgroundColorPanel.getSelectedColor(), (Object)JBColor.WHITE);
                    Color gutterBackground = DiffColorDescriptionPanel.this.myOptions.getSelectedScheme().getDefaultBackground();
                    DiffColorDescriptionPanel.this.myIgnoredColorPanel.setSelectedColor(TextDiffTypeFactory.getMiddleColor(background, gutterBackground));
                }
                DiffColorDescriptionPanel.this.onSettingsChanged(e);
            }
        });
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        return this;
    }

    private void onSettingsChanged(@NotNull ActionEvent e) {
        ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onSettingsChanged(e);
    }

    @Override
    public void resetDefault() {
        this.myBackgroundColorPanel.setEnabled(false);
        this.myIgnoredColorPanel.setEnabled(false);
        this.myStripeMarkColorPanel.setEnabled(false);
        this.myInheritIgnoredCheckBox.setEnabled(false);
        this.myInheritIgnoredCheckBox.setSelected(false);
    }

    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor attrDescription) {
        if (!(attrDescription instanceof ColorAndFontDescription)) {
            return;
        }
        ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
        Color backgroundColor = DiffColorDescriptionPanel.getBackgroundColor(description);
        Color ignoredColor = DiffColorDescriptionPanel.getIgnoredColor(description);
        Color stripeMarkColor = DiffColorDescriptionPanel.getStripeMarkColor(description);
        boolean inheritIgnored = ignoredColor == null;
        this.myBackgroundColorPanel.setEnabled(true);
        this.myIgnoredColorPanel.setEnabled(!inheritIgnored);
        this.myStripeMarkColorPanel.setEnabled(true);
        this.myInheritIgnoredCheckBox.setEnabled(true);
        this.myBackgroundColorPanel.setSelectedColor(backgroundColor);
        this.myIgnoredColorPanel.setSelectedColor(ignoredColor);
        this.myStripeMarkColorPanel.setSelectedColor(stripeMarkColor);
        this.myInheritIgnoredCheckBox.setSelected(inheritIgnored);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor attrDescription, EditorColorsScheme scheme) {
        if (!(attrDescription instanceof ColorAndFontDescription)) {
            return;
        }
        ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
        description.setBackgroundChecked(true);
        description.setForegroundChecked(true);
        description.setErrorStripeChecked(true);
        this.setBackgroundColor(description);
        this.setIgnoredColor(description);
        this.setStripeMarkColor(description);
        description.apply(scheme);
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Nullable
    private static Color getBackgroundColor(@NotNull TextAttributes attributes) {
        return attributes.getBackgroundColor();
    }

    @Nullable
    private static Color getIgnoredColor(@NotNull TextAttributes attributes) {
        return attributes.getForegroundColor();
    }

    @Nullable
    private static Color getStripeMarkColor(@NotNull TextAttributes attributes) {
        return attributes.getErrorStripeColor();
    }

    private void setBackgroundColor(@NotNull TextAttributes attributes) {
        attributes.setBackgroundColor(this.myBackgroundColorPanel.getSelectedColor());
    }

    private void setIgnoredColor(@NotNull TextAttributes attributes) {
        attributes.setForegroundColor(this.myInheritIgnoredCheckBox.isSelected() ? null : this.myIgnoredColorPanel.getSelectedColor());
    }

    private void setStripeMarkColor(@NotNull TextAttributes attributes) {
        attributes.setErrorStripeColor(this.myStripeMarkColorPanel.getSelectedColor());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 10, 10, 10), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("merge.color.options.background.color.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackgroundColorPanel = colorPanel3 = new ColorPanel();
        jPanel2.add((Component)colorPanel3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", DiffColorDescriptionPanel.class).getString("checkbox.color.error.stripe.mark"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStripeMarkColorPanel = colorPanel2 = new ColorPanel();
        jPanel2.add((Component)colorPanel2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("merge.color.options.ignored.color.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoredColorPanel = colorPanel = new ColorPanel();
        jPanel2.add((Component)colorPanel, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myInheritIgnoredCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("option.inherit.ignored.color"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

