/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private static final Logger LOG = Logger.getInstance(DiffRequestFactoryImpl.class);

    public MergeRequest createMergeRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @NotNull VirtualFile file2, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null) {
            return new MergeRequestImpl(leftText, new MergeVersion.MergeDocumentVersion(document, originalContent), rightText, project);
        }
        LOG.warn("Document not found for " + file2.getPresentableUrl() + "; FileType - " + file2.getFileType().getName() + "; valid - " + file2.isValid());
        return this.create3WayDiffRequest(leftText, rightText, originalContent, file2.getFileType(), project, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequest create3WayDiffRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @Nullable FileType type, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        return new MergeRequestImpl(leftText, originalContent, rightText, type, project);
    }

    public MergeRequest create3WayDiffRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        return this.create3WayDiffRequest(leftText, rightText, originalContent, null, project, okButtonPresentation, cancelButtonPresentation);
    }
}

