/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.ChangeCompareModeAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ChangeCompareModeGroup
extends ComboBoxAction
implements ShortcutProvider,
DumbAware {
    private final DefaultActionGroup myGroup;
    private final DirDiffSettings mySettings;
    private JButton myButton;

    public ChangeCompareModeGroup(DirDiffTableModel model) {
        this.mySettings = model.getSettings();
        this.getTemplatePresentation().setText(this.mySettings.compareMode.getPresentableName());
        ArrayList<ChangeCompareModeAction> actions = new ArrayList<ChangeCompareModeAction>();
        if (model.getSettings().showCompareModes) {
            for (DirDiffSettings.CompareMode mode : DirDiffSettings.CompareMode.values()) {
                actions.add(new ChangeCompareModeAction(model, mode));
            }
        } else {
            this.getTemplatePresentation().setEnabledAndVisible(false);
        }
        this.myGroup = new DefaultActionGroup((AnAction[])actions.toArray(new ChangeCompareModeAction[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myButton.doClick();
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.getTemplatePresentation().setText(this.mySettings.compareMode.getPresentableName());
        e.getPresentation().setText(this.mySettings.compareMode.getPresentableName());
        e.getPresentation().setEnabledAndVisible(this.mySettings.showCompareModes);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        JLabel label2 = new JLabel(DiffBundle.message((String)"compare.by", (Object[])new Object[0]));
        label2.setDisplayedMnemonicIndex(0);
        this.myButton = (JButton)super.createCustomComponent(presentation2, place).getComponent(0);
        return JBUI.Panels.simplePanel((Component)this.myButton).addToLeft((Component)label2).withBorder((Border)JBUI.Borders.empty((int)2, (int)6, (int)2, (int)0));
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        return this.myGroup;
    }

    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{"alt C"});
    }
}

