/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffTool;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffUsageTriggerCollector {
    private static void trigger(@NotNull @NonNls String eventId, @NotNull FeatureUsageData data2) {
        FUCounterUsageLogger.getInstance().logEvent("vcs.diff.trigger", eventId, data2);
    }

    public static void trigger(@NotNull @NonNls String feature, @NotNull Enum value2, @Nullable @NonNls String place) {
        FeatureUsageData data2 = new FeatureUsageData().addData("value", value2.name()).addData("diff_place", StringUtil.notNullize((String)place, (String)"unknown"));
        DiffUsageTriggerCollector.trigger(feature, data2);
    }

    public static void trigger(@NotNull @NonNls String feature, @NotNull DiffTool diffTool, @Nullable @NonNls String place) {
        FeatureUsageData data2 = new FeatureUsageData().addPluginInfo(PluginInfoDetectorKt.getPluginInfo(diffTool.getClass())).addData("value", diffTool.getName()).addData("diff_place", StringUtil.notNullize((String)place, (String)"unknown"));
        DiffUsageTriggerCollector.trigger(feature, data2);
    }
}

