/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryStorageUtil {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageUtil.class);

    @NotNull
    public static Map<String, Element> loadFrom(@Nullable VirtualFile dir, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, Element> fileToState = new HashMap<String, Element>();
        for (VirtualFile file2 : dir.getChildren()) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)file2.getNameSequence(), (CharSequence)".xml")) continue;
            try {
                Element state;
                if (file2.getLength() == 0L) {
                    LOG.warn("Ignore empty file " + file2.getPath());
                    continue;
                }
                Element element2 = JDOMUtil.load((InputStream)file2.getInputStream());
                String componentName = FileStorageCoreUtil.getComponentNameIfValid(element2);
                if (componentName == null) continue;
                if (!element2.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element2.getName() + ") in " + file2.getPresentableUrl());
                    continue;
                }
                List elementChildren = element2.getChildren();
                if (elementChildren.isEmpty() || JDOMUtil.isEmpty((Element)(state = ((Element)elementChildren.get(0)).detach()))) continue;
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(state);
                    if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                        ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(state));
                    }
                }
                Element newState2 = JDOMUtil.internElement((Element)state);
                fileToState.put(file2.getName(), newState2);
            }
            catch (Throwable e) {
                LOG.warn("Unable to load state", e);
            }
        }
        return fileToState;
    }

    @Nullable
    public static Element getCompositeState(@NotNull Map<String, Element> fileToState, @NotNull StateSplitterEx splitter) {
        Element state = new Element("component");
        if (fileToState.isEmpty()) {
            return state;
        }
        for (String fileName : fileToState.keySet()) {
            Element subState = fileToState.get(fileName);
            if (subState == null) {
                return null;
            }
            splitter.mergeStateInto(state, subState);
        }
        return state;
    }
}

