/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoManagerImpl
extends UndoManager {
    private static final Logger LOG = Logger.getInstance(UndoManagerImpl.class);
    public static boolean ourNeverAskUser;
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    @Nullable
    private final ProjectEx myProject;
    private CurrentEditorProvider myEditorProvider;
    private final UndoRedoStacksHolder myUndoStacksHolder = new UndoRedoStacksHolder(true);
    private final UndoRedoStacksHolder myRedoStacksHolder = new UndoRedoStacksHolder(false);
    private final CommandMerger myMerger;
    private CommandMerger myCurrentMerger;
    private Project myCurrentActionProject = DummyProject.getInstance();
    private int myCommandTimestamp = 1;
    private int myCommandLevel;
    private OperationState myCurrentOperationState = OperationState.NONE;
    private DocumentReference myOriginatorReference;

    public static boolean isRefresh() {
        return ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class);
    }

    public static int getGlobalUndoLimit() {
        return Registry.intValue((String)"undo.globalUndoLimit");
    }

    public static int getDocumentUndoLimit() {
        return Registry.intValue((String)"undo.documentUndoLimit");
    }

    private UndoManagerImpl(@Nullable ComponentManager componentManager) {
        this.myProject = componentManager instanceof ProjectEx ? (ProjectEx)componentManager : null;
        this.myMerger = new CommandMerger(this);
        if (this.myProject != null && this.myProject.isDefault()) {
            return;
        }
        this.myEditorProvider = new FocusBasedCurrentEditorProvider();
        MessageBus messageBus = this.myProject == null ? ApplicationManager.getApplication().getMessageBus() : this.myProject.getMessageBus();
        messageBus.connect().subscribe(CommandListener.TOPIC, (Object)new CommandListener(){
            private boolean myStarted;

            public void commandStarted(@NotNull CommandEvent event) {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy(), event.shouldRecordActionForOriginalDocument());
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
            }

            public void undoTransparentActionStarted() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!UndoManagerImpl.this.isInsideCommand()) {
                    this.myStarted = true;
                    UndoManagerImpl.this.onCommandStarted(UndoManagerImpl.this.myProject, UndoConfirmationPolicy.DEFAULT, true);
                }
            }

            public void undoTransparentActionFinished() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (this.myStarted) {
                    this.myStarted = false;
                    UndoManagerImpl.this.onCommandFinished(UndoManagerImpl.this.myProject, "", null);
                }
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isActive() {
        return Comparing.equal((Object)this.myProject, (Object)this.myCurrentActionProject) || this.myProject == null && this.myCurrentActionProject.isDefault();
    }

    @ApiStatus.Internal
    public boolean isInsideCommand() {
        return this.myCommandLevel > 0;
    }

    @NotNull
    private List<UndoProvider> getUndoProviders() {
        return this.myProject == null ? UndoProvider.EP_NAME.getExtensionList() : UndoProvider.PROJECT_EP_NAME.getExtensionList((AreaInstance)this.myProject);
    }

    private void onCommandStarted(Project project, UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.getUndoProviders()) {
                undoProvider.commandStarted(project);
            }
            this.myCurrentActionProject = project;
        }
        this.commandStarted(undoConfirmationPolicy, this.myProject == project && recordOriginalReference);
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void onCommandFinished(Project project, String commandName, Object commandGroupId) {
        this.commandFinished(commandName, commandGroupId);
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.getUndoProviders()) {
                undoProvider.commandFinished(project);
            }
            this.myCurrentActionProject = DummyProject.getInstance();
        }
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void commandStarted(UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        if (this.myCommandLevel == 0) {
            this.myCurrentMerger = new CommandMerger(this, CommandProcessor.getInstance().isUndoTransparentActionInProgress());
            if (recordOriginalReference && this.myProject != null) {
                Editor editor = null;
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                    editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                } else {
                    Component component2 = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
                    if (component2 != null) {
                        editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext(component2));
                    }
                }
                if (editor != null) {
                    Document document = editor.getDocument();
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                    if (file2 != null && file2.isValid()) {
                        this.myOriginatorReference = DocumentReferenceManager.getInstance().create(file2);
                    }
                }
            }
        }
        LOG.assertTrue(this.myCurrentMerger != null, (Object)String.valueOf(this.myCommandLevel));
        this.myCurrentMerger.setBeforeState(this.getCurrentState());
        this.myCurrentMerger.mergeUndoConfirmationPolicy(undoConfirmationPolicy);
        ++this.myCommandLevel;
    }

    private void commandFinished(String commandName, Object groupId2) {
        if (this.myCommandLevel == 0) {
            return;
        }
        --this.myCommandLevel;
        if (this.myCommandLevel > 0) {
            return;
        }
        if (this.myProject != null && this.myCurrentMerger.hasActions() && !this.myCurrentMerger.isTransparent() && this.myCurrentMerger.isPhysical() && this.myOriginatorReference != null) {
            this.addDocumentAsAffected(this.myOriginatorReference);
        }
        this.myOriginatorReference = null;
        this.myCurrentMerger.setAfterState(this.getCurrentState());
        this.myMerger.commandFinished(commandName, groupId2, this.myCurrentMerger);
        this.disposeCurrentMerger();
    }

    public void addDocumentAsAffected(@NotNull Document document) {
        this.addDocumentAsAffected(DocumentReferenceManager.getInstance().create(document));
    }

    private void addDocumentAsAffected(@NotNull DocumentReference documentReference) {
        if (this.myCurrentMerger.hasChangesOf(documentReference, true)) {
            return;
        }
        DocumentReference[] refs = new DocumentReference[]{documentReference};
        this.myCurrentMerger.addAction(new MentionOnlyUndoableAction(refs));
    }

    private EditorAndState getCurrentState() {
        FileEditor editor = this.myEditorProvider.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        if (!editor.isValid()) {
            return null;
        }
        return new EditorAndState(editor, editor.getState(FileEditorStateLevel.UNDO));
    }

    private void disposeCurrentMerger() {
        LOG.assertTrue(this.myCommandLevel == 0);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger = null;
        }
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.undoableActionPerformed(new NonUndoableAction(ref, isGlobal));
    }

    public void undoableActionPerformed(@NotNull UndoableAction action2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (this.myProject != null && this.myProject.isDisposed() || this.myCurrentOperationState != OperationState.NONE) {
            return;
        }
        if (this.myCommandLevel == 0) {
            LOG.assertTrue(action2 instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            this.commandStarted(UndoConfirmationPolicy.DEFAULT, false);
            this.myCurrentMerger.addAction(action2);
            this.commandFinished("", null);
            return;
        }
        if (UndoManagerImpl.isRefresh()) {
            this.myOriginatorReference = null;
        }
        this.myCurrentMerger.addAction(action2);
    }

    public void markCurrentCommandAsGlobal() {
        this.myCurrentMerger.markAsGlobal();
    }

    void addAffectedDocuments(Document ... docs) {
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(docs.length);
        for (Document each : docs) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(each);
            if (file2 != null && !file2.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void addAffectedFiles(VirtualFile ... files2) {
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(files2.length);
        for (VirtualFile each : files2) {
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void invalidateActionsFor(@NotNull DocumentReference ref) {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.myMerger.invalidateActionsFor(ref);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger.invalidateActionsFor(ref);
        }
        this.myUndoStacksHolder.invalidateActionsFor(ref);
        this.myRedoStacksHolder.invalidateActionsFor(ref);
    }

    public void undo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsWriteThread();
        LOG.assertTrue(this.isUndoAvailable(editor));
        this.undoOrRedo(editor, true);
    }

    public void redo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsWriteThread();
        LOG.assertTrue(this.isRedoAvailable(editor));
        this.undoOrRedo(editor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(FileEditor editor, boolean isUndo) {
        this.myCurrentOperationState = isUndo ? OperationState.UNDO : OperationState.REDO;
        try {
            RuntimeException[] exception = new RuntimeException[1];
            Runnable executeUndoOrRedoAction = () -> {
                try {
                    CopyPasteManager.getInstance().stopKillRings();
                    this.myMerger.undoOrRedo(editor, isUndo);
                }
                catch (RuntimeException ex) {
                    exception[0] = ex;
                }
            };
            String name = (String)this.getUndoOrRedoActionNameAndDescription((FileEditor)editor, (boolean)this.isUndoInProgress()).second;
            CommandProcessor.getInstance().executeCommand((Project)this.myProject, executeUndoOrRedoAction, name, null, this.myMerger.getUndoConfirmationPolicy());
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        finally {
            this.myCurrentOperationState = OperationState.NONE;
        }
    }

    public boolean isUndoInProgress() {
        return this.myCurrentOperationState == OperationState.UNDO;
    }

    public boolean isRedoInProgress() {
        return this.myCurrentOperationState == OperationState.REDO;
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, false);
    }

    boolean isUndoOrRedoAvailable(@Nullable FileEditor editor, boolean undo) {
        ApplicationManager.getApplication().assertIsWriteThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        return refs != null && this.isUndoOrRedoAvailable(refs, undo);
    }

    boolean isUndoOrRedoAvailable(@NotNull DocumentReference ref) {
        Set<DocumentReference> refs = Collections.singleton(ref);
        return this.isUndoOrRedoAvailable(refs, true) || this.isUndoOrRedoAvailable(refs, false);
    }

    private boolean isUndoOrRedoAvailable(@NotNull Collection<? extends DocumentReference> refs, boolean isUndo) {
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return true;
        }
        UndoRedoStacksHolder stackHolder = this.getStackHolder(isUndo);
        return stackHolder.canBeUndoneOrRedone(refs);
    }

    private static Collection<DocumentReference> getDocRefs(@Nullable FileEditor editor) {
        if (editor instanceof TextEditor && ((TextEditor)editor).getEditor().isViewer()) {
            return null;
        }
        if (editor == null) {
            return Collections.emptyList();
        }
        return UndoManagerImpl.getDocumentReferences(editor);
    }

    @NotNull
    static Set<DocumentReference> getDocumentReferences(@NotNull FileEditor editor) {
        Document[] documents;
        THashSet result2 = new THashSet();
        if (editor instanceof DocumentReferenceProvider) {
            result2.addAll(((DocumentReferenceProvider)editor).getDocumentReferences());
            return result2;
        }
        for (Document each : documents = TextEditorProvider.getDocuments(editor)) {
            Document original = UndoManagerImpl.getOriginal(each);
            VirtualFile f = FileDocumentManager.getInstance().getFile(each);
            if (f != null && !f.isValid()) continue;
            result2.add(DocumentReferenceManager.getInstance().create(original));
        }
        return result2;
    }

    @NotNull
    private UndoRedoStacksHolder getStackHolder(boolean isUndo) {
        return isUndo ? this.myUndoStacksHolder : this.myRedoStacksHolder;
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor) {
        return this.getUndoOrRedoActionNameAndDescription(editor, true);
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor) {
        return this.getUndoOrRedoActionNameAndDescription(editor, false);
    }

    @NotNull
    private Pair<String, String> getUndoOrRedoActionNameAndDescription(@Nullable FileEditor editor, boolean undo) {
        String desc;
        String string = desc = this.isUndoOrRedoAvailable(editor, undo) ? this.doFormatAvailableUndoRedoAction(editor, undo) : null;
        if (desc == null) {
            desc = "";
        }
        String shortActionName = StringUtil.first((String)desc, (int)30, (boolean)true);
        if (desc.isEmpty()) {
            desc = undo ? ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]) : ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0]);
        }
        return Pair.create((Object)(undo ? ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{shortActionName}) : ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{shortActionName})).trim(), (Object)(undo ? ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{desc}) : ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{desc})).trim());
    }

    @Nullable
    private String doFormatAvailableUndoRedoAction(FileEditor editor, boolean isUndo) {
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return null;
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return this.myMerger.getCommandName();
        }
        return this.getStackHolder(isUndo).getLastAction(refs).getCommandName();
    }

    @NotNull
    UndoRedoStacksHolder getUndoStacksHolder() {
        return this.myUndoStacksHolder;
    }

    @NotNull
    UndoRedoStacksHolder getRedoStacksHolder() {
        return this.myRedoStacksHolder;
    }

    int nextCommandTimestamp() {
        return ++this.myCommandTimestamp;
    }

    @NotNull
    private static Document getOriginal(@NotNull Document document) {
        Document result2 = (Document)document.getUserData(ORIGINAL_DOCUMENT);
        return result2 == null ? document : result2;
    }

    static boolean isCopy(@NotNull Document d) {
        return d.getUserData(ORIGINAL_DOCUMENT) != null;
    }

    protected void compact() {
        if (this.myCurrentOperationState == OperationState.NONE && this.myCommandTimestamp % 20 == 0) {
            this.doCompact();
        }
    }

    private void doCompact() {
        DocumentReference each;
        Collection<DocumentReference> refs = this.collectReferencesWithoutMergers();
        HashSet<DocumentReference> openDocs = new HashSet<DocumentReference>();
        for (DocumentReference each2 : refs) {
            VirtualFile file2 = each2.getFile();
            if (file2 == null) {
                Document document = each2.getDocument();
                if (document == null || !EditorFactory.getInstance().editors(document, (Project)this.myProject).findFirst().isPresent()) continue;
                openDocs.add(each2);
                continue;
            }
            if (this.myProject == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file2)) continue;
            openDocs.add(each2);
        }
        refs.removeAll(openDocs);
        if (refs.size() <= 30) {
            return;
        }
        DocumentReference[] backSorted = refs.toArray(DocumentReference.EMPTY_ARRAY);
        Arrays.sort(backSorted, Comparator.comparingInt(this::getLastCommandTimestamp));
        for (int i2 = 0; i2 < backSorted.length - 30 && this.getLastCommandTimestamp(each = backSorted[i2]) + 100 <= this.myCommandTimestamp; ++i2) {
            this.clearUndoRedoQueue(each);
        }
    }

    private int getLastCommandTimestamp(@NotNull DocumentReference ref) {
        return Math.max(this.myUndoStacksHolder.getLastCommandTimestamp(ref), this.myRedoStacksHolder.getLastCommandTimestamp(ref));
    }

    @NotNull
    private Collection<DocumentReference> collectReferencesWithoutMergers() {
        THashSet result2 = new THashSet();
        this.myUndoStacksHolder.collectAllAffectedDocuments((Collection<? super DocumentReference>)result2);
        this.myRedoStacksHolder.collectAllAffectedDocuments((Collection<? super DocumentReference>)result2);
        return result2;
    }

    private void clearUndoRedoQueue(@NotNull DocumentReference docRef) {
        this.myMerger.flushCurrentCommand();
        this.disposeCurrentMerger();
        this.myUndoStacksHolder.clearStacks(false, Collections.singleton(docRef));
        this.myRedoStacksHolder.clearStacks(false, Collections.singleton(docRef));
    }

    public void setEditorProvider(@NotNull CurrentEditorProvider p) {
        this.myEditorProvider = p;
    }

    @NotNull
    public CurrentEditorProvider getEditorProvider() {
        return this.myEditorProvider;
    }

    public void dropHistoryInTests() {
        this.flushMergers();
        LOG.assertTrue(this.myCommandLevel == 0, (Object)this.myCommandLevel);
        this.myUndoStacksHolder.clearAllStacksInTests();
        this.myRedoStacksHolder.clearAllStacksInTests();
    }

    private void flushMergers() {
        assert (this.myProject == null || !this.myProject.isDisposed()) : this.myProject;
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, EmptyRunnable.getInstance(), "Dummy", null);
    }

    public void flushCurrentCommandMerger() {
        this.myMerger.flushCurrentCommand();
    }

    public void clearUndoRedoQueueInTests(@NotNull VirtualFile file2) {
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(file2));
    }

    public void clearUndoRedoQueueInTests(@NotNull Document document) {
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(document));
    }

    public String toString() {
        return "UndoManager for " + ObjectUtils.notNull((Object)this.myProject, (Object)"application");
    }

    private static enum OperationState {
        NONE,
        UNDO,
        REDO;

    }
}

