/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentUndoProvider
implements DocumentListener {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");

    private DocumentUndoProvider() {
    }

    @NotNull
    private static UndoManagerImpl getUndoManager(@Nullable Project project) {
        return (UndoManagerImpl)(project == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project));
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document = e.getDocument();
        if (!DocumentUndoProvider.shouldProcess(document)) {
            return;
        }
        DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(null), document);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(project), document);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(lightEditProject), document);
        }
    }

    private static void handleBeforeDocumentChange(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document) && undoManager.isUndoOrRedoInProgress() && document.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
            throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
        }
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document = e.getDocument();
        if (!DocumentUndoProvider.shouldProcess(document)) {
            return;
        }
        DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(null), document, e);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(project), document, e);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(lightEditProject), document, e);
        }
    }

    private static void handleDocumentChanged(@NotNull UndoManagerImpl undoManager, @NotNull Document document, @NotNull DocumentEvent e) {
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document)) {
            DocumentUndoProvider.registerUndoableAction(undoManager, e);
        } else {
            DocumentUndoProvider.registerNonUndoableAction(undoManager, document);
        }
    }

    private static boolean shouldProcess(@NotNull Document document) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        return !UndoManagerImpl.isCopy(document) && DocumentUndoProvider.shouldRecordActions(document);
    }

    private static boolean shouldRecordActions(@NotNull Document document) {
        if (document.getUserData(UndoConstants.DONT_RECORD_UNDO) == Boolean.TRUE) {
            return false;
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        if (vFile == null) {
            return true;
        }
        return vFile.getUserData(AbstractFileViewProvider.FREE_THREADED) != Boolean.TRUE && vFile.getUserData(UndoConstants.DONT_RECORD_UNDO) != Boolean.TRUE;
    }

    private static void registerUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull DocumentEvent e) {
        undoManager.undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
    }

    private static void registerNonUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
        undoManager.nonundoableActionPerformed(ref, false);
    }

    private static boolean isUndoable(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
        VirtualFile file2 = ref.getFile();
        if (file2 != null && file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE) {
            return true;
        }
        return !UndoManagerImpl.isRefresh() || undoManager.isUndoOrRedoAvailable(ref);
    }
}

