/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByNonlocalVirtualFile;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.impl.FilePath;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DocumentReferenceManagerImpl
extends DocumentReferenceManager {
    private final Map<Document, DocumentReference> myDocToRef = ContainerUtil.createWeakKeyWeakValueMap();
    private static final Key<Reference<DocumentReference>> FILE_TO_REF_KEY = Key.create((String)"FILE_TO_REF_KEY");
    private static final Key<DocumentReference> FILE_TO_STRONG_REF_KEY = Key.create((String)"FILE_TO_STRONG_REF_KEY");
    private final Map<FilePath, DocumentReference> myDeletedFilePathToRef = ContainerUtil.createWeakValueMap();

    DocumentReferenceManagerImpl() {
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                NotNullList deletedFiles = new NotNullList();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    DocumentReferenceManagerImpl.collectDeletedFiles(((VFileDeleteEvent)vFileEvent).getFile(), (List)deletedFiles);
                }
                return new AsyncFileListener.ChangeApplier((List)deletedFiles, events){
                    final /* synthetic */ List val$deletedFiles;
                    final /* synthetic */ List val$events;
                    {
                        this.val$deletedFiles = list2;
                        this.val$events = list3;
                    }

                    public void afterVfsChange() {
                        for (VirtualFile each : this.val$deletedFiles) {
                            this.fileDeleted(each);
                        }
                        for (VFileEvent event : this.val$events) {
                            if (!(event instanceof VFileCreateEvent)) continue;
                            this.fileCreated((VFileCreateEvent)event);
                        }
                    }
                };
            }

            private void fileDeleted(VirtualFile each) {
                DocumentReference ref = (DocumentReference)SoftReference.dereference((Reference)((Reference)each.getUserData(FILE_TO_REF_KEY)));
                each.putUserData(FILE_TO_REF_KEY, null);
                if (ref != null) {
                    DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.put(new FilePath(each.getUrl()), ref);
                }
            }

            private void fileCreated(@NotNull VFileCreateEvent event) {
                DocumentReference ref;
                VirtualFile f = event.getFile();
                DocumentReference documentReference = ref = f == null ? null : (DocumentReference)DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.remove(new FilePath(f.getUrl()));
                if (ref != null) {
                    f.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(ref));
                    ((DocumentReferenceByVirtualFile)ref).update(f);
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private static void collectDeletedFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> files2) {
        if (!(f instanceof NewVirtualFile)) {
            return;
        }
        ProgressManager.checkCanceled();
        if (!f.isDirectory()) {
            files2.add(f);
        } else {
            for (VirtualFile each : ((NewVirtualFile)f).iterInDbChildren()) {
                DocumentReferenceManagerImpl.collectDeletedFiles(each, files2);
            }
        }
    }

    @NotNull
    public DocumentReference create(@NotNull Document document) {
        DocumentReferenceManagerImpl.assertIsWriteThread();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return file2 == null ? this.createFromDocument(document) : this.create(file2);
    }

    @NotNull
    private DocumentReference createFromDocument(@NotNull Document document) {
        DocumentReference result2 = this.myDocToRef.get(document);
        if (result2 == null) {
            result2 = new DocumentReferenceByDocument(document);
            this.myDocToRef.put(document, result2);
        }
        return result2;
    }

    @NotNull
    public DocumentReference create(@NotNull VirtualFile file2) {
        DocumentReferenceManagerImpl.assertIsWriteThread();
        if (!file2.isInLocalFileSystem()) {
            DocumentReference reference2 = (DocumentReference)file2.getUserData(FILE_TO_STRONG_REF_KEY);
            if (reference2 == null) {
                reference2 = new DocumentReferenceByNonlocalVirtualFile(file2);
                file2.putUserData(FILE_TO_STRONG_REF_KEY, (Object)reference2);
            }
            return reference2;
        }
        assert (file2.isValid()) : "file is invalid: " + file2;
        DocumentReference result2 = (DocumentReference)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_TO_REF_KEY)));
        if (result2 == null) {
            result2 = new DocumentReferenceByVirtualFile(file2);
            file2.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(result2));
        }
        return result2;
    }

    private static void assertIsWriteThread() {
        ApplicationManager.getApplication().assertIsWriteThread();
    }

    public void cleanupForNextTest() {
        this.myDeletedFilePathToRef.clear();
        this.myDocToRef.clear();
    }
}

