/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CannotUndoReportDialog
extends DialogWrapper
implements DataProvider {
    private static final int FILE_TEXT_PREVIEW_CHARS_LIMIT = 40;
    private final Project myProject;
    private JList<DocumentReference> myProblemFilesList;
    private JPanel myPanel;
    private JLabel myProblemMessageLabel;

    public CannotUndoReportDialog(Project project, @Nls String problemText, Collection<? extends DocumentReference> files2) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        DefaultListModel<DocumentReference> model = new DefaultListModel<DocumentReference>();
        for (DocumentReference documentReference : files2) {
            model.addElement(documentReference);
        }
        this.myProblemFilesList.setCellRenderer((ListCellRenderer<DocumentReference>)new SimpleListCellRenderer<DocumentReference>(){

            public void customize(@NotNull JList<? extends DocumentReference> list2, DocumentReference file2, int index, boolean selected2, boolean hasFocus) {
                VirtualFile vFile = file2.getFile();
                if (vFile != null) {
                    this.setText(vFile.getPresentableUrl());
                } else {
                    CharSequence content2;
                    Document document = file2.getDocument();
                    CharSequence charSequence = content2 = document == null ? null : document.getImmutableCharSequence();
                    if (content2 != null && content2.length() > 40) {
                        content2 = content2.subSequence(0, 40) + "...";
                    }
                    this.setText(IdeBundle.message((String)"list.item.temporary.file.0", (Object[])new Object[]{content2 == null ? "" : " [" + content2 + "]"}));
                }
            }
        });
        this.myProblemFilesList.setModel(model);
        EditSourceOnDoubleClickHandler.install(this.myProblemFilesList, () -> this.doOKAction());
        EditSourceOnEnterKeyHandler.install(this.myProblemFilesList, () -> this.doOKAction());
        this.setTitle(IdeBundle.message((String)"cannot.undo.title", (Object[])new Object[0]));
        this.myProblemMessageLabel.setText(problemText);
        this.myProblemMessageLabel.setIcon(Messages.getErrorIcon());
        this.init();
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction()};
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file2;
            DocumentReference value2 = this.myProblemFilesList.getSelectedValue();
            VirtualFile virtualFile = file2 = value2 != null ? value2.getFile() : null;
            if (file2 != null) {
                return new OpenFileDescriptor(this.myProject, file2);
            }
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProblemMessageLabel = jLabel = new JLabel();
        jLabel.setText("%%Cannot undo reason%");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IdeBundle", CannotUndoReportDialog.class).getString("border.title.problem.files"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myProblemFilesList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

