/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.constraints.BaseConstrainedExecution;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.AsyncExecutionServiceImpl;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.SubmissionTracker;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.RunnableCallable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public class NonBlockingReadActionImpl<T>
implements NonBlockingReadAction<T> {
    private static final Logger LOG = Logger.getInstance(NonBlockingReadActionImpl.class);
    private static final Executor SYNC_DUMMY_EXECUTOR = __ -> {
        throw new UnsupportedOperationException();
    };
    @Nullable
    private final Pair<ModalityState, Consumer<T>> myEdtFinish;
    private final ConstrainedExecution.ContextConstraint @NotNull [] myConstraints;
    private final BooleanSupplier @NotNull [] myCancellationConditions;
    private final Set<? extends Disposable> myDisposables;
    @Nullable
    private final List<Object> myCoalesceEquality;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    private final Callable<T> myComputation;
    private static final Set<Submission> ourTasks = ContainerUtil.newConcurrentSet();
    private static final Map<List<Object>, Submission> ourTasksByEquality = new HashMap<List<Object>, Submission>();
    private static final SubmissionTracker ourUnboundedSubmissionTracker = new SubmissionTracker();

    NonBlockingReadActionImpl(@NotNull Callable<T> computation) {
        this(computation, null, new ConstrainedExecution.ContextConstraint[0], new BooleanSupplier[0], Collections.emptySet(), null, null);
    }

    private NonBlockingReadActionImpl(@NotNull Callable<T> computation, @Nullable Pair<ModalityState, Consumer<T>> edtFinish, ConstrainedExecution.ContextConstraint @NotNull [] constraints2, BooleanSupplier @NotNull [] cancellationConditions, @NotNull Set<? extends Disposable> disposables, @Nullable List<Object> coalesceEquality, @Nullable ProgressIndicator progressIndicator2) {
        this.myComputation = computation;
        this.myEdtFinish = edtFinish;
        this.myConstraints = constraints2;
        this.myCancellationConditions = cancellationConditions;
        this.myDisposables = disposables;
        this.myCoalesceEquality = coalesceEquality;
        this.myProgressIndicator = progressIndicator2;
    }

    private NonBlockingReadActionImpl<T> withConstraint(ConstrainedExecution.ContextConstraint constraint) {
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, (ConstrainedExecution.ContextConstraint[])ArrayUtil.append((Object[])this.myConstraints, (Object)constraint), this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    private static void invokeLater(@NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(runnable2, ModalityState.any());
    }

    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        return this.withConstraint(new InSmartMode(project)).expireWith((Disposable)project);
    }

    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project) {
        return this.withConstraint(new WithDocumentsCommitted(project, ModalityState.any())).expireWith((Disposable)project);
    }

    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.myConstraints, (BooleanSupplier[])ArrayUtil.append((Object[])this.myCancellationConditions, (Object)expireCondition), this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> expireWith(@NotNull Disposable parentDisposable) {
        HashSet<? extends Disposable> disposables = new HashSet<Disposable>(this.myDisposables);
        disposables.add((Disposable)parentDisposable);
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.myConstraints, this.myCancellationConditions, disposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    public NonBlockingReadAction<T> wrapProgress(@NotNull ProgressIndicator progressIndicator2) {
        LOG.assertTrue(this.myProgressIndicator == null, (Object)"Unspecified behaviour. Outer progress indicator is already set for the action.");
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, progressIndicator2);
    }

    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<T> uiThreadAction) {
        return new NonBlockingReadActionImpl<T>(this.myComputation, Pair.create((Object)modality, uiThreadAction), this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    public NonBlockingReadAction<T> coalesceBy(Object ... equality) {
        if (this.myCoalesceEquality != null) {
            throw new IllegalStateException("Setting equality twice is not allowed");
        }
        if (equality.length == 0) {
            throw new IllegalArgumentException("Equality should include at least one object");
        }
        if (equality.length == 1 && NonBlockingReadActionImpl.isTooCommon(equality[0])) {
            throw new IllegalArgumentException("Equality should be unique: passing " + equality[0] + " is likely to interfere with unrelated computations from different places");
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.myConstraints, this.myCancellationConditions, this.myDisposables, ContainerUtil.newArrayList((Object[])equality), this.myProgressIndicator);
    }

    private static boolean isTooCommon(Object o) {
        return o instanceof Project || o instanceof PsiElement || o instanceof Document || o instanceof VirtualFile || o instanceof Editor || o instanceof FileEditor || o instanceof Class || o instanceof KClass || o instanceof String || o == null;
    }

    public T executeSynchronously() throws ProcessCanceledException {
        if (this.myEdtFinish != null || this.myCoalesceEquality != null) {
            throw new IllegalStateException((this.myEdtFinish != null ? "finishOnUiThread" : "coalesceBy") + " is not supported with synchronous non-blocking read actions");
        }
        ProgressIndicator outerIndicator = this.myProgressIndicator != null ? this.myProgressIndicator : ProgressIndicatorProvider.getGlobalProgressIndicator();
        return new Submission(SYNC_DUMMY_EXECUTOR, outerIndicator).executeSynchronously();
    }

    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        Submission submission = new Submission(backgroundThreadExecutor, this.myProgressIndicator);
        if (this.myCoalesceEquality == null) {
            submission.transferToBgThread();
        } else {
            submission.submitOrScheduleCoalesced(this.myCoalesceEquality);
        }
        return submission;
    }

    public static void waitForAsyncTaskCompletion() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        for (Submission task2 : ourTasks) {
            NonBlockingReadActionImpl.waitForTask(task2);
        }
    }

    private static void waitForTask(@NotNull Submission task2) {
        int iteration = 0;
        while (!task2.isDone() && iteration++ < 60000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task2.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task2.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)("Too long async task " + (Object)((Object)task2)));
        }
    }

    static Map<List<Object>, Submission> getTasksByEquality() {
        return ourTasksByEquality;
    }

    private class Submission
    extends AsyncPromise<T> {
        @NotNull
        private final Executor backendExecutor;
        @Nullable
        private final String myStartTrace;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality = ModalityState.defaultModalityState();
        @Nullable
        private Submission myReplacement;
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        private int myUseCount;
        private final AtomicBoolean myCleaned = new AtomicBoolean();
        private final List<Disposable> myExpirationDisposables = new ArrayList<Disposable>();

        Submission(@Nullable Executor backgroundThreadExecutor, ProgressIndicator outerIndicator) {
            this.backendExecutor = backgroundThreadExecutor;
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.acquire();
            }
            this.myProgressIndicator = outerIndicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating " + (Object)((Object)this));
            }
            String string = this.myStartTrace = this.hasUnboundedExecutor() ? ourUnboundedSubmissionTracker.preventTooManySubmissions() : null;
            if (this.shouldTrackInTests()) {
                ourTasks.add(this);
            }
            if (!NonBlockingReadActionImpl.this.myDisposables.isEmpty()) {
                ReadAction.run(() -> this.expireWithDisposables(NonBlockingReadActionImpl.this.myDisposables));
            }
        }

        private void expireWithDisposables(Set<? extends Disposable> disposables) {
            for (Disposable disposable2 : disposables) {
                Disposable parentDisposable;
                if (disposable2 instanceof Project ? ((Project)disposable2).isDisposed() : Disposer.isDisposed((Disposable)disposable2)) {
                    this.cancel();
                    break;
                }
                Disposable child2 = new Disposable(){

                    public void dispose() {
                        Submission.this.cancel();
                    }
                };
                Disposable disposable3 = parentDisposable = disposable2 instanceof ProjectImpl && ((ProjectEx)disposable2).isLight() ? ((ProjectImpl)disposable2).getEarlyDisposable() : disposable2;
                if (!Disposer.tryRegister((Disposable)parentDisposable, (Disposable)child2)) {
                    this.cancel();
                    break;
                }
                this.myExpirationDisposables.add(child2);
            }
        }

        private boolean shouldTrackInTests() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR && ApplicationManager.getApplication().isUnitTestMode();
        }

        private boolean hasUnboundedExecutor() {
            return this.backendExecutor == AppExecutorUtil.getAppExecutorService();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result2 = super.cancel(mayInterruptIfRunning);
            this.cleanupIfNeeded();
            return result2;
        }

        public void setResult(@Nullable T t) {
            super.setResult(t);
            this.cleanupIfNeeded();
        }

        public boolean setError(@NotNull Throwable error) {
            boolean result2 = super.setError(error);
            this.cleanupIfNeeded();
            return result2;
        }

        protected boolean shouldLogErrors() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR;
        }

        private void cleanupIfNeeded() {
            if (this.myCleaned.compareAndSet(false, true)) {
                this.cleanup();
            }
        }

        private void cleanup() {
            ProgressIndicator indicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cleaning " + (Object)((Object)this));
            }
            if ((indicator = this.currentIndicator) != null) {
                indicator.cancel();
            }
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.release();
            }
            for (Disposable disposable2 : this.myExpirationDisposables) {
                Disposer.dispose((Disposable)disposable2);
            }
            if (this.hasUnboundedExecutor()) {
                ourUnboundedSubmissionTracker.unregisterSubmission(this.myStartTrace);
            }
            if (this.shouldTrackInTests()) {
                ourTasks.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire() {
            assert (NonBlockingReadActionImpl.this.myCoalesceEquality != null);
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                ++this.myUseCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            assert (NonBlockingReadActionImpl.this.myCoalesceEquality != null);
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                if (--this.myUseCount == 0 && ourTasksByEquality.get(NonBlockingReadActionImpl.this.myCoalesceEquality) == this) {
                    this.scheduleReplacementIfAny();
                }
            }
        }

        private void scheduleReplacementIfAny() {
            if (this.myReplacement == null || this.myReplacement.isDone()) {
                ourTasksByEquality.remove(NonBlockingReadActionImpl.this.myCoalesceEquality, (Object)this);
            } else {
                ourTasksByEquality.put(NonBlockingReadActionImpl.this.myCoalesceEquality, this.myReplacement);
                this.myReplacement.transferToBgThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitOrScheduleCoalesced(@NotNull List<Object> coalesceEquality) {
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                if (this.isDone()) {
                    return;
                }
                Submission current2 = (Submission)((Object)ourTasksByEquality.get(coalesceEquality));
                if (current2 == null) {
                    ourTasksByEquality.put(coalesceEquality, this);
                    this.transferToBgThread();
                } else {
                    if (!current2.getComputationOrigin().equals(this.getComputationOrigin())) {
                        this.reportCoalescingConflict(current2);
                    }
                    if (current2.myReplacement != null) {
                        current2.myReplacement.cancel();
                        assert (current2 == ourTasksByEquality.get(coalesceEquality));
                    }
                    current2.myReplacement = this;
                    current2.cancel();
                }
            }
        }

        private void reportCoalescingConflict(Submission current2) {
            ourTasks.remove((Object)this);
            LOG.error("Same coalesceBy arguments are already used by " + current2.getComputationOrigin() + " so they can cancel each other. Please make them more unique.");
        }

        @NotNull
        private String getComputationOrigin() {
            String name;
            int dollars;
            Object computation = NonBlockingReadActionImpl.this.myComputation;
            if (computation instanceof RunnableCallable) {
                computation = ((RunnableCallable)computation).getDelegate();
            }
            return (dollars = (name = computation.getClass().getName()).indexOf("$$Lambda")) >= 0 ? name.substring(0, dollars) : name;
        }

        void transferToBgThread() {
            ApplicationEx app;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting " + (Object)((Object)this));
            }
            if ((app = ApplicationManagerEx.getApplicationEx()).isWriteActionInProgress() || app.isWriteActionPending()) {
                this.rescheduleLater();
                return;
            }
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.acquire();
            }
            this.backendExecutor.execute(ClientId.decorateRunnable(() -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running in background " + (Object)((Object)this));
                }
                try {
                    if (!this.attemptComputation()) {
                        this.rescheduleLater();
                    }
                }
                finally {
                    if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                        this.release();
                    }
                }
            }));
        }

        T executeSynchronously() {
            do {
                this.attemptComputation();
                if (this.isCancelled()) {
                    throw new ProcessCanceledException();
                }
                if (this.isDone()) {
                    try {
                        return this.blockingGet(0, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }
                Semaphore semaphore = new Semaphore(1);
                NonBlockingReadActionImpl.invokeLater(() -> {
                    if (this.checkObsolete()) {
                        semaphore.up();
                    } else {
                        BaseConstrainedExecution.scheduleWithinConstraints(() -> ((Semaphore)semaphore).up(), null, NonBlockingReadActionImpl.this.myConstraints);
                    }
                });
                ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, this.myProgressIndicator);
            } while (!this.isCancelled());
            throw new ProcessCanceledException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attemptComputation() {
            SensitiveProgressWrapper indicator;
            SensitiveProgressWrapper sensitiveProgressWrapper = indicator = this.myProgressIndicator != null ? new SensitiveProgressWrapper(this.myProgressIndicator){

                @Override
                @NotNull
                public ModalityState getModalityState() {
                    return Submission.this.creationModality;
                }
            } : new EmptyProgressIndicator(this.creationModality);
            if (this.myProgressIndicator != null) {
                indicator.setIndeterminate(this.myProgressIndicator.isIndeterminate());
            }
            this.currentIndicator = indicator;
            try {
                boolean success;
                Ref unsatisfiedConstraint = Ref.create();
                Runnable runnable2 = () -> this.insideReadAction(indicator, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    runnable2.run();
                    success = true;
                    if (!unsatisfiedConstraint.isNull()) {
                        throw new IllegalStateException("Constraint " + unsatisfiedConstraint + " cannot be satisfied");
                    }
                } else {
                    if (this.myProgressIndicator != null) {
                        try {
                            this.myProgressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException e) {
                            boolean bl = false;
                            this.currentIndicator = null;
                            return bl;
                        }
                    }
                    success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(runnable2, indicator);
                }
                boolean bl = success && unsatisfiedConstraint.isNull();
                return bl;
            }
            finally {
                this.currentIndicator = null;
            }
        }

        private void rescheduleLater() {
            if (Promises.isPending((Promise)this)) {
                NonBlockingReadActionImpl.invokeLater(() -> this.reschedule());
            }
        }

        private void reschedule() {
            if (!this.checkObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rescheduling " + (Object)((Object)this));
                }
                BaseConstrainedExecution.scheduleWithinConstraints(() -> this.transferToBgThread(), null, NonBlockingReadActionImpl.this.myConstraints);
            }
        }

        private void insideReadAction(ProgressIndicator indicator, Ref<ConstrainedExecution.ContextConstraint> outUnsatisfiedConstraint) {
            try {
                if (this.checkObsolete()) {
                    return;
                }
                ConstrainedExecution.ContextConstraint constraint = (ConstrainedExecution.ContextConstraint)ContainerUtil.find((Object[])NonBlockingReadActionImpl.this.myConstraints, t -> !t.isCorrectContext());
                if (constraint != null) {
                    outUnsatisfiedConstraint.set((Object)constraint);
                    return;
                }
                Object result2 = NonBlockingReadActionImpl.this.myComputation.call();
                if (NonBlockingReadActionImpl.this.myEdtFinish != null) {
                    this.safeTransferToEdt(result2, NonBlockingReadActionImpl.this.myEdtFinish);
                } else {
                    this.setResult(result2);
                }
            }
            catch (ServiceNotReadyException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                if (!indicator.isCanceled()) {
                    this.setError(e);
                }
                throw e;
            }
            catch (Throwable e) {
                this.setError(e);
            }
        }

        private boolean checkObsolete() {
            if (Promises.isRejected((Promise)this)) {
                return true;
            }
            for (BooleanSupplier condition : NonBlockingReadActionImpl.this.myCancellationConditions) {
                if (!condition.getAsBoolean()) continue;
                this.cancel();
                return true;
            }
            if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                this.cancel();
                return true;
            }
            return false;
        }

        private void safeTransferToEdt(T result2, Pair<? extends ModalityState, ? extends Consumer<T>> edtFinish) {
            if (Promises.isRejected((Promise)this)) {
                return;
            }
            long stamp = AsyncExecutionServiceImpl.getWriteActionCounter();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (stamp != AsyncExecutionServiceImpl.getWriteActionCounter()) {
                    this.reschedule();
                    return;
                }
                if (this.checkObsolete()) {
                    return;
                }
                this.setResult(result2);
                if (this.isSucceeded()) {
                    ((Consumer)edtFinish.second).accept(result2);
                }
            }, (ModalityState)edtFinish.first);
        }

        public String toString() {
            return "Submission{" + NonBlockingReadActionImpl.this.myComputation + ", " + this.getState() + "}";
        }
    }
}

