/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        Ref result2 = new Ref();
        ApplicationUtil.tryRunReadAction(() -> result2.set(computable.compute()));
        return (T)result2.get();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw CannotRunReadActionException.create();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        Ref result2 = Ref.create();
        Ref error = Ref.create();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                result2.set(callable.call());
            }
            catch (Throwable t) {
                error.set((Object)t);
            }
        }, indicator));
        try {
            ApplicationUtil.runWithCheckCanceled(future2, indicator);
            ExceptionUtil.rethrowAll((Throwable)((Throwable)error.get()));
        }
        catch (ProcessCanceledException e) {
            future2.cancel(false);
            throw e;
        }
        return (T)result2.get();
    }

    public static <T> T runWithCheckCanceled(@NotNull Future<T> future2, @NotNull ProgressIndicator indicator) throws ExecutionException {
        while (true) {
            indicator.checkCanceled();
            try {
                return future2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static void showDialogAfterWriteAction(@NotNull Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            application.invokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static void invokeLaterSomewhere(@NotNull Runnable r, @NotNull EdtReplacementThread thread) {
        ApplicationUtil.invokeLaterSomewhere(r, thread, ApplicationManager.getApplication().getDefaultModalityState());
    }

    public static void invokeLaterSomewhere(@NotNull Runnable r, @NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState) {
        switch (thread) {
            case EDT: {
                SwingUtilities.invokeLater(r);
                break;
            }
            case WT: {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(r, modalityState);
                break;
            }
            case EDT_WITH_IW: {
                ApplicationManager.getApplication().invokeLater(r, modalityState);
            }
        }
    }

    public static void invokeAndWaitSomewhere(Runnable runnable2, EdtReplacementThread thread) {
        ApplicationUtil.invokeAndWaitSomewhere(runnable2, thread, ApplicationManager.getApplication().getDefaultModalityState());
    }

    public static void invokeAndWaitSomewhere(@NotNull Runnable r, @NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState) {
        switch (thread) {
            case EDT: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                UIUtil.invokeAndWaitIfNeeded((Runnable)r);
                break;
            }
            case WT: {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    r.run();
                    break;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from EDT to WT");
                    break;
                }
                Semaphore s = new Semaphore(1);
                AtomicReference throwable = new AtomicReference();
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        throwable.set(t);
                    }
                    finally {
                        s.up();
                    }
                }, modalityState);
                s.waitFor();
                if (throwable.get() == null) break;
                ExceptionUtil.rethrow((Throwable)((Throwable)throwable.get()));
                break;
            }
            case EDT_WITH_IW: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                ApplicationManager.getApplication().invokeAndWait(r, modalityState);
            }
        }
    }

    public static class CannotRunReadActionException
    extends ProcessCanceledException {
        public static CannotRunReadActionException create() {
            return new CannotRunReadActionException();
        }

        private CannotRunReadActionException() {
        }
    }
}

