/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeDirectoriesInfo
implements Comparable<IdeDirectoriesInfo> {
    private final String mySelector;
    private final DirectoryInfo myTopLevelDirectory;
    private final List<DirectoryInfo> mySubDirectories;

    public IdeDirectoriesInfo(@NotNull String selector, @NotNull String topLevelDescriptor, @Nullable Path topLevelDirectory) {
        this.mySelector = selector;
        this.myTopLevelDirectory = new DirectoryInfo(topLevelDescriptor, topLevelDirectory);
        this.mySubDirectories = new ArrayList<DirectoryInfo>();
    }

    public String getSelector() {
        return this.mySelector;
    }

    public DirectoryInfo getTopLevelDirectory() {
        return this.myTopLevelDirectory;
    }

    public List<DirectoryInfo> getSubDirectories() {
        return this.mySubDirectories;
    }

    public void addSubDirectory(@NotNull String descriptor2, @NotNull Path directory) {
        this.mySubDirectories.add(new DirectoryInfo(descriptor2, directory));
    }

    @Override
    public int compareTo(@NotNull IdeDirectoriesInfo o) {
        return this.mySelector.compareTo(o.mySelector);
    }

    public Path findHomeLocatorFile() {
        for (DirectoryInfo dirInfo : this.getSubDirectories()) {
            Path dir = dirInfo.getDirectory();
            Path file2 = dir.resolve(".home");
            if (!Files.isRegularFile(file2, new LinkOption[0])) continue;
            return file2;
        }
        return null;
    }

    public Path findIdeaLogFile() {
        for (DirectoryInfo dirInfo : this.getSubDirectories()) {
            Path dir = dirInfo.getDirectory();
            Path file2 = dir.resolve("idea.log");
            if (Files.isRegularFile(file2, new LinkOption[0])) {
                return file2;
            }
            file2 = dir.resolve("log").resolve("idea.log");
            if (!Files.isRegularFile(file2, new LinkOption[0])) continue;
            return file2;
        }
        return null;
    }

    public Instant calculateLastUsedTime() {
        Stream<Path> directories = Stream.concat(Stream.of(this.getTopLevelDirectory().getDirectory()), this.getSubDirectories().stream().map(dirInfo -> dirInfo.getDirectory()));
        Stream<Path> specificFiles = Stream.of(this.findHomeLocatorFile(), this.findIdeaLogFile());
        List paths = Stream.concat(directories, specificFiles).filter(path -> path != null).collect(Collectors.toList());
        Instant lastUsedTime = Instant.MIN;
        for (Path path2 : paths) {
            Instant lastModifiedTime = Instant.MIN;
            try {
                lastModifiedTime = Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant();
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            if (lastModifiedTime.compareTo(lastUsedTime) <= 0) continue;
            lastUsedTime = lastModifiedTime;
        }
        return lastUsedTime;
    }

    public static class DirectoryInfo {
        private String myDescriptor;
        private Path myDirectory;

        public DirectoryInfo(@NotNull String descriptor2, @Nullable Path directory) {
            this.myDescriptor = descriptor2;
            this.myDirectory = directory;
        }

        public String getDescriptor() {
            return this.myDescriptor;
        }

        public Path getDirectory() {
            return this.myDirectory;
        }
    }
}

