/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeDirectoriesInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.sun.jna.platform.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;

public class DeleteOldDirectoriesDialog
extends JDialog {
    private JPanel myTopLevelPanel;
    private JLabel myFoundUnusedLabel;
    private JPanel myTableUIPanel;
    private AsyncProcessIcon myBusyAnimationIcon;
    private JButton myDeleteButton;
    private JButton myCancelButton;
    private List<IdeDirectoriesInfo> myDirsInfoList;
    private JCheckBox myAggregateCheckBox;
    private List<JCheckBox> myCheckBoxList;
    private List<JLabel> myLastUsedLabelList;
    private List<JLabel> mySizeLabelList;
    private List<SwingWorker> mySizeCalculationWorkers;
    private SwingWorker myDeletionWorker;

    public DeleteOldDirectoriesDialog(List<IdeDirectoriesInfo> dirsInfoList) {
        this.$$$setupUI$$$();
        this.setLabelTexts();
        this.createTableUI(dirsInfoList);
        this.setLastUsedLabels();
        this.addListeners();
        this.setDialogProperties();
        this.runSizeCalculationWorkers();
    }

    private void createUIComponents() {
        this.myBusyAnimationIcon = new AsyncProcessIcon("delete old directories");
        this.myBusyAnimationIcon.setVisible(false);
    }

    private void setLabelTexts() {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.myFoundUnusedLabel.setText(DeleteOldDirectoriesDialog.html(String.format("The directories below contain configuration and system files for unused versions of %s. Check the box next to each directory you want to safely delete.", productName)));
        DeleteOldDirectoriesDialog.setPreferredSize(this.myFoundUnusedLabel, 600, 2);
    }

    private static String html(String text) {
        return "<html><body><p style=\"margin-top: 0\">" + text + "</p></body></html>";
    }

    private static String bold(String text) {
        return "<b>" + text + "</b>";
    }

    private static String linebreak(String text) {
        return text.replace("\n", "<br>");
    }

    private static void setPreferredSize(JComponent component2, int width, int numberOfLines) {
        int lineHeight = component2.getFontMetrics(component2.getFont()).getHeight();
        component2.setPreferredSize(new Dimension(width, numberOfLines * lineHeight));
    }

    private void createTableUI(List<IdeDirectoriesInfo> dirsInfoList) {
        this.myDirsInfoList = dirsInfoList;
        int size = this.myDirsInfoList.size();
        this.myCheckBoxList = new ArrayList<JCheckBox>(size);
        this.myLastUsedLabelList = new ArrayList<JLabel>(size);
        this.mySizeLabelList = new ArrayList<JLabel>(size);
        int rowCount = this.myDirsInfoList.size() + 1;
        int columnCount = 5;
        this.myTableUIPanel.setLayout((LayoutManager)new GridLayoutManager(rowCount, 5));
        GridConstraints constraints2 = new GridConstraints();
        constraints2.setAnchor(8);
        constraints2.setFill(0);
        constraints2.setHSizePolicy(0);
        constraints2.setVSizePolicy(0);
        this.myAggregateCheckBox = new JCheckBox();
        constraints2.setRow(0);
        constraints2.setColumn(0);
        this.myTableUIPanel.add((Component)this.myAggregateCheckBox, constraints2);
        JLabel directoryTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold("Directory")), 10);
        DeleteOldDirectoriesDialog.setPreferredSize(directoryTitle, 270, 1);
        constraints2.setRow(0);
        constraints2.setColumn(1);
        this.myTableUIPanel.add((Component)directoryTitle, constraints2);
        JLabel lastUsedTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold("Last Used")), 10);
        DeleteOldDirectoriesDialog.setPreferredSize(lastUsedTitle, 100, 1);
        constraints2.setRow(0);
        constraints2.setColumn(2);
        this.myTableUIPanel.add((Component)lastUsedTitle, constraints2);
        JLabel sizeTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold("Size")), 11);
        DeleteOldDirectoriesDialog.setPreferredSize(sizeTitle, 90, 1);
        constraints2.setRow(0);
        constraints2.setColumn(3);
        this.myTableUIPanel.add((Component)sizeTitle, constraints2);
        for (int i2 = 0; i2 < size; ++i2) {
            IdeDirectoriesInfo dirsInfo = this.myDirsInfoList.get(i2);
            int row = i2 + 1;
            final JCheckBox checkBox2 = new JCheckBox();
            this.myCheckBoxList.add(checkBox2);
            constraints2.setRow(row);
            constraints2.setColumn(0);
            this.myTableUIPanel.add((Component)checkBox2, constraints2);
            JLabel directoryLabel = new JLabel(dirsInfo.getTopLevelDirectory().getDescriptor(), 10);
            DeleteOldDirectoriesDialog.setPreferredSize(directoryLabel, 270, 1);
            DeleteOldDirectoriesDialog.setDirectoryLabelToolTip(directoryLabel, dirsInfo);
            constraints2.setRow(row);
            constraints2.setColumn(1);
            this.myTableUIPanel.add((Component)directoryLabel, constraints2);
            directoryLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (checkBox2.isEnabled()) {
                        checkBox2.setSelected(!checkBox2.isSelected());
                    }
                }
            });
            JLabel lastUsedLabel = new JLabel("", 10);
            DeleteOldDirectoriesDialog.setPreferredSize(lastUsedLabel, 100, 1);
            this.myLastUsedLabelList.add(lastUsedLabel);
            constraints2.setRow(row);
            constraints2.setColumn(2);
            this.myTableUIPanel.add((Component)lastUsedLabel, constraints2);
            JLabel sizeLabel = new JLabel("", 11);
            DeleteOldDirectoriesDialog.setPreferredSize(sizeLabel, 90, 1);
            this.mySizeLabelList.add(sizeLabel);
            constraints2.setRow(row);
            constraints2.setColumn(3);
            this.myTableUIPanel.add((Component)sizeLabel, constraints2);
        }
        GridConstraints spacerConstraints = new GridConstraints();
        spacerConstraints.setRow(0);
        spacerConstraints.setColumn(4);
        spacerConstraints.setRowSpan(size);
        spacerConstraints.setFill(1);
        spacerConstraints.setHSizePolicy(6);
        spacerConstraints.setVSizePolicy(0);
        this.myTableUIPanel.add((Component)new Spacer(), spacerConstraints);
    }

    private static void setDirectoryLabelToolTip(JLabel directoryLabel, IdeDirectoriesInfo dirsInfo) {
        String toolTip = dirsInfo.getTopLevelDirectory().getDirectory() != null ? dirsInfo.getTopLevelDirectory().getDirectory().toString() : dirsInfo.getSubDirectories().stream().map(dirInfo -> dirInfo.getDirectory().toString()).collect(Collectors.joining("\n"));
        directoryLabel.setToolTipText(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.linebreak(toolTip)));
    }

    private void setLastUsedLabels() {
        LocalDate today = LocalDate.now();
        for (int i2 = 0; i2 < this.myDirsInfoList.size(); ++i2) {
            Instant lastUsedTime = this.myDirsInfoList.get(i2).calculateLastUsedTime();
            LocalDate lastUsedDate = LocalDateTime.ofInstant(lastUsedTime, ZoneId.systemDefault()).toLocalDate();
            Period periodSinceLastUsed = Period.between(lastUsedDate, today);
            this.myLastUsedLabelList.get(i2).setText(DeleteOldDirectoriesDialog.formatPeriod(periodSinceLastUsed));
        }
    }

    private static String formatPeriod(Period period) {
        int days;
        int months = 12 * period.getYears() + period.getMonths();
        int weeks = months == 0 ? period.getDays() / 7 : 0;
        int n = days = months == 0 ? period.getDays() % 7 : 0;
        if (months > 0) {
            return months > 300 ? "Never" : (months > 1 ? String.format("%d months ago", months) : String.format("%d month ago", months));
        }
        if (weeks > 0) {
            return weeks > 1 ? String.format("%d weeks ago", weeks) : String.format("%d week ago", weeks);
        }
        if (days > 0) {
            return days > 1 ? String.format("%d days ago", days) : "Yesterday";
        }
        return "Today";
    }

    private void addListeners() {
        this.myAggregateCheckBox.addItemListener(this::aggregateCheckBoxStateChanged);
        this.myCheckBoxList.forEach(cb -> cb.addItemListener(this::individualCheckBoxStateChanged));
        this.myDeleteButton.addActionListener(e -> this.onDelete());
        this.myCancelButton.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeleteOldDirectoriesDialog.this.onCancel();
            }
        });
        this.myTopLevelPanel.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void aggregateCheckBoxStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.myCheckBoxList.forEach(cb -> cb.setSelected(true));
        } else {
            this.myCheckBoxList.forEach(cb -> cb.setSelected(false));
        }
    }

    private void individualCheckBoxStateChanged(ItemEvent e) {
        long selectedCount = this.myCheckBoxList.stream().filter(cb -> cb.isSelected()).count();
        if (selectedCount == (long)this.myCheckBoxList.size()) {
            this.myAggregateCheckBox.setSelected(true);
        } else if (selectedCount == 0L) {
            this.myAggregateCheckBox.setSelected(false);
        }
    }

    private void setDialogProperties() {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setTitle(String.format("Delete Unused %s Directories", productName));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myTopLevelPanel);
        this.getRootPane().setDefaultButton(this.myDeleteButton);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void onDelete() {
        this.myAggregateCheckBox.setEnabled(false);
        this.myCheckBoxList.forEach(cb -> cb.setEnabled(false));
        this.myDeleteButton.setEnabled(false);
        this.myBusyAnimationIcon.setVisible(true);
        this.cancelSizeCalculationWorkers();
        this.runDeletionWorker();
    }

    private void onCancel() {
        this.cancelSizeCalculationWorkers();
        this.cancelDeletionWorker();
        this.close();
    }

    private void close() {
        if (this.myBusyAnimationIcon != null) {
            this.myBusyAnimationIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myBusyAnimationIcon);
            this.myBusyAnimationIcon = null;
        }
        this.dispose();
    }

    private void runSizeCalculationWorkers() {
        int size = this.myDirsInfoList.size();
        this.mySizeCalculationWorkers = new ArrayList<SwingWorker>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            IdeDirectoriesInfo dirsInfo = this.myDirsInfoList.get(i2);
            JLabel sizeLabel = this.mySizeLabelList.get(i2);
            Iterable directories = dirsInfo.getSubDirectories().stream().map(subDir -> subDir.getDirectory()).collect(Collectors.toList());
            this.mySizeCalculationWorkers.add(new SizeCalculationWorker(directories, sizeLabel));
        }
        this.mySizeCalculationWorkers.forEach(worker -> worker.execute());
    }

    private void cancelSizeCalculationWorkers() {
        if (this.mySizeCalculationWorkers != null) {
            this.mySizeCalculationWorkers.forEach(worker -> worker.cancel(true));
        }
    }

    private void runDeletionWorker() {
        ArrayList<IdeDirectoriesInfo> deleteDirsInfoList = new ArrayList<IdeDirectoriesInfo>();
        for (int i2 = 0; i2 < this.myDirsInfoList.size(); ++i2) {
            if (!this.myCheckBoxList.get(i2).isSelected()) continue;
            deleteDirsInfoList.add(this.myDirsInfoList.get(i2));
        }
        this.myDeletionWorker = new DeletionWorker(deleteDirsInfoList);
        this.myDeletionWorker.addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("state") && event.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                this.close();
            }
        });
        this.myDeletionWorker.execute();
    }

    private void cancelDeletionWorker() {
        if (this.myDeletionWorker != null) {
            this.myDeletionWorker.cancel(true);
        }
    }

    private static void deleteDirectory(Path directory) {
        if (directory == null || !directory.isAbsolute() || Files.isSymbolicLink(directory) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try {
            if (FileUtils.getInstance().hasTrash()) {
                FileUtils.getInstance().moveToTrash(new File[]{directory.toFile()});
            } else {
                MoreFiles.deleteRecursively((Path)directory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.createUIComponents();
        this.myTopLevelPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFoundUnusedLabel = jLabel = new JLabel();
        jLabel.setText("The directories below contain configuration and system files for unused versions of {0}. Check the box next to each directory you want to safely delete.");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 10), null));
        this.myTableUIPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(18, 18), new Dimension(18, 18)));
        AsyncProcessIcon asyncProcessIcon = this.myBusyAnimationIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        jButton2.setMargin(new Insets(2, 10, 2, 10));
        jButton2.setText("Skip");
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton = new JButton();
        jButton.setMargin(new Insets(2, 10, 2, 10));
        jButton.setText("Delete Directories");
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopLevelPanel;
    }

    private static class DeletionWorker
    extends SwingWorker<Void, Void> {
        private final List<IdeDirectoriesInfo> myDeleteDirsInfoList;

        public DeletionWorker(@NotNull List<IdeDirectoriesInfo> deleteDirsInfoList) {
            this.myDeleteDirsInfoList = deleteDirsInfoList;
        }

        @Override
        protected Void doInBackground() {
            for (IdeDirectoriesInfo dirsInfo : this.myDeleteDirsInfoList) {
                for (IdeDirectoriesInfo.DirectoryInfo subDirInfo : dirsInfo.getSubDirectories()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    DeleteOldDirectoriesDialog.deleteDirectory(subDirInfo.getDirectory());
                }
                DeleteOldDirectoriesDialog.deleteDirectory(dirsInfo.getTopLevelDirectory().getDirectory());
            }
            return null;
        }
    }

    private static class SizeCalculationWorker
    extends SwingWorker<Long, Long> {
        private final Iterable<Path> myDirectories;
        private final JLabel mySizeLabel;

        public SizeCalculationWorker(Iterable<Path> directories, JLabel sizeLabel) {
            this.myDirectories = directories;
            this.mySizeLabel = sizeLabel;
        }

        @Override
        protected Long doInBackground() throws Exception {
            SizeCalculator sizeCalculator = new SizeCalculator();
            for (Path directory : this.myDirectories) {
                Files.walkFileTree(directory, sizeCalculator);
            }
            return sizeCalculator.getTotalSize();
        }

        @Override
        protected void process(List<Long> chunks) {
            long totalSize = chunks.get(chunks.size() - 1);
            this.mySizeLabel.setText(SizeCalculationWorker.formatSize(totalSize));
        }

        @Override
        protected void done() {
            try {
                long totalSize = (Long)this.get();
                this.mySizeLabel.setText(SizeCalculationWorker.formatSize(totalSize));
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }

        private static String formatSize(long size) {
            if (size <= 0L) {
                return "0 MB";
            }
            if (size <= 0x100000L) {
                return "1 MB";
            }
            return String.format("%d MB", size / 0x100000L);
        }

        private class SizeCalculator
        implements FileVisitor<Path> {
            private long totalSize = 0L;

            private SizeCalculator() {
            }

            public long getTotalSize() {
                return this.totalSize;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                this.totalSize += attrs.size();
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) {
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                SizeCalculationWorker.this.publish(new Long[]{this.totalSize});
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }
        }
    }
}

