/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.CustomConfigMigrationOptionKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0006\u0010\u0006\u001a\u00020\u0007\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "", "()V", "getStringPresentation", "", "toString", "writeConfigMarkerFile", "", "Companion", "MigrateFromCustomPlace", "SetProperties", "StartWithCleanConfig", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "intellij.platform.ide.impl"})
public abstract class CustomConfigMigrationOption {
    private static final String IMPORT_PREFIX = "import ";
    private static final String PROPERTIES_PREFIX = "properties ";
    public static final Companion Companion = new Companion(null);

    public final void writeConfigMarkerFile() {
        Path markerFile2 = Companion.getCustomConfigMarkerFilePath(PathManager.getConfigDir());
        if (PathKt.exists((Path)markerFile2)) {
            CustomConfigMigrationOptionKt.access$getLog$p().error("Marker file " + markerFile2 + " shouldn't exist");
        }
        PathKt.write$default((Path)markerFile2, (CharSequence)this.getStringPresentation(), (boolean)false, (int)2, null);
    }

    @NotNull
    public abstract String getStringPresentation();

    @NotNull
    public String toString() {
        return this.getStringPresentation();
    }

    private CustomConfigMigrationOption() {
    }

    public /* synthetic */ CustomConfigMigrationOption(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @Nullable
    public static final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
        return Companion.readCustomConfigMigrationOptionAndRemoveMarkerFile(configDir);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "()V", "getStringPresentation", "", "toString", "intellij.platform.ide.impl"})
    public static final class StartWithCleanConfig
    extends CustomConfigMigrationOption {
        public static final StartWithCleanConfig INSTANCE;

        @Override
        @NotNull
        public String getStringPresentation() {
            return "";
        }

        @Override
        @NotNull
        public String toString() {
            return "Start with clean config";
        }

        private StartWithCleanConfig() {
            super(null);
        }

        static {
            StartWithCleanConfig startWithCleanConfig;
            INSTANCE = startWithCleanConfig = new StartWithCleanConfig();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "location", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getLocation", "()Ljava/nio/file/Path;", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MigrateFromCustomPlace
    extends CustomConfigMigrationOption {
        @NotNull
        private final Path location;

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.IMPORT_PREFIX + PathKt.getSystemIndependentPath((Path)this.location);
        }

        @NotNull
        public final Path getLocation() {
            return this.location;
        }

        public MigrateFromCustomPlace(@NotNull Path location) {
            super(null);
            this.location = location;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "properties", "", "", "(Ljava/util/List;)V", "getProperties", "()Ljava/util/List;", "getStringPresentation", "intellij.platform.ide.impl"})
    public static final class SetProperties
    extends CustomConfigMigrationOption {
        @NotNull
        private final List<String> properties;

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.PROPERTIES_PREFIX + CollectionsKt.joinToString$default((Iterable)this.properties, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final List<String> getProperties() {
            return this.properties;
        }

        public SetProperties(@NotNull List<String> properties) {
            super(null);
            this.properties = properties;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$Companion;", "", "()V", "IMPORT_PREFIX", "", "PROPERTIES_PREFIX", "getCustomConfigMarkerFilePath", "Ljava/nio/file/Path;", "configDir", "readCustomConfigMigrationOptionAndRemoveMarkerFile", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "removeMarkerFile", "", "markerFile", "intellij.platform.ide.impl"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
            Path markerFile2 = this.getCustomConfigMarkerFilePath(configDir);
            if (!PathKt.exists((Path)markerFile2)) {
                return null;
            }
            try {
                List<String> lines = Files.readAllLines(markerFile2);
                if (lines.isEmpty()) {
                    CustomConfigMigrationOption customConfigMigrationOption = StartWithCleanConfig.INSTANCE;
                    return customConfigMigrationOption;
                }
                String line = (String)CollectionsKt.first(lines);
                Object object = line;
                boolean bl = false;
                if (object.length() == 0) {
                    object = StartWithCleanConfig.INSTANCE;
                    return object;
                }
                if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.IMPORT_PREFIX, (boolean)false, (int)2, null)) {
                    Path path = markerFile2.getFileSystem().getPath(StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.IMPORT_PREFIX), new String[0]);
                    if (!PathKt.exists((Path)path)) {
                        CustomConfigMigrationOptionKt.access$getLog$p().warn(markerFile2 + " points to non-existent config: [" + lines + ']');
                        CustomConfigMigrationOption customConfigMigrationOption = null;
                        return customConfigMigrationOption;
                    }
                    CustomConfigMigrationOption customConfigMigrationOption = new MigrateFromCustomPlace(path);
                    return customConfigMigrationOption;
                }
                if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.PROPERTIES_PREFIX, (boolean)false, (int)2, null)) {
                    List properties = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.PROPERTIES_PREFIX), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                    CustomConfigMigrationOption customConfigMigrationOption = new SetProperties(properties);
                    return customConfigMigrationOption;
                }
                CustomConfigMigrationOptionKt.access$getLog$p().error("Invalid format of " + markerFile2 + ": " + lines);
                object = null;
                return object;
            }
            catch (Exception e) {
                CustomConfigMigrationOptionKt.access$getLog$p().warn("Couldn't load content of " + markerFile2);
                CustomConfigMigrationOption customConfigMigrationOption = null;
                return customConfigMigrationOption;
            }
            finally {
                this.removeMarkerFile(markerFile2);
            }
        }

        private final void removeMarkerFile(Path markerFile2) {
            try {
                PathKt.delete$default((Path)markerFile2, (boolean)false, (int)1, null);
            }
            catch (Exception e) {
                CustomConfigMigrationOptionKt.access$getLog$p().warn("Couldn't delete the custom config migration file " + markerFile2, (Throwable)e);
            }
        }

        @VisibleForTesting
        @NotNull
        public final Path getCustomConfigMarkerFilePath(@NotNull Path configDir) {
            return configDir.resolve("migrate.config");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

