/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl.actionholder;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.actionholder.IdActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.SimpleActionRef;
import org.jetbrains.annotations.NotNull;

public abstract class ActionRef<T extends AnAction> {
    private static ActionManager ourManager;

    static ActionManager getManager() {
        if (ourManager == null) {
            ourManager = ActionManager.getInstance();
        }
        return ourManager;
    }

    public static <T extends AnAction> ActionRef<T> fromAction(@NotNull T action2) {
        String id2 = ActionRef.getManager().getId(action2);
        return id2 == null ? new SimpleActionRef<T>(action2) : new IdActionRef(id2);
    }

    @NotNull
    public abstract T getAction();
}

