/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDataContext
implements DataContext {
    private final Map<String, Object> myDataId2Data;
    private final DataContext myParent;
    private final boolean myWithRules;
    private final DataProvider myDataProvider;

    private SimpleDataContext(String dataId, Object data2, DataContext parent) {
        this(new HashMap<String, Object>(1), parent, false);
        this.myDataId2Data.put(dataId, data2);
    }

    private SimpleDataContext(@NotNull Map<String, Object> dataId2data, DataContext parent, boolean withRules) {
        this.myDataId2Data = dataId2data;
        this.myParent = parent;
        this.myWithRules = withRules;
        this.myDataProvider = withRules ? dataId -> this.getDataFromSelfOrParent(dataId) : __ -> null;
    }

    public Object getData(@NotNull String dataId) {
        GetDataRule rule;
        Object result2 = this.getDataFromSelfOrParent(dataId);
        if (result2 == null && PlatformDataKeys.CONTEXT_COMPONENT.getName().equals(dataId)) {
            result2 = IdeFocusManager.getGlobalInstance().getFocusOwner();
        }
        if (result2 == null && this.myWithRules && (rule = ((DataManagerImpl)DataManager.getInstance()).getDataRule(dataId)) != null) {
            return rule.getData(this.myDataProvider);
        }
        return result2;
    }

    @Nullable
    private Object getDataFromSelfOrParent(String dataId) {
        return this.myDataId2Data.containsKey(dataId) ? this.myDataId2Data.get(dataId) : (this.myParent == null ? null : this.myParent.getData(dataId));
    }

    @NotNull
    public static DataContext getSimpleContext(String dataId, Object data2, DataContext parent) {
        return new SimpleDataContext(dataId, data2, parent);
    }

    @NotNull
    public static DataContext getSimpleContext(@NotNull Map<String, Object> dataId2data, DataContext parent) {
        return SimpleDataContext.getSimpleContext(dataId2data, parent, false);
    }

    @NotNull
    public static DataContext getSimpleContext(@NotNull Map<String, Object> dataId2data, DataContext parent, boolean withRules) {
        return new SimpleDataContext(dataId2data, parent, withRules);
    }

    @NotNull
    public static DataContext getSimpleContext(String dataId, Object data2) {
        return SimpleDataContext.getSimpleContext(dataId, data2, null);
    }

    @NotNull
    public static DataContext getProjectContext(Project project) {
        return SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project);
    }
}

