/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class ToolbarLabelAction
extends DumbAwareAction
implements CustomComponentAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(false);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        return new MyLabel(presentation2).withFont(JBUI.Fonts.toolbarFont()).withBorder((Border)JBUI.Borders.empty((int)0, (int)6, (int)0, (int)5));
    }

    private static class MyLabel
    extends JBLabel {
        @NotNull
        private final Presentation myPresentation;

        MyLabel(@NotNull Presentation presentation2) {
            this.myPresentation = presentation2;
            presentation2.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String propertyName = e.getPropertyName();
                    if ("text".equals(propertyName) || "description".equals(propertyName)) {
                        this.updatePresentation();
                    }
                }
            });
            this.updatePresentation();
        }

        private void updatePresentation() {
            this.setText(StringUtil.notNullize((String)this.myPresentation.getText()));
            this.setToolTipText(StringUtil.nullize((String)this.myPresentation.getDescription()));
        }
    }
}

