/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.actionSystem.impl.Win10ActionButtonLook;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ActionButtonLook {
    public static final ActionButtonLook SYSTEM_LOOK = new ActionButtonLook(){
        private ActionButtonLook delegate;
        {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.delegate = UIUtil.isUnderWin10LookAndFeel() ? new Win10ActionButtonLook() : new IdeaActionButtonLook();
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, int state) {
            this.delegate.paintBackground(g, component2, state);
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
            this.delegate.paintBackground(g, component2, color);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state) {
            this.delegate.paintBorder(g, component2, state);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
            this.delegate.paintBorder(g, component2, color);
        }

        @Override
        public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            this.delegate.paintLookBackground(g, rect, color);
        }

        @Override
        public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            this.delegate.paintLookBorder(g, rect, color);
        }
    };
    public static final ActionButtonLook INPLACE_LOOK = new ActionButtonLook(){

        @Override
        public void paintBackground(Graphics g, JComponent component2, int state) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state) {
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
        }
    };

    public <ButtonType extends JComponent> void paintBackground(Graphics g, ButtonType button2) {
        this.paintBackground(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public <ButtonType extends JComponent> void paintBorder(Graphics g, ButtonType button2) {
        this.paintBorder(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public void paintBackground(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
        if (state == 0 && !component2.isBackgroundSet()) {
            return;
        }
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        Color color = state == 0 ? component2.getBackground() : (state == -1 ? JBUI.CurrentTheme.ActionButton.pressedBackground() : JBUI.CurrentTheme.ActionButton.hoverBackground());
        this.paintLookBackground(g, rect, color);
    }

    public void paintBackground(Graphics g, JComponent component2, Color color) {
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        this.paintLookBackground(g, rect, color);
    }

    public void paintBorder(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
        if (state == 0 && !component2.isBackgroundSet()) {
            return;
        }
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        Color color = state == -1 ? JBUI.CurrentTheme.ActionButton.pressedBorder() : JBUI.CurrentTheme.ActionButton.hoverBorder();
        this.paintLookBorder(g, rect, color);
    }

    public void paintBorder(Graphics g, JComponent component2, Color color) {
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        this.paintLookBorder(g, rect, color);
    }

    public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
    }

    public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
    }

    public void updateUI() {
    }

    @ActionButtonComponent.ButtonState
    protected int getState(ActionButtonComponent button2) {
        return button2.getPopState();
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2) {
        Rectangle rect = new Rectangle(actionButton.getWidth(), actionButton.getHeight());
        Insets i2 = actionButton.getInsets();
        JBInsets.removeFrom((Rectangle)rect, (Insets)i2);
        int x = i2.left + (rect.width - icon2.getIconWidth()) / 2;
        int y = i2.top + (rect.height - icon2.getIconHeight()) / 2;
        this.paintIcon(g, actionButton, icon2, x, y);
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2, int x, int y) {
        icon2.paintIcon(actionButton instanceof Component ? (Component)actionButton : null, g, x, y);
    }

    @Deprecated
    public void paintIconAt(Graphics g, Icon icon2, int x, int y) {
        icon2.paintIcon(null, g, x, y);
    }
}

