/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.widget;

import com.intellij.ide.ui.UISettings;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.ui.UIBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NotificationWidgetFactory
implements StatusBarWidgetFactory {
    public static boolean isAvailable() {
        return UISettings.getInstance().getHideToolStripes() || UISettings.getInstance().getPresentationMode();
    }

    @NotNull
    public String getId() {
        return "Notifications";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return UIBundle.message((String)"status.bar.notifications.widget.name", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project) {
        return NotificationWidgetFactory.isAvailable();
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return new IdeNotificationArea();
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Disposer.dispose((Disposable)widget);
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        return NotificationWidgetFactory.isAvailable();
    }
}

