/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance(NotificationsUtil.class);
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        String title = notification.getTitle();
        String content2 = notification.getContent();
        if (title.length() > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nContent=" + content2);
            title = StringUtil.trimLog((String)title, (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        return NotificationsUtil.buildHtml(title, null, content2, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()), null, null);
    }

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content2;
        String title = !isContent ? notification.getTitle() : "";
        String subtitle = !isContent ? notification.getSubtitle() : null;
        String string = content2 = isContent ? notification.getContent() : "";
        if (title.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nSubtitle=" + subtitle + "\nContent=" + content2);
            title = StringUtil.trimLog((String)title, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        if (isContent) {
            content2 = StringUtil.replace((String)content2, (String)"<p/>", (String)"<br>");
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        return NotificationsUtil.buildHtml(title, subtitle, content2, style, isContent ? null : colorText, isContent ? colorText : null, contentStyle);
    }

    @NotNull
    public static String buildHtml(@Nullable String title, @Nullable String subtitle, @Nullable String content2, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = subtitle;
            subtitle = null;
        } else if (!StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = title + ":";
        }
        StringBuilder result2 = new StringBuilder();
        if (style != null) {
            result2.append("<div style=\"").append(style).append("\">");
        }
        if (!StringUtil.isEmpty((String)title)) {
            result2.append("<b").append(titleColor == null ? ">" : " color=\"" + titleColor + "\">").append(title).append("</b>");
        }
        if (!StringUtil.isEmpty((String)subtitle)) {
            result2.append("&nbsp;").append(titleColor == null ? "" : "<span color=\"" + titleColor + "\">").append(subtitle).append(titleColor == null ? "" : "</span>");
        }
        if (!StringUtil.isEmpty((String)content2)) {
            result2.append("<div").append(contentStyle == null ? "" : " style=\"" + contentStyle + "\"").append(contentColor == null ? ">" : " color=\"" + contentColor + "\">").append(content2).append("</div>");
        }
        if (style != null) {
            result2.append("</div>");
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2.toString());
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @Nullable
    public static Integer getFontSize() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return uiSettings.getFontSize();
        }
        Font font = UIUtil.getLabelFont();
        return font == null ? null : Integer.valueOf(font.getSize());
    }

    @Nullable
    public static String getFontName() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return uiSettings.getFontFace();
        }
        Font font = UIUtil.getLabelFont();
        return font == null ? null : font.getName();
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        NotificationListener listener2 = notification.getListener();
        if (listener2 == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    NotificationCollector.getInstance().logHyperlinkClicked(notification);
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification) {
        Icon icon2 = notification.getIcon();
        if (icon2 != null) {
            return icon2;
        }
        switch (notification.getType()) {
            case WARNING: {
                return AllIcons.General.BalloonWarning;
            }
            case ERROR: {
                return AllIcons.General.BalloonError;
            }
        }
        return AllIcons.General.BalloonInformation;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification) {
        switch (notification.getType()) {
            case WARNING: {
                return MessageType.WARNING;
            }
            case ERROR: {
                return MessageType.ERROR;
            }
        }
        return MessageType.INFO;
    }
}

