/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.ExecutorHolder;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class MacEventReader
implements Notifications {
    private static final int MAX_MESSAGE_LENGTH = 100;
    private static final Logger LOG = Logger.getInstance(MacEventReader.class);

    MacEventReader() {
    }

    public void notify(@NotNull Notification notification) {
        if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldReadAloud()) {
            return;
        }
        String message = notification.getTitle();
        if (message.isEmpty()) {
            message = notification.getContent();
        }
        if ((message = StringUtil.stripHtml((String)message, (boolean)false)).length() > 100) {
            String[] words = message.split("\\s");
            StringBuilder sb = new StringBuilder();
            for (String word : words) {
                if (sb.length() + word.length() >= 99) break;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(word);
            }
            message = sb.toString();
        }
        if (!message.isEmpty()) {
            String copy2 = message;
            ExecutorHolder.ourService.execute(() -> {
                try {
                    Runtime.getRuntime().exec("say " + copy2).waitFor();
                }
                catch (IOException | InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
            });
        }
    }
}

