/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.EventLogCategory;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.EventLogToolWindowFactory;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EventLog {
    public static final String LOG_REQUESTOR = "Internal log requestor";
    public static final String LOG_TOOL_WINDOW_ID = "Event Log";
    public static final String HELP_ID = "reference.toolwindows.event.log";
    private static final String A_CLOSING = "</a>";
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    @NonNls
    private static final Set<String> NEW_LINES = ContainerUtil.newHashSet((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});
    private static final String DEFAULT_CATEGORY = "";
    private final LogModel myModel = new LogModel(null);
    @NonNls
    private static final String[] HTML_TAGS = new String[]{"a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "datalist", "dd", "del", "details", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "meter", "nav", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"};
    @NonNls
    private static final String[] SKIP_TAGS = new String[]{"html", "body", "b", "i", "font"};

    public static void expireNotification(@NotNull Notification notification) {
        EventLog.getApplicationService().myModel.removeNotification(notification);
        for (Project p : ProjectUtil.getOpenProjects()) {
            if (p.isDisposed()) continue;
            EventLog.getProjectService(p).myProjectModel.removeNotification(notification);
        }
    }

    public static void showNotification(@NotNull Project project, @NotNull String groupId2, @NotNull List<String> ids) {
        EventLog.getProjectService(project).showNotification(groupId2, ids);
    }

    private static EventLog getApplicationService() {
        return (EventLog)ApplicationManager.getApplication().getService(EventLog.class);
    }

    @NotNull
    public static LogModel getLogModel(@Nullable Project project) {
        return project != null ? EventLog.getProjectService(project).myProjectModel : EventLog.getApplicationService().myModel;
    }

    @NotNull
    public static List<Notification> getNotifications(@NotNull Project project) {
        ProjectTracker service = (ProjectTracker)project.getServiceIfCreated(ProjectTracker.class);
        return service == null ? Collections.emptyList() : service.myProjectModel.getNotifications();
    }

    public static void markAllAsRead(@Nullable Project project) {
        LogModel model = EventLog.getLogModel(project);
        HashSet<String> groups = new HashSet<String>();
        for (Notification notification : model.getNotifications()) {
            groups.add(notification.getGroupId());
            model.removeNotification(notification);
            notification.expire();
        }
        if (project != null && !groups.isEmpty()) {
            EventLog.clearNMore(project, groups);
        }
    }

    public static void clearNMore(@NotNull Project project, @NotNull Collection<String> groups) {
        EventLog.getProjectService(project).clearNMore(groups);
    }

    @Nullable
    public static Trinity<Notification, String, Long> getStatusMessage(@Nullable Project project) {
        return EventLog.getLogModel(project).getStatusMessage();
    }

    public static LogEntry formatForLog(final @NotNull Notification notification, String indent) {
        DocumentImpl logDoc = new DocumentImpl(DEFAULT_CATEGORY, true);
        AtomicBoolean showMore = new AtomicBoolean(false);
        LinkedHashMap links = new LinkedHashMap();
        ArrayList<RangeMarker> lineSeparators = new ArrayList<RangeMarker>();
        String title = notification.getTitle();
        String subtitle = notification.getSubtitle();
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)subtitle)) {
            title = title + " (" + subtitle + ")";
        }
        title = EventLog.truncateLongString(showMore, title);
        String content2 = EventLog.truncateLongString(showMore, notification.getContent());
        RangeMarker afterTitle = null;
        boolean hasHtml = EventLog.parseHtmlContent(EventLog.addIndents(title, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)content2)) {
            EventLog.appendText(logDoc, ": ");
            afterTitle = logDoc.createRangeMarker(logDoc.getTextLength() - 2, logDoc.getTextLength());
        }
        int titleLength = logDoc.getTextLength();
        hasHtml |= EventLog.parseHtmlContent(EventLog.addIndents(content2, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        List actions = notification.getActions();
        if (!actions.isEmpty()) {
            String text = "<p>" + StringUtil.join((Collection)actions, (Function)new Function<AnAction, String>(){
                private int index;

                public String fun(AnAction action2) {
                    return "<a href=\"" + this.index++ + "\">" + action2.getTemplatePresentation().getText() + EventLog.A_CLOSING;
                }
            }, (String)(EventLog.isLongLine(actions) ? "<br>" : "&nbsp;&nbsp;&nbsp;")) + "</p>";
            Notification n = new Notification(DEFAULT_CATEGORY, DEFAULT_CATEGORY, ".", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent event) {
                    Object source = event.getSource();
                    DataContext context = source instanceof Component ? DataManager.getInstance().getDataContext((Component)source) : null;
                    AnAction action2 = (AnAction)notification.getActions().get(Integer.parseInt(event.getDescription()));
                    NotificationCollector.getInstance().logNotificationActionInvoked(notification, action2, NotificationCollector.NotificationPlace.EVENT_LOG);
                    Notification.fire((Notification)notification, (AnAction)action2, (DataContext)context);
                }
            });
            if (title.length() > 0 || content2.length() > 0) {
                lineSeparators.add(logDoc.createRangeMarker(TextRange.from((int)logDoc.getTextLength(), (int)0)));
            }
            hasHtml |= EventLog.parseHtmlContent(text, n, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        }
        String status = EventLog.getStatusText(logDoc, showMore, lineSeparators, indent, hasHtml);
        EventLog.indentNewLines(logDoc, lineSeparators, afterTitle, hasHtml, indent);
        ArrayList<Pair<TextRange, HyperlinkInfo>> list2 = new ArrayList<Pair<TextRange, HyperlinkInfo>>();
        for (RangeMarker marker : links.keySet()) {
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            list2.add((Pair<TextRange, HyperlinkInfo>)Pair.create((Object)new TextRange(marker.getStartOffset(), marker.getEndOffset()), links.get(marker)));
        }
        if (showMore.get()) {
            String sb = "show balloon";
            if (!logDoc.getText().endsWith(" ")) {
                EventLog.appendText(logDoc, " ");
            }
            EventLog.appendText(logDoc, "(" + sb + ")");
            list2.add((Pair<TextRange, HyperlinkInfo>)new Pair((Object)TextRange.from((int)(logDoc.getTextLength() - 1 - sb.length()), (int)sb.length()), (Object)new ShowBalloon(notification)));
        }
        return new LogEntry(logDoc.getText(), status, list2, titleLength);
    }

    @NotNull
    private static String addIndents(@NotNull String text, @NotNull String indent) {
        return StringUtil.replace((String)text, (String)"\n", (String)("\n" + indent));
    }

    private static boolean isLongLine(@NotNull List<? extends AnAction> actions) {
        int size = actions.size();
        if (size > 3) {
            return true;
        }
        if (size > 1) {
            int length = 0;
            for (AnAction anAction : actions) {
                length += StringUtil.length((CharSequence)anAction.getTemplatePresentation().getText());
            }
            return length > 30;
        }
        return false;
    }

    @NotNull
    private static String truncateLongString(AtomicBoolean showMore, String title) {
        if (title.length() > 1000) {
            showMore.set(true);
            return title.substring(0, 1000) + "...";
        }
        return title;
    }

    private static void indentNewLines(DocumentImpl logDoc, List<RangeMarker> lineSeparators, RangeMarker afterTitle, boolean hasHtml, String indent) {
        if (!hasHtml) {
            int i2 = -1;
            while ((i2 = StringUtil.indexOf((CharSequence)logDoc.getText(), (char)'\n', (int)(i2 + 1))) >= 0) {
                lineSeparators.add(logDoc.createRangeMarker(i2, i2 + 1));
            }
        }
        if (!lineSeparators.isEmpty() && afterTitle != null && afterTitle.isValid()) {
            lineSeparators.add(afterTitle);
        }
        int nextLineStart = -1;
        for (RangeMarker separator : lineSeparators) {
            int start2;
            if (!separator.isValid() || (start2 = separator.getStartOffset()) == nextLineStart) continue;
            logDoc.replaceString(start2, separator.getEndOffset(), "\n" + indent);
            nextLineStart = start2 + 1 + indent.length();
            while (nextLineStart < logDoc.getTextLength() && Character.isWhitespace(logDoc.getCharsSequence().charAt(nextLineStart))) {
                logDoc.deleteString(nextLineStart, nextLineStart + 1);
            }
        }
    }

    private static String getStatusText(DocumentImpl logDoc, AtomicBoolean showMore, List<? extends RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        DocumentImpl statusDoc = new DocumentImpl(logDoc.getImmutableCharSequence(), true);
        ArrayList<RangeMarker> statusSeparators = new ArrayList<RangeMarker>();
        for (RangeMarker rangeMarker : lineSeparators) {
            if (!rangeMarker.isValid()) continue;
            statusSeparators.add(statusDoc.createRangeMarker(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
        }
        EventLog.removeJavaNewLines(statusDoc, statusSeparators, indent, hasHtml);
        EventLog.insertNewLineSubstitutors(statusDoc, showMore, statusSeparators);
        return statusDoc.getText();
    }

    private static boolean parseHtmlContent(String text, Notification notification, Document document, AtomicBoolean showMore, Map<RangeMarker, HyperlinkInfo> links, List<RangeMarker> lineSeparators) {
        String content2 = StringUtil.convertLineSeparators((String)text);
        int initialLen = document.getTextLength();
        boolean hasHtml = false;
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content2)).find()) break;
            String tagStart = tagMatcher.group();
            EventLog.appendText(document, content2.substring(0, tagMatcher.start()));
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                String href = aMatcher.group(2);
                int linkEnd = content2.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content2.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), DEFAULT_CATEGORY);
                    int linkStart = document.getTextLength();
                    EventLog.appendText(document, linkText);
                    links.put(document.createRangeMarker(linkStart, document.getTextLength()), new NotificationHyperlinkInfo(notification, href));
                    content2 = content2.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (EventLog.isTag(HTML_TAGS, tagStart)) {
                hasHtml = true;
                if (NEW_LINES.contains(tagStart)) {
                    if (initialLen != document.getTextLength()) {
                        lineSeparators.add(document.createRangeMarker(TextRange.from((int)document.getTextLength(), (int)0)));
                    }
                } else if (!EventLog.isTag(SKIP_TAGS, tagStart)) {
                    showMore.set(true);
                }
            } else {
                EventLog.appendText(document, content2.substring(tagMatcher.start(), tagMatcher.end()));
            }
            content2 = content2.substring(tagMatcher.end());
        }
        EventLog.appendText(document, content2);
        lineSeparators.removeIf(next -> next.getEndOffset() == document.getTextLength());
        return hasHtml;
    }

    private static boolean isTag(String @NotNull [] tags, @NotNull String tag2) {
        tag2 = tag2.substring(1, tag2.length() - 1);
        int index = (tag2 = StringUtil.trimEnd((String)StringUtil.trimStart((String)tag2, (String)"/"), (String)"/")).indexOf(32);
        if (index != -1) {
            tag2 = tag2.substring(0, index);
        }
        return ArrayUtil.indexOf((Object[])tags, (Object)tag2) != -1;
    }

    private static void insertNewLineSubstitutors(Document document, AtomicBoolean showMore, List<? extends RangeMarker> lineSeparators) {
        for (RangeMarker rangeMarker : lineSeparators) {
            boolean spaceBefore;
            if (!rangeMarker.isValid()) {
                showMore.set(true);
                continue;
            }
            int offset = rangeMarker.getStartOffset();
            if (offset == 0 || offset == document.getTextLength()) continue;
            boolean bl = spaceBefore = offset > 0 && Character.isWhitespace(document.getCharsSequence().charAt(offset - 1));
            if (offset < document.getTextLength()) {
                boolean spaceAfter = Character.isWhitespace(document.getCharsSequence().charAt(offset));
                int next = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
                if (next < document.getTextLength() && !Character.isLowerCase(document.getCharsSequence().charAt(next))) {
                    document.insertString(offset, (CharSequence)((spaceBefore ? DEFAULT_CATEGORY : " ") + "//" + (spaceAfter ? DEFAULT_CATEGORY : " ")));
                    continue;
                }
                if (spaceAfter) continue;
            }
            if (spaceBefore) continue;
            document.insertString(offset, (CharSequence)" ");
        }
    }

    private static void removeJavaNewLines(Document document, List<? super RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        CharSequence text = document.getCharsSequence();
        int i2 = 0;
        while ((i2 = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)i2)) >= 0) {
            int j = i2 + 1;
            if (StringUtil.startsWith((CharSequence)text, (int)j, (CharSequence)indent)) {
                j += indent.length();
            }
            document.deleteString(i2, j);
            if (hasHtml) continue;
            lineSeparators.add((RangeMarker)document.createRangeMarker(TextRange.from((int)i2, (int)0)));
        }
    }

    private static void appendText(Document document, String text) {
        text = StringUtil.replace((String)text, (String)"&nbsp;", (String)" ");
        text = StringUtil.replace((String)text, (String)"&raquo;", (String)">>");
        text = StringUtil.replace((String)text, (String)"&laquo;", (String)"<<");
        text = StringUtil.replace((String)text, (String)"&hellip;", (String)"...");
        document.insertString(document.getTextLength(), (CharSequence)StringUtil.unescapeXmlEntities((String)text));
    }

    @Nullable
    public static ToolWindow getEventLog(@Nullable Project project) {
        return project == null ? null : ToolWindowManager.getInstance((Project)project).getToolWindow(LOG_TOOL_WINDOW_ID);
    }

    public static void toggleLog(@Nullable Project project, @Nullable Notification notification) {
        ToolWindow eventLog = EventLog.getEventLog(project);
        if (eventLog != null) {
            if (!eventLog.isVisible()) {
                EventLog.activate(eventLog, notification == null ? null : notification.getGroupId(), null);
            } else {
                eventLog.hide(null);
            }
        }
    }

    private static void activate(@NotNull ToolWindow eventLog, @Nullable String groupId2, @Nullable Runnable runnable2) {
        eventLog.activate(() -> {
            if (groupId2 == null) {
                return;
            }
            String contentName = EventLog.getContentName(groupId2);
            Content content2 = eventLog.getContentManager().findContent(contentName);
            if (content2 != null) {
                eventLog.getContentManager().setSelectedContent(content2);
            }
            if (runnable2 != null) {
                runnable2.run();
            }
        }, true);
    }

    @NotNull
    private static String getContentName(@NotNull String groupId2) {
        for (EventLogCategory category : EventLogCategory.EP_NAME.getExtensionList()) {
            if (!category.acceptsNotification(groupId2)) continue;
            return category.getDisplayName();
        }
        return DEFAULT_CATEGORY;
    }

    @NotNull
    static ProjectTracker getProjectService(@NotNull Project project) {
        return (ProjectTracker)project.getService(ProjectTracker.class);
    }

    static final class MyNotificationListener
    implements Notifications {
        MyNotificationListener() {
        }

        public void notify(@NotNull Notification notification) {
            Project[] openProjects;
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            Project[] projectArray = openProjects = projectManager == null ? null : projectManager.getOpenProjects();
            if (openProjects == null || openProjects.length == 0) {
                EventLog.getApplicationService().myModel.addNotification(notification);
            } else {
                for (Project p : openProjects) {
                    if (p.isDisposed()) continue;
                    EventLog.getProjectService(p).printNotification(notification);
                }
            }
        }
    }

    static final class ShowBalloon
    implements HyperlinkInfo {
        private final Notification myNotification;
        private RangeHighlighter myRangeHighlighter;

        ShowBalloon(Notification notification) {
            this.myNotification = notification;
        }

        public void setRangeHighlighter(RangeHighlighter rangeHighlighter) {
            this.myRangeHighlighter = rangeHighlighter;
        }

        public void navigate(Project project) {
            ShowBalloon.hideBalloon(this.myNotification);
            for (Notification notification : EventLog.getLogModel(project).getNotifications()) {
                ShowBalloon.hideBalloon(notification);
            }
            EventLogConsole console = Objects.requireNonNull(EventLog.getProjectService(project).getConsole(this.myNotification));
            if (this.myRangeHighlighter == null || !this.myRangeHighlighter.isValid()) {
                return;
            }
            RelativePoint target2 = console.getRangeHighlighterLocation(this.myRangeHighlighter);
            if (target2 != null) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
                assert (frame != null);
                Balloon balloon = NotificationsManagerImpl.createBalloon(frame, this.myNotification, true, true, BalloonLayoutData.fullContent(), (Disposable)project);
                balloon.show(target2, Balloon.Position.above);
                NotificationCollector.getInstance().logBalloonShownFromEventLog(this.myNotification);
            }
        }

        private static void hideBalloon(Notification notification) {
            Balloon balloon = notification.getBalloon();
            if (balloon != null) {
                balloon.hide(true);
            }
        }
    }

    private static final class NotificationHyperlinkInfo
    implements HyperlinkInfo {
        private final Notification myNotification;
        private final String myHref;

        NotificationHyperlinkInfo(Notification notification, String href) {
            this.myNotification = notification;
            this.myHref = href;
        }

        public void navigate(Project project) {
            NotificationListener listener2 = this.myNotification.getListener();
            if (listener2 != null) {
                EventLogConsole console = Objects.requireNonNull(EventLog.getProjectService(project).getConsole(this.myNotification));
                JComponent component2 = console.getConsoleEditor().getContentComponent();
                listener2.hyperlinkUpdate(this.myNotification, IJSwingUtilities.createHyperlinkEvent(this.myHref, component2));
            }
        }
    }

    static final class ProjectTracker
    implements Disposable {
        private final Map<String, EventLogConsole> myCategoryMap = new ConcurrentHashMap<String, EventLogConsole>();
        private final List<Notification> myInitial = ContainerUtil.createLockFreeCopyOnWriteList();
        private final LogModel myProjectModel;
        @NotNull
        private final Project myProject;

        ProjectTracker(@NotNull Project project) {
            this.myProjectModel = new LogModel(project);
            this.myProject = project;
            EventLog appService = (EventLog)ApplicationManager.getApplication().getServiceIfCreated(EventLog.class);
            if (appService != null) {
                for (Notification notification : appService.myModel.takeNotifications()) {
                    this.printNotification(notification);
                }
            }
            project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new Notifications(){

                public void notify(@NotNull Notification notification) {
                    this.printNotification(notification);
                }
            });
        }

        public void dispose() {
            EventLog appService = (EventLog)ApplicationManager.getApplication().getServiceIfCreated(EventLog.class);
            if (appService != null) {
                appService.myModel.setStatusMessage(null, 0L);
            }
            StatusBar.Info.set((String)EventLog.DEFAULT_CATEGORY, null, (String)EventLog.LOG_REQUESTOR);
        }

        void initDefaultContent() {
            this.createNewContent(EventLog.DEFAULT_CATEGORY);
            if (this.myInitial.isEmpty()) {
                return;
            }
            ArrayList<Notification> notifications = new ArrayList<Notification>(this.myInitial);
            this.myInitial.clear();
            StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
                for (Notification notification : notifications) {
                    if (ShutDownTracker.isShutdownHookRunning()) {
                        return;
                    }
                    EventLogConsole console = Objects.requireNonNull(this.getConsole(notification));
                    GuiUtils.invokeLaterIfNeeded(() -> console.doPrintNotification(notification), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
                }
            });
        }

        private void printNotification(Notification notification) {
            if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldLog()) {
                return;
            }
            this.myProjectModel.addNotification(notification);
            NotificationCollector.getInstance().logNotificationLoggedInEventLog(this.myProject, notification);
            EventLogConsole console = this.getConsole(notification);
            if (console == null) {
                this.myInitial.add(notification);
            } else {
                StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
                    if (!ShutDownTracker.isShutdownHookRunning()) {
                        GuiUtils.invokeLaterIfNeeded(() -> console.doPrintNotification(notification), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
                    }
                });
            }
        }

        private void showNotification(@NotNull String groupId2, @NotNull List<String> ids) {
            ToolWindow eventLog = EventLog.getEventLog(this.myProject);
            if (eventLog != null) {
                EventLog.activate(eventLog, groupId2, () -> {
                    EventLogConsole console = this.getConsole(groupId2);
                    if (console != null) {
                        console.showNotification(ids);
                    }
                });
            }
        }

        private void clearNMore(@NotNull Collection<String> groups) {
            for (String group : groups) {
                EventLogConsole console = this.myCategoryMap.get(EventLog.getContentName(group));
                if (console == null) continue;
                console.clearNMore();
            }
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull Notification notification) {
            return this.getConsole(notification.getGroupId());
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull String groupId2) {
            if (this.myCategoryMap.get(EventLog.DEFAULT_CATEGORY) == null) {
                return null;
            }
            String name = EventLog.getContentName(groupId2);
            EventLogConsole console = this.myCategoryMap.get(name);
            return console == null ? this.createNewContent(name) : console;
        }

        @NotNull
        private EventLogConsole createNewContent(@NotNull String name) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindow toolWindow = Objects.requireNonNull(ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(EventLog.LOG_TOOL_WINDOW_ID));
            EventLogConsole newConsole = new EventLogConsole(this.myProjectModel, toolWindow.getDisposable());
            EventLogToolWindowFactory.createContent(this.myProject, toolWindow, newConsole, name);
            this.myCategoryMap.put(name, newConsole);
            return newConsole;
        }
    }

    public static class LogEntry {
        public final String message;
        public final String status;
        public final List<Pair<TextRange, HyperlinkInfo>> links;
        public final int titleLength;

        public LogEntry(@NotNull String message, @NotNull String status, @NotNull List<Pair<TextRange, HyperlinkInfo>> links, int titleLength) {
            this.message = message;
            this.status = status;
            this.links = links;
            this.titleLength = titleLength;
        }
    }
}

