/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="DependenciesAnalyzeManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DependenciesAnalyzeManager
implements PersistentStateComponent<State> {
    private final Project myProject;
    private ContentManager myContentManager;
    private State myState = new State();

    public DependenciesAnalyzeManager(Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.registerToolWindow("Module Dependencies", true, ToolWindowAnchor.RIGHT, (Disposable)project);
            this.myContentManager = toolWindow.getContentManager();
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowModuleDependencies);
            ContentManagerWatcher.watchContentManager(toolWindow, this.myContentManager);
        });
    }

    public static DependenciesAnalyzeManager getInstance(Project project) {
        return (DependenciesAnalyzeManager)ServiceManager.getService((Project)project, DependenciesAnalyzeManager.class);
    }

    public void addContent(Content content2) {
        this.myContentManager.addContent(content2);
        this.myContentManager.setSelectedContent(content2);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Module Dependencies").activate(null);
    }

    public void closeContent(Content content2) {
        this.myContentManager.removeContent(content2, true);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state != null ? state : new State();
    }

    public static class State {
        public boolean forwardDirection = true;
        public boolean includeTests = false;
    }
}

