/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.model.search.CodeReferenceSearcher;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.PsiSymbolReferenceSearchParameters;
import com.intellij.model.search.PsiSymbolReferenceSearcher;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.impl.CodeReferenceMapper;
import com.intellij.model.search.impl.ExternalReferenceMapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/model/search/impl/DefaultReferenceSearcher;", "Lcom/intellij/model/search/PsiSymbolReferenceSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/model/psi/PsiSymbolReference;", "parameters", "Lcom/intellij/model/search/PsiSymbolReferenceSearchParameters;", "intellij.platform.indexing.impl"})
public final class DefaultReferenceSearcher
implements PsiSymbolReferenceSearcher {
    @NotNull
    public Collection<Query<? extends PsiSymbolReference>> collectSearchRequests(@NotNull PsiSymbolReferenceSearchParameters parameters2) {
        Project project = parameters2.getProject();
        SearchScope inputScope = parameters2.getSearchScope();
        Symbol target2 = parameters2.getSymbol();
        Pointer targetPointer = target2.createPointer();
        SearchService service = SearchService.getInstance();
        boolean bl = false;
        List result2 = new ArrayList();
        for (CodeReferenceSearcher searcher : CodeReferenceSearcher.EP_NAME.getExtensionList()) {
            SearchScope searchScope;
            SearchScope searchScope2;
            SearchRequest request2;
            if (searcher.getSearchRequest(project, target2) == null) {
                continue;
            }
            Language language = searcher.getReferencingLanguage();
            SearchScope searchScope3 = request2.getSearchScope();
            if (searchScope3 == null || (searchScope3 = searchScope3.intersectWith(inputScope)) == null) {
                searchScope3 = searchScope2 = inputScope;
            }
            if ((searchScope = request2.getInjectionSearchScope()) == null || (searchScope = searchScope.intersectWith(inputScope)) == null) {
                searchScope = inputScope;
            }
            SearchScope injectionSearchScope = searchScope;
            LeafOccurrenceMapper mapper = new CodeReferenceMapper((Pointer<? extends Symbol>)targetPointer, searcher);
            SearchWordQueryBuilder builder2 = service.searchWord(project, request2.getSearchString());
            Collection collection = result2;
            Query query = builder2.inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope(searchScope2).inFilesWithLanguage(language).buildQuery(mapper);
            boolean bl2 = false;
            collection.add(query);
            collection = result2;
            query = builder2.inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]).inScope(injectionSearchScope).inInjections(language).buildQuery(mapper);
            bl2 = false;
            collection.add(query);
        }
        ExternalReferenceMapper mapper = new ExternalReferenceMapper((Pointer<? extends Symbol>)targetPointer);
        for (PsiSymbolReferenceProviderBean providerBean : ReferenceProviders.byTargetClass(target2.getClass())) {
            Collection requests = ((PsiSymbolReferenceProvider)providerBean.getInstance()).getSearchRequests(project, target2);
            for (SearchRequest request3 : requests) {
                SearchScope searchScope;
                SearchScope searchScope4;
                Language language = providerBean.getHostLanguage();
                SearchScope searchScope5 = request3.getSearchScope();
                if (searchScope5 == null || (searchScope5 = searchScope5.intersectWith(inputScope)) == null) {
                    searchScope5 = searchScope4 = inputScope;
                }
                if ((searchScope = request3.getInjectionSearchScope()) == null || (searchScope = searchScope.intersectWith(inputScope)) == null) {
                    searchScope = inputScope;
                }
                SearchScope injectionSearchScope = searchScope;
                SearchWordQueryBuilder builder3 = service.searchWord(project, request3.getSearchString()).inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]);
                Collection collection = result2;
                Query query = builder3.inScope(searchScope4).inFilesWithLanguage(language).buildQuery((LeafOccurrenceMapper)mapper);
                boolean bl3 = false;
                collection.add(query);
                collection = result2;
                query = builder3.inScope(injectionSearchScope).inInjections(language).buildQuery((LeafOccurrenceMapper)mapper);
                bl3 = false;
                collection.add(query);
            }
        }
        return result2;
    }
}

