/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiElement2Declaration
implements PsiSymbolDeclaration {
    private final PsiElement myTargetElement;
    private final PsiElement myDeclaringElement;
    private final TextRange myDeclarationRange;

    PsiElement2Declaration(@NotNull PsiElement targetElement, @NotNull PsiElement declaringElement, @NotNull TextRange range2) {
        this.myTargetElement = targetElement;
        this.myDeclaringElement = declaringElement;
        this.myDeclarationRange = range2;
    }

    @NotNull
    public Symbol getSymbol() {
        return PsiSymbolService.getInstance().asSymbol(this.myTargetElement);
    }

    @NotNull
    public PsiElement getDeclaringElement() {
        return this.myDeclaringElement;
    }

    @NotNull
    public TextRange getDeclarationRange() {
        return this.myDeclarationRange;
    }

    @Nullable
    static PsiSymbolDeclaration createFromTargetPsiElement(@NotNull PsiElement targetElement) {
        PsiElement identifyingElement = PsiElement2Declaration.getIdentifyingElement(targetElement);
        if (identifyingElement != null) {
            return new PsiElement2Declaration(targetElement, identifyingElement, PsiElement2Declaration.rangeOf(identifyingElement));
        }
        return null;
    }

    @NotNull
    static PsiSymbolDeclaration createFromDeclaredPsiElement(@NotNull PsiElement declaredElement, @NotNull PsiElement declaringElement) {
        TextRange declarationRange = PsiElement2Declaration.getDeclarationRangeFromPsi(declaredElement, declaringElement);
        return new PsiElement2Declaration(declaredElement, declaringElement, declarationRange);
    }

    @NotNull
    private static TextRange getDeclarationRangeFromPsi(@NotNull PsiElement declaredElement, @NotNull PsiElement declaringElement) {
        PsiElement identifyingElement = PsiElement2Declaration.getIdentifyingElement(declaredElement);
        if (identifyingElement == null) {
            return PsiElement2Declaration.rangeOf(declaringElement);
        }
        TextRange identifyingRange = PsiElement2Declaration.relateRange(identifyingElement, PsiElement2Declaration.rangeOf(identifyingElement), declaringElement);
        if (identifyingRange == null) {
            return PsiElement2Declaration.rangeOf(declaringElement);
        }
        return identifyingRange;
    }

    @Nullable
    static PsiSymbolDeclaration createFromPom(@NotNull PomTarget target2, @NotNull PsiElement declaringElement) {
        TextRange declarationRange = PsiElement2Declaration.getDeclarationRangeFromPom(target2, declaringElement);
        if (declarationRange == null) {
            return null;
        }
        return new PsiElement2Declaration(PomService.convertToPsi((Project)declaringElement.getProject(), (PomTarget)target2), declaringElement, declarationRange);
    }

    @Nullable
    private static TextRange getDeclarationRangeFromPom(@NotNull PomTarget target2, @NotNull PsiElement declaringElement) {
        PsiDeclaredTarget declaredTarget;
        TextRange nameIdentifierRange;
        if (target2 instanceof PsiDeclaredTarget && (nameIdentifierRange = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            PsiElement navigationElement = declaredTarget.getNavigationElement();
            return PsiElement2Declaration.relateRange(navigationElement, nameIdentifierRange, declaringElement);
        }
        return PsiElement2Declaration.rangeOf(declaringElement);
    }

    @Nullable
    private static PsiElement getIdentifyingElement(@NotNull PsiElement targetElement) {
        if (targetElement instanceof PsiNameIdentifierOwner) {
            return PsiElement2Declaration.getIdentifyingElement((PsiNameIdentifierOwner)targetElement);
        }
        return null;
    }

    @Nullable
    private static PsiElement getIdentifyingElement(@NotNull PsiNameIdentifierOwner nameIdentifierOwner) {
        PsiElement identifyingElement = nameIdentifierOwner.getNameIdentifier();
        if (identifyingElement == null) {
            return null;
        }
        TextRange identifyingElementRange = identifyingElement.getTextRange();
        if (identifyingElementRange == null) {
            return null;
        }
        return identifyingElement;
    }

    @Nullable
    private static TextRange relateRange(@NotNull PsiElement identifyingElement, @NotNull TextRange rangeInIdentifyingElement, @NotNull PsiElement declaringElement) {
        if (identifyingElement == declaringElement) {
            return rangeInIdentifyingElement;
        }
        if (identifyingElement.getContainingFile() == declaringElement.getContainingFile()) {
            TextRange rangeInFile = rangeInIdentifyingElement.shiftRight(identifyingElement.getTextRange().getStartOffset());
            TextRange declaringElementRange = declaringElement.getTextRange();
            if (declaringElementRange.contains(rangeInFile)) {
                return rangeInFile.shiftLeft(declaringElementRange.getStartOffset());
            }
            return null;
        }
        return null;
    }

    @NotNull
    private static TextRange rangeOf(@NotNull PsiElement element2) {
        return TextRange.from((int)0, (int)element2.getTextLength());
    }
}

