/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelPatch;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public class ModelBranchImpl
implements ModelBranch {
    private final Map<VirtualFile, VirtualFile> myVFileCopies = new HashMap<VirtualFile, VirtualFile>();
    private final Map<Document, List<DocumentEvent>> myDocumentChanges = new HashMap<Document, List<DocumentEvent>>();
    private final List<Runnable> myAfterMerge = new ArrayList<Runnable>();
    private final SimpleModificationTracker myFileSetChanges = new SimpleModificationTracker();
    private final Project myProject;
    private boolean myMerged;

    private ModelBranchImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<ModelBranch> action2) {
        final ModelBranchImpl branch = new ModelBranchImpl(project);
        action2.accept(branch);
        return new ModelPatch(){

            public void applyBranchChanges() {
                branch.mergeBack();
            }

            @NotNull
            public Map<VirtualFile, CharSequence> getBranchChanges() {
                HashMap<VirtualFile, CharSequence> result2 = new HashMap<VirtualFile, CharSequence>();
                for (Document document : branch.myDocumentChanges.keySet()) {
                    VirtualFile file2 = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
                    VirtualFile original = branch.findOriginalFile(file2);
                    result2.put(original, document.getImmutableCharSequence());
                }
                return result2;
            }
        };
    }

    public void runAfterMerge(@NotNull Runnable action2) {
        this.myAfterMerge.add(action2);
    }

    @NotNull
    private VirtualFile obtainFileCopy(@NotNull VirtualFile original) {
        return this.myVFileCopies.computeIfAbsent(original, __ -> {
            assert (!(original instanceof VirtualFileWindow));
            Document origDoc = FileDocumentManager.getInstance().getDocument(original);
            assert (origDoc != null);
            assert (PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(origDoc));
            BranchedVirtualFile copy2 = new BranchedVirtualFile(original, origDoc.getImmutableCharSequence(), (ModelBranch)this);
            copy2.putUserData(AbstractFileViewProvider.FREE_THREADED, (Object)true);
            this.myFileSetChanges.incModificationCount();
            Document copyDoc = FileDocumentManager.getInstance().getDocument((VirtualFile)copy2);
            assert (copyDoc != null);
            final ArrayList events = new ArrayList();
            this.myDocumentChanges.put(copyDoc, events);
            copyDoc.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    events.add(event);
                }
            });
            return copy2;
        });
    }

    @Nullable
    private PsiFile findSameLanguageRoot(@Nullable PsiFile original, @Nullable VirtualFile vFileCopy) {
        if (original == null || vFileCopy == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(vFileCopy);
        return viewProvider == null ? null : viewProvider.getPsi(original.getLanguage());
    }

    @Nullable
    public VirtualFile findFileCopy(@NotNull VirtualFile file2) {
        assert (ModelBranch.getFileBranch((VirtualFile)file2) != this);
        return this.myVFileCopies.get(file2);
    }

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T original) {
        PsiFile file2 = original.getContainingFile();
        assert (file2 != null) : original;
        VirtualFile vFileCopy = this.obtainFileCopy(file2.getViewProvider().getVirtualFile());
        PsiFile fileCopy = Objects.requireNonNull(this.findSameLanguageRoot(file2, vFileCopy));
        return (T)Objects.requireNonNull(PsiTreeUtil.findSameElementInCopy(original, (PsiFile)fileCopy));
    }

    @Nullable
    public <T extends PsiElement> T findPsiCopy(@NotNull T original) {
        PsiFile file2 = original.getContainingFile();
        if (file2 == null) {
            return null;
        }
        PsiFile fileCopy = this.findSameLanguageRoot(file2, this.findFileCopy(file2.getViewProvider().getVirtualFile()));
        return (T)(fileCopy == null ? null : PsiTreeUtil.findSameElementInCopy(original, (PsiFile)fileCopy));
    }

    @Nullable
    public <T extends PsiSymbolReference> T findReferenceCopy(@NotNull T original) {
        PsiElement psiCopy = this.findPsiCopy(original.getElement());
        if (psiCopy == null) {
            return null;
        }
        TextRange range2 = original.getRangeInElement();
        return (T)((PsiSymbolReference)ContainerUtil.find((Object[])psiCopy.getReferences(), r -> r.getClass() == original.getClass() && range2.equals((Object)r.getRangeInElement())));
    }

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T branched) {
        assert (this.myMerged);
        PsiFile branchedFile = branched.getContainingFile();
        PsiFile originalFile = this.findSameLanguageRoot(branchedFile, this.findOriginalFile(branchedFile.getViewProvider().getVirtualFile()));
        return (T)(originalFile == null ? null : PsiTreeUtil.findSameElementInCopy(branched, (PsiFile)originalFile));
    }

    @NotNull
    public VirtualFile findOriginalFile(@NotNull VirtualFile file2) {
        BranchedVirtualFile branched = (BranchedVirtualFile)file2;
        assert (branched.branch == this);
        return branched.original;
    }

    public long getBranchedPsiModificationCount() {
        return this.myFileSetChanges.getModificationCount() + this.myVFileCopies.values().stream().map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)this.myProject)).findFile(arg_0)).filter(Objects::nonNull).mapToLong(PsiFile::getModificationStamp).sum();
    }

    private void mergeBack() {
        assert (!this.myMerged);
        this.myMerged = true;
        for (Document document : this.myDocumentChanges.keySet()) {
            VirtualFile file2 = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
            DocumentImpl original = (DocumentImpl)FileDocumentManager.getInstance().getDocument(this.findOriginalFile(file2));
            assert (original != null);
            for (DocumentEvent event : this.myDocumentChanges.get(document)) {
                original.replaceString(event.getOffset(), event.getOffset() + event.getOldLength(), event.getMoveOffset(), event.getNewFragment(), LocalTimeCounter.currentTime(), false);
            }
        }
        for (Runnable runnable2 : this.myAfterMerge) {
            runnable2.run();
        }
    }

    @NotNull
    public GlobalSearchScope modifyScope(@NotNull GlobalSearchScope scope) {
        return new DelegatingGlobalSearchScope(scope, new Object[]{this, this.getBranchedPsiModificationCount()}){

            public boolean contains(@NotNull VirtualFile file2) {
                ModelBranch fileBranch = ModelBranch.getFileBranch((VirtualFile)file2);
                if (fileBranch == ModelBranchImpl.this) {
                    return super.contains(ModelBranchImpl.this.findOriginalFile(file2));
                }
                if (fileBranch == null) {
                    return ModelBranchImpl.this.findFileCopy(file2) == null && super.contains(file2);
                }
                return false;
            }

            @NotNull
            public Collection<ModelBranch> getModelBranchesAffectingScope() {
                return Collections.singleton(ModelBranchImpl.this);
            }
        };
    }

    public static boolean hasBranchedFilesInScope(@NotNull GlobalSearchScope scope) {
        return !ModelBranchImpl.processBranchedFilesInScope(scope, (Processor<? super VirtualFile>)((Processor)__ -> false));
    }

    public static boolean processBranchedFilesInScope(@NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor2) {
        Collection branches = scope.getModelBranchesAffectingScope();
        return branches.isEmpty() || ModelBranchImpl.processBranchedFilesInScope(scope, processor2, branches);
    }

    private static boolean processBranchedFilesInScope(GlobalSearchScope scope, Processor<? super VirtualFile> processor2, Collection<ModelBranch> branches) {
        for (ModelBranch branch : branches) {
            for (VirtualFile file2 : ((ModelBranchImpl)branch).myVFileCopies.values()) {
                if (!scope.contains(file2) || processor2.process((Object)file2)) continue;
                return false;
            }
        }
        return true;
    }
}

