/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileManager
implements FileManager {
    private final PsiManagerEx myManager;
    private final Map<VirtualFile, FileViewProvider> myViewProviders;

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        return new SingleRootFileViewProvider(this.myManager, file2, eventSystemEnabled);
    }

    public MockFileManager(PsiManagerEx manager) {
        this.myManager = manager;
        this.myViewProviders = ConcurrentFactoryMap.create(key -> new SingleRootFileViewProvider(this.myManager, (VirtualFile)key), ContainerUtil::createConcurrentWeakKeyWeakValueMap);
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        return this.getCachedPsiFile(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        throw new UnsupportedOperationException("Method findDirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        throw new UnsupportedOperationException("Method reloadFromDisk is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        FileViewProvider provider = this.findCachedViewProvider(vFile);
        return provider.getPsi(provider.getBaseLanguage());
    }

    @Override
    public void cleanupForNextTest() {
        this.myViewProviders.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        throw new UnsupportedOperationException("Method findViewProvider is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        return this.myViewProviders.get(file2);
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        this.myViewProviders.put(virtualFile, fileViewProvider);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        throw new UnsupportedOperationException("Method getAllCachedFiles is not yet implemented in " + this.getClass().getName());
    }
}

