/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchResultsPanel;

import com.intellij.CommonBundle;
import com.intellij.largeFilesEditor.GuiUtils;
import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.actions.FindFurtherAction;
import com.intellij.largeFilesEditor.search.actions.StopRangeSearchAction;
import com.intellij.largeFilesEditor.search.searchResultsPanel.RangeSearchCallback;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.RangeSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SingleSelectionModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeSearch
implements RangeSearchTask.Callback {
    public static final Key<RangeSearch> KEY = new Key("lfe.searchResultsToolWindow");
    private static final Logger logger = Logger.getInstance(RangeSearch.class);
    private static final String ACTION_TOOLBAR_PLACE_ID = "lfe.searchResultsToolWindow.actionToolbar";
    private static final long UNDEFINED = -1L;
    private static final int SCHEDULED_UPDATE_DELAY = 150;
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final RangeSearchCallback myRangeSearchCallback;
    private final AtomicBoolean isScheduledUpdateCalled = new AtomicBoolean(false);
    private Content myContent = null;
    private final JComponent myComponent;
    private long myLeftBorderPageNumber = -1L;
    private long myRightBorderPageNumber = -1L;
    private final CollectionListModel<SearchResult> myResultsListModel;
    private final ShowingListModel myShowingListModel;
    private final JBList<ListElementWrapper> myShowingResultsList;
    private final SimpleColoredComponent lblSearchStatusLeft;
    private final SimpleColoredComponent lblSearchStatusCenter;
    private final AnimatedProgressIcon progressIcon;
    private final ActionToolbar myActionToolbar;
    private RangeSearchTask lastExecutedRangeSearchTask;
    private boolean inBackground;
    private final List<EdtRangeSearchEventsListener> myEdtRangeSearchEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isButtonFindFurtherEnabled(boolean directionForward) {
        if (directionForward) {
            return this.myShowingListModel.btnSearchForwardWrapper.isEnabled;
        }
        return this.myShowingListModel.btnSearchBackwardWrapper.isEnabled;
    }

    public void onClickSearchFurther(boolean directionForward) {
        int listSize = this.myShowingResultsList.getItemsCount();
        if (listSize > 0) {
            int indexToSelect = directionForward ? listSize - 1 : 0;
            this.myShowingResultsList.setSelectedIndex(indexToSelect);
            this.myShowingResultsList.ensureIndexIsVisible(indexToSelect);
        }
        this.launchSearchingFurther(directionForward);
    }

    public RangeSearch(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull RangeSearchCallback rangeSearchCallback) {
        this.myVirtualFile = virtualFile;
        this.myProject = project;
        this.myRangeSearchCallback = rangeSearchCallback;
        this.lblSearchStatusLeft = new SimpleColoredComponent();
        this.lblSearchStatusLeft.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.lblSearchStatusCenter = new SimpleColoredComponent();
        this.progressIcon = new AnimatedProgressIcon();
        this.myResultsListModel = new CollectionListModel((Object[])new SearchResult[0]);
        this.myShowingListModel = new ShowingListModel(this.myResultsListModel);
        this.myShowingResultsList = new JBList((ListModel)this.myShowingListModel);
        this.myShowingResultsList.setSelectionModel((ListSelectionModel)new SingleSelectionModel());
        this.myShowingResultsList.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = RangeSearch.this.myShowingResultsList.locationToIndex(e.getPoint())) != -1) {
                    ListElementWrapper element2 = (ListElementWrapper)RangeSearch.this.myShowingResultsList.getModel().getElementAt(index);
                    element2.onSelected();
                }
            }
        });
        this.myShowingResultsList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ListElementWrapper element2;
                if (e.getKeyCode() == 10 && (element2 = (ListElementWrapper)RangeSearch.this.myShowingResultsList.getSelectedValue()) != null) {
                    element2.onSelected();
                }
            }
        });
        this.myShowingResultsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<ListElementWrapper>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ListElementWrapper> list2, ListElementWrapper value2, int index, boolean selected2, boolean hasFocus) {
                value2.render(this, selected2, hasFocus);
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FindFurtherAction(false, this));
        actionGroup.add((AnAction)new FindFurtherAction(true, this));
        actionGroup.add((AnAction)new Separator());
        actionGroup.add((AnAction)new StopRangeSearchAction(this));
        this.myActionToolbar = ActionManager.getInstance().createActionToolbar(ACTION_TOOLBAR_PLACE_ID, (ActionGroup)actionGroup, false);
        this.myComponent = new JPanel();
        JPanel panelHeader = new JPanel();
        FlowLayout panelHeaderFlowLayout = new FlowLayout();
        panelHeaderFlowLayout.setAlignment(0);
        panelHeaderFlowLayout.setHgap(0);
        panelHeader.setLayout(panelHeaderFlowLayout);
        panelHeader.add((Component)this.lblSearchStatusLeft);
        panelHeader.add((Component)this.lblSearchStatusCenter);
        panelHeader.add((Component)((Object)this.progressIcon));
        this.myActionToolbar.setTargetComponent(this.myComponent);
        JPanel panelResultsList = new JPanel();
        JBScrollPane resultsListScrollPane = new JBScrollPane();
        resultsListScrollPane.setViewportView(this.myShowingResultsList);
        panelResultsList.setLayout(new BorderLayout());
        panelResultsList.add((Component)resultsListScrollPane, "Center");
        this.myComponent.setLayout(new BorderLayout());
        this.myComponent.add((Component)panelHeader, "North");
        this.myComponent.add((Component)this.myActionToolbar.getComponent(), "West");
        this.myComponent.add((Component)panelResultsList, "Center");
        UIUtil.removeScrollBorder((Component)resultsListScrollPane);
        GuiUtils.setStandardSizeForPanel(panelHeader, true);
        GuiUtils.setStandardLineBorderToPanel(panelHeader, 0, 0, 1, 0);
        GuiUtils.setStandardLineBorderToPanel(panelResultsList, 0, 1, 0, 0);
    }

    public void setContent(Content content2) {
        this.myContent = content2;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public int getAmountOfStoredSearchResults() {
        return this.myResultsListModel.getSize();
    }

    public void setLeftBorderPageNumber(long leftBorderPageNumber) {
        this.myLeftBorderPageNumber = leftBorderPageNumber;
        this.callScheduledUpdate();
    }

    public void setRightBorderPageNumber(long rightBorderPageNumber) {
        this.myRightBorderPageNumber = rightBorderPageNumber;
        this.callScheduledUpdate();
    }

    public void setAdditionalStatusText(@Nullable String statusText) {
        this.lblSearchStatusCenter.clear();
        if (statusText != null) {
            this.lblSearchStatusCenter.append(statusText);
        }
        this.callScheduledUpdate();
    }

    public void addSearchResultsIntoBeginning(List<SearchResult> searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return;
        }
        int oldSelectedIndex = this.myShowingResultsList.getSelectedIndex();
        ListElementWrapper oldSelectedValue = (ListElementWrapper)this.myShowingResultsList.getSelectedValue();
        this.myResultsListModel.addAll(0, searchResults);
        if (this.myShowingResultsList.getSelectedValue() != oldSelectedValue) {
            for (int i2 = -1; i2 <= 1; ++i2) {
                int probablySelectedIndex = oldSelectedIndex + searchResults.size() + i2;
                if (this.myShowingListModel.getElementAt(probablySelectedIndex) != oldSelectedValue) continue;
                this.myShowingResultsList.setSelectedIndex(probablySelectedIndex);
                break;
            }
        }
        Rectangle cellBounds = this.myShowingResultsList.getCellBounds(0, 0);
        int cellHeight = cellBounds.height;
        int additionalHeight = cellHeight * searchResults.size();
        Rectangle visibleRect = this.myShowingResultsList.getVisibleRect();
        visibleRect.y += additionalHeight;
        this.myShowingResultsList.scrollRectToVisible(visibleRect);
    }

    public void addSearchResultsIntoEnd(List<SearchResult> searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return;
        }
        int oldSelectedIndex = this.myShowingResultsList.getSelectedIndex();
        this.myResultsListModel.add(searchResults);
        if (this.myShowingResultsList.getSelectedIndex() != oldSelectedIndex) {
            this.myShowingResultsList.setSelectedIndex(oldSelectedIndex);
        }
    }

    public void updateTabName() {
        if (this.myContent != null && this.lastExecutedRangeSearchTask != null) {
            String name = EditorBundle.message((String)"large.file.editor.tab.name.some.string.in.some.file", (Object[])new Object[]{this.lastExecutedRangeSearchTask.getOptions().stringToFind, this.myVirtualFile.getName()});
            this.myContent.setDisplayName(name);
            this.myContent.setDescription(name);
        }
    }

    public void callScheduledUpdate() {
        if (this.isScheduledUpdateCalled.compareAndSet(false, true)) {
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                this.isScheduledUpdateCalled.set(false);
                this.updateInEdt();
            }, 150L, TimeUnit.MILLISECONDS);
        }
    }

    private void updateInEdt() {
        try {
            FileDataProviderForSearch fileDataProviderForSearch = this.myRangeSearchCallback.getFileDataProviderForSearch(false, this.myProject, this.myVirtualFile);
            if (fileDataProviderForSearch != null) {
                this.myShowingListModel.setSearchFurtherBtnsEnabled(false, this.canFindFurtherBackward());
                this.myShowingListModel.setSearchFurtherBtnsEnabled(true, this.canFindFurtherForward(fileDataProviderForSearch));
            } else {
                this.myShowingListModel.setSearchFurtherBtnsEnabled(false, false);
                this.myShowingListModel.setSearchFurtherBtnsEnabled(true, false);
            }
        }
        catch (IOException e) {
            logger.info((Throwable)e);
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.working.with.file.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
        }
        this.updateTabName();
        this.updateStatusStringInfo();
        this.myActionToolbar.updateActionsImmediately();
        SwingUtilities.updateComponentTreeUI(this.myShowingResultsList);
        this.progressIcon.update();
    }

    private boolean canFindFurtherBackward() {
        return this.myLeftBorderPageNumber != -1L && this.myLeftBorderPageNumber > 0L;
    }

    private boolean canFindFurtherForward(FileDataProviderForSearch fileDataProviderForSearch) throws IOException {
        long pagesAmount = fileDataProviderForSearch.getPagesAmount();
        return this.myRightBorderPageNumber != -1L && this.myRightBorderPageNumber < pagesAmount - 1L;
    }

    private void launchSearchingFurther(boolean directionForward) {
        SearchTaskOptions newOptions;
        FileDataProviderForSearch fileDataProviderForSearch = this.myRangeSearchCallback.getFileDataProviderForSearch(true, this.myProject, this.myVirtualFile);
        if (fileDataProviderForSearch == null) {
            logger.warn("Can't open Large File Editor for target file.");
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.open.large.file.editor.for.target.file", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        try {
            newOptions = this.lastExecutedRangeSearchTask.getOptions().clone();
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Throwable)e);
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.cant.launch.searching.because.of.unexpected.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        newOptions.setCriticalAmountOfSearchResults(this.myResultsListModel.getSize() + 1000);
        if (directionForward) {
            newOptions.setSearchDirectionForward(true).setSearchBounds(this.myRightBorderPageNumber + 1L, -1, -1L, -1);
        } else {
            newOptions.setSearchDirectionForward(false).setSearchBounds(-1L, -1, this.myLeftBorderPageNumber - 1L, -1);
        }
        this.runSearchTask(newOptions, fileDataProviderForSearch);
    }

    private void updateStatusStringInfo() {
        this.lblSearchStatusLeft.clear();
        long pagesAmount = -1L;
        FileDataProviderForSearch fileDataProviderForSearch = this.myRangeSearchCallback.getFileDataProviderForSearch(false, this.myProject, this.myVirtualFile);
        if (fileDataProviderForSearch != null) {
            try {
                pagesAmount = fileDataProviderForSearch.getPagesAmount();
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
        }
        String newStatus = pagesAmount == -1L || this.myRightBorderPageNumber == -1L || this.myLeftBorderPageNumber == -1L ? EditorBundle.message((String)"large.file.editor.message.found.some.matches", (Object[])new Object[]{this.getAmountOfStoredSearchResults()}) : (this.myLeftBorderPageNumber == 0L && this.myRightBorderPageNumber == pagesAmount - 1L ? EditorBundle.message((String)"large.file.editor.message.found.some.matches.in.the.whole.file", (Object[])new Object[]{this.getAmountOfStoredSearchResults()}) : EditorBundle.message((String)"large.file.editor.message.found.some.matches.in.some.bounds.of.file", (Object[])new Object[]{this.getAmountOfStoredSearchResults(), Utils.calculatePagePositionPercent(this.myLeftBorderPageNumber, pagesAmount), Utils.calculatePagePositionPercent(this.myRightBorderPageNumber, pagesAmount)}));
        this.lblSearchStatusLeft.append(newStatus);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void runNewSearch(SearchTaskOptions options2, FileDataProviderForSearch fileDataProviderForSearch) {
        this.runNewSearch(options2, fileDataProviderForSearch, true);
    }

    public void runNewSearch(SearchTaskOptions options2, FileDataProviderForSearch fileDataProviderForSearch, boolean inBackground) {
        long pagesAmount;
        this.inBackground = inBackground;
        try {
            pagesAmount = fileDataProviderForSearch.getPagesAmount();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.working.with.file.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        long initialBorderPageNumber = options2.searchForwardDirection ? (options2.leftBoundPageNumber == -1L ? 0L : options2.leftBoundPageNumber) : (options2.rightBoundPageNumber == -1L ? pagesAmount - 1L : options2.rightBoundPageNumber);
        this.setLeftBorderPageNumber(initialBorderPageNumber);
        this.setRightBorderPageNumber(initialBorderPageNumber);
        this.runSearchTask(options2, fileDataProviderForSearch);
    }

    private void runSearchTask(SearchTaskOptions searchTaskOptions, FileDataProviderForSearch fileDataProviderForSearch) {
        RangeSearchTask newRangeSearchTask;
        this.lastExecutedRangeSearchTask = newRangeSearchTask = new RangeSearchTask(searchTaskOptions, this.myProject, fileDataProviderForSearch, this);
        if (this.inBackground) {
            String title = newRangeSearchTask.getTitleForBackgroundableTask();
            Task.Backgroundable task2 = new Task.Backgroundable(null, title, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    newRangeSearchTask.setProgressIndicator(indicator);
                    newRangeSearchTask.run();
                }
            };
            ProgressManager.getInstance().run((Task)task2);
            this.setAdditionalStatusText(null);
        } else {
            newRangeSearchTask.run();
        }
    }

    @Override
    public void tellSearchIsFinished(RangeSearchTask caller, long lastScannedPageNumber) {
        if (this.inBackground) {
            ApplicationManager.getApplication().invokeLater(() -> this.onSearchIsFinished(caller, lastScannedPageNumber));
        } else {
            this.onSearchIsFinished(caller, lastScannedPageNumber);
        }
    }

    protected void onSearchIsFinished(RangeSearchTask caller, long lastScannedPageNumber) {
        SearchTaskOptions options2 = caller.getOptions();
        if (!caller.isShouldStop()) {
            if (options2.searchForwardDirection) {
                this.setRightBorderPageNumber(lastScannedPageNumber);
            } else {
                this.setLeftBorderPageNumber(lastScannedPageNumber);
            }
            this.setAdditionalStatusText(EditorBundle.message((String)"large.file.editor.message.search.complete", (Object[])new Object[0]));
        }
        this.callScheduledUpdate();
        this.fireSearchFinished();
    }

    private void fireSearchFinished() {
        for (EdtRangeSearchEventsListener listener2 : this.myEdtRangeSearchEventsListeners) {
            listener2.onSearchFinished();
        }
    }

    @Override
    public void tellFrameSearchResultsFound(RangeSearchTask caller, long curPageNumber, ArrayList<SearchResult> allMatchesAtFrame) {
        if (this.inBackground) {
            ApplicationManager.getApplication().invokeLater(() -> this.onFrameSearchResultsFound(caller, curPageNumber, allMatchesAtFrame));
        } else {
            this.onFrameSearchResultsFound(caller, curPageNumber, allMatchesAtFrame);
        }
    }

    protected void onFrameSearchResultsFound(RangeSearchTask caller, long curPageNumber, ArrayList<SearchResult> allMatchesAtFrame) {
        if (caller != this.lastExecutedRangeSearchTask || caller.isShouldStop()) {
            return;
        }
        SearchTaskOptions options2 = caller.getOptions();
        if (options2.searchForwardDirection) {
            this.addSearchResultsIntoEnd(allMatchesAtFrame);
            this.setRightBorderPageNumber(curPageNumber);
        } else {
            this.addSearchResultsIntoBeginning(allMatchesAtFrame);
            this.setLeftBorderPageNumber(curPageNumber);
        }
        if (this.getAmountOfStoredSearchResults() > options2.criticalAmountOfSearchResults) {
            this.stopSearchTaskIfItExists();
            this.setAdditionalStatusText(EditorBundle.message((String)"large.file.editor.message.search.stopped.because.too.many.results.were.found", (Object[])new Object[0]));
            this.callScheduledUpdate();
        }
    }

    @Override
    public void tellSearchIsStopped(long curPageNumber) {
        this.callScheduledUpdate();
        if (!this.myEdtRangeSearchEventsListeners.isEmpty()) {
            if (this.inBackground) {
                ApplicationManager.getApplication().invokeLater(() -> this.fireSearchStopped());
            } else {
                this.fireSearchStopped();
            }
        }
    }

    protected void fireSearchStopped() {
        for (EdtRangeSearchEventsListener listener2 : this.myEdtRangeSearchEventsListeners) {
            listener2.onSearchStopped();
        }
    }

    @Override
    public void tellSearchCatchedException(RangeSearchTask caller, IOException e) {
        if (this.inBackground) {
            ApplicationManager.getApplication().invokeLater(() -> this.onSearchCatchedException(caller, e));
        } else {
            this.onSearchCatchedException(caller, e);
        }
    }

    protected void onSearchCatchedException(RangeSearchTask caller, IOException e) {
        if (!caller.isShouldStop()) {
            this.setAdditionalStatusText(EditorBundle.message((String)"large.file.editor.message.search.stopped.because.something.went.wrong", (Object[])new Object[0]));
            logger.warn((Throwable)e);
        }
    }

    private void stopSearchTaskIfItExists() {
        if (this.lastExecutedRangeSearchTask != null) {
            this.lastExecutedRangeSearchTask.shouldStop();
        }
    }

    public RangeSearchTask getLastExecutedRangeSearchTask() {
        return this.lastExecutedRangeSearchTask;
    }

    public void dispose() {
        if (this.lastExecutedRangeSearchTask != null) {
            this.lastExecutedRangeSearchTask.shouldStop();
        }
    }

    void addEdtRangeSearchEventsListener(EdtRangeSearchEventsListener listener2) {
        this.myEdtRangeSearchEventsListeners.add(listener2);
    }

    void removeEdtRangeSearchEventsListener(EdtRangeSearchEventsListener listener2) {
        this.myEdtRangeSearchEventsListeners.remove(listener2);
    }

    public List<SearchResult> getSearchResultsList() {
        return this.myResultsListModel.getItems();
    }

    static interface EdtRangeSearchEventsListener {
        public void onSearchStopped();

        public void onSearchFinished();
    }

    private class AnimatedProgressIcon
    extends AsyncProcessIcon {
        AnimatedProgressIcon() {
            super("");
        }

        void update() {
            boolean enabled = false;
            if (RangeSearch.this.lastExecutedRangeSearchTask != null && !RangeSearch.this.lastExecutedRangeSearchTask.isFinished() && !RangeSearch.this.lastExecutedRangeSearchTask.isShouldStop()) {
                enabled = true;
            }
            this.setVisible(enabled);
            if (enabled) {
                this.resume();
            } else {
                this.suspend();
            }
        }
    }

    private class ShowingListModel
    implements ListModel<ListElementWrapper> {
        private final CollectionListModel<SearchResult> mySearchResultsListModel;
        private final SearchFurtherBtnWrapper btnSearchBackwardWrapper;
        private final SearchFurtherBtnWrapper btnSearchForwardWrapper;

        ShowingListModel(CollectionListModel<SearchResult> model) {
            this.btnSearchBackwardWrapper = new SearchFurtherBtnWrapper(false);
            this.btnSearchForwardWrapper = new SearchFurtherBtnWrapper(true);
            this.mySearchResultsListModel = model;
        }

        @Override
        public int getSize() {
            int resultSize = this.mySearchResultsListModel.getSize();
            if (this.btnSearchBackwardWrapper.isEnabled) {
                ++resultSize;
            }
            if (this.btnSearchForwardWrapper.isEnabled) {
                ++resultSize;
            }
            return resultSize;
        }

        @Override
        public ListElementWrapper getElementAt(int index) {
            if (this.btnSearchBackwardWrapper.isEnabled) {
                if (index == 0) {
                    return this.btnSearchBackwardWrapper;
                }
                if (index == this.mySearchResultsListModel.getSize() + 1) {
                    return this.btnSearchForwardWrapper;
                }
                return new SearchResultWrapper((SearchResult)this.mySearchResultsListModel.getElementAt(index - 1));
            }
            if (index == this.mySearchResultsListModel.getSize()) {
                return this.btnSearchForwardWrapper;
            }
            return new SearchResultWrapper((SearchResult)this.mySearchResultsListModel.getElementAt(index));
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.mySearchResultsListModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.mySearchResultsListModel.removeListDataListener(l);
        }

        void setSearchFurtherBtnsEnabled(boolean forwardDirection, boolean enabled) {
            if (forwardDirection) {
                this.btnSearchForwardWrapper.setEnabled(enabled);
            } else {
                this.btnSearchBackwardWrapper.setEnabled(enabled);
            }
        }
    }

    private class SearchFurtherBtnWrapper
    implements ListElementWrapper {
        private final SimpleTextAttributes linkText = new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkPressedColor());
        private final boolean isForwardDirection;
        private boolean isEnabled = false;

        SearchFurtherBtnWrapper(boolean isForwardDirection) {
            this.isForwardDirection = isForwardDirection;
        }

        @Override
        public void render(ColoredListCellRenderer coloredListCellRenderer, boolean selected2, boolean hasFocus) {
            String text = this.isForwardDirection ? EditorBundle.message((String)"large.file.editor.text.find.next.matches", (Object[])new Object[0]) : EditorBundle.message((String)"large.file.editor.text.find.previous.matches", (Object[])new Object[0]);
            if (selected2) {
                coloredListCellRenderer.append(text);
            } else {
                coloredListCellRenderer.append(text, this.linkText);
            }
            coloredListCellRenderer.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
        }

        @Override
        public void onSelected() {
            if (this.isEnabled) {
                RangeSearch.this.onClickSearchFurther(this.isForwardDirection);
            } else {
                logger.warn("[Large File Editor Subsystem] SearchResultsToolWindow.SearchFurtherBtnWrapper.onSelected(): called onSelected() on disabled element, which should be hidden.");
            }
        }

        void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }
    }

    private class SearchResultWrapper
    implements ListElementWrapper {
        private final SimpleTextAttributes attrForMatchers = new SimpleTextAttributes(64, null);
        private final SearchResult mySearchResult;

        SearchResultWrapper(SearchResult mySearchResult) {
            this.mySearchResult = mySearchResult;
        }

        @Override
        public void render(ColoredListCellRenderer coloredListCellRenderer, boolean selected2, boolean hasFocus) {
            coloredListCellRenderer.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
            coloredListCellRenderer.append(this.mySearchResult.contextPrefix);
            coloredListCellRenderer.append(this.mySearchResult.foundString, this.attrForMatchers);
            coloredListCellRenderer.append(this.mySearchResult.contextPostfix);
        }

        @Override
        public void onSelected() {
            RangeSearch.this.myRangeSearchCallback.showResultInEditor(this.mySearchResult, RangeSearch.this.myProject, RangeSearch.this.myVirtualFile);
        }
    }

    private static interface ListElementWrapper {
        public void render(ColoredListCellRenderer var1, boolean var2, boolean var3);

        public void onSelected();
    }
}

